<?php
/**
 * Relation abstraction class file.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Relation;

use App\Db;
use App\QueryGenerator;

/**
 * Relation abstraction class.
 */
abstract class RelationAbstraction implements RelationInterface
{
	/**
	 * Relation model instance.
	 *
	 * @var \Vtiger_Relation_Model Relation model instance by reference
	 */
	public $relationModel;

	public function getQueryForReport(QueryGenerator $queryGenerator): void
	{
		$parentModuleModel = $this->relationModel->getParentModuleModel();
		$referenceInfo = \Vtiger_Relation_Model::getReferenceTableInfo(
			$parentModuleModel->getName(),
			$this->relationModel->getRelationModuleName(),
		);

		$dbSchema = Db::getInstance()->getSchema();
		if (null === $dbSchema->getTableSchema($tableName = $referenceInfo['table'])) {
			throw new \Exception('Custom table not found');
		}

		$referenceModuleTable = $this->relationModel->getRelationModuleModel()->getBaseTableName();
		$queryGenerator
			->addJoin(
				[
					'LEFT JOIN',
					$tableName,
					sprintf('%s.%s = vtiger_crmentity.crmid', $tableName, $referenceInfo['rel']),
				],
			)
			->addJoin(
				[
					'LEFT JOIN',
					$referenceModuleTable,
					sprintf(
						'%s.%s = %s.%s',
						$referenceModuleTable,
						$this->relationModel->getRelationModuleModel()->getBaseTableIndex(),
						$tableName,
						$referenceInfo['base'],
					),
				],
			)->setDistinct('id');
	}
}
