<?php
/**
 * OSSMail autologin model class.
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 */

use App\Mail\Account\Repository\AutologinRepository;
use App\User;

/**
 * OSSMail autologin model class.
 */
class OSSMail_Autologin_Model
{
	/**
	 * Get autologin users.
	 *
	 * @return array
	 */
	public static function getAutologinUsers(): array
	{
		$userId = User::getCurrentUserId();
		$realUserId = User::getCurrentUserRealId();
		$accountRepository = new AutologinRepository();

		return $accountRepository->getAllByUserId($userId, $userId === $realUserId);
	}

	/**
	 * Update last active mail.
	 *
	 * @param int $user
	 *
	 * @return void
	 */
	public static function updateActive(int $user)
	{
		$dbCommand = \App\Db::getInstance()->createCommand();
		$dbCommand->update('roundcube_users_autologin', ['active' => 0], ['crmuser_id' => App\User::getCurrentUserId()])->execute();
		$dbCommand->update('roundcube_users_autologin', ['active' => 1], ['rcuser_id' => $user, 'crmuser_id' => App\User::getCurrentUserId()])->execute();
	}
}
