<?php

/**
 * MailSmtp run test action file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Request;

/**
 * MailSmtp run test action class.
 */
class Settings_MailSmtp_RunTest_Action extends Settings_Vtiger_Basic_Action
{
	/** {@inheritDoc} */
	public function process(Request $request)
	{
		$recordModel = $this->getRecordModelFromRequest($request);
		$response = new Vtiger_Response();
		$response->setResult($recordModel->runTest());
		$response->emit();
	}

	/**
	 * Function to get the record model based on the request parameters.
	 *
	 * @param Request $request
	 *
	 * @return Settings_MailSmtp_Record_Model
	 */
	protected function getRecordModelFromRequest(Request $request)
	{
		if ($request->isEmpty('record')) {
			$recordModel = Settings_MailSmtp_Record_Model::getCleanInstance();
		} else {
			$recordModel = Settings_MailSmtp_Record_Model::getInstanceById($request->getInteger('record'));
		}
		$recordModel->setDataFromRequest($request);

		return $recordModel;
	}
}
