'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Constructor}function _defineProperty(obj,key,value){return key=_toPropertyKey(key),key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}var CustomView=/*#__PURE__*/function(){function CustomView(url){var _this=this;_classCallCheck(this,CustomView);var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});app.showModalWindow(null,url,function(){//This will store the columns selection container
_this.modalContainer=$(".js-filter-modal__container"),_this.advanceFilterInstance=new Vtiger_ConditionBuilder_Js(_this.modalContainer.find(".js-condition-builder-view .js-condition-builder"),_this.modalContainer.find("#sourceModule").val()),_this.advanceFilterInstance.registerEvents(),CustomView.registerAdvancedConditionsEvents(_this.modalContainer),_this.columnSelectElement=!1,_this.registerEvents(),progressIndicatorElement.progressIndicator({mode:"hide"});});}/** @type {Vtiger_ConditionBuilder_Js} Condition builder object */return _createClass(CustomView,[{key:"loadDateFilterValues",value:function loadDateFilterValues(){var selectedDateFilter=$("#standardDateFilter option:selected"),currentDate=selectedDateFilter.data("currentdate"),endDate=selectedDateFilter.data("enddate");$("#standardFilterCurrentDate").val(currentDate),$("#standardFilterEndDate").val(endDate);}/**
	 * Function to get the contents container
	 * @return : jQuery object of contents container
	 */},{key:"getContentsContainer",value:function getContentsContainer(){return this.modalContainer||(this.modalContainer=$(".js-filter-modal__container")),this.modalContainer}/**
	 * Function to get the view columns selection element
	 * @return : jQuery object of view columns selection element
	 */},{key:"getColumnSelectElement",value:function getColumnSelectElement(){return this.columnSelectElement||(this.columnSelectElement=$("#viewColumnsSelect")),this.columnSelectElement}/**
	 * Function which will get the selected columns
	 * @return : array of selected values
	 */},{key:"getSelectedColumns",value:function getSelectedColumns(){var columnListSelectElement=this.getColumnSelectElement();return columnListSelectElement.val()}/**
	 * Get custom labels
	 * @returns array
	 */},{key:"getCustomLabels",value:function getCustomLabels(){var customFieldNames={};return this.getContentsContainer().find(".js-short-label").each(function(){customFieldNames[$(this).attr("data-field-value")]=$(this).val();}),customFieldNames}},{key:"saveFilter",value:function saveFilter(){var aDeferred=$.Deferred(),formData=$("#CustomView").serializeFormData();return AppConnector.request(formData,!0).done(function(data){aDeferred.resolve(data);}).fail(function(error){aDeferred.reject(error);}),aDeferred.promise()}},{key:"saveAndViewFilter",value:function saveAndViewFilter(){this.saveFilter().done(function(data){var response=data.result;if(response&&response.success){var url;url="Settings"==app.getParentModuleName()?"index.php?module=CustomView&parent=Settings&view=Index&sourceModule="+$("#sourceModule").val():response.listviewurl,window.location.href=url;}else $.unblockUI(),app.showNotify({title:response.message?response.message:app.vtranslate("JS_ERROR"),text:response.message,type:"error"});}).fail(function(error){app.showNotify({title:error,type:"error"});});}},{key:"registerIconEvents",value:function registerIconEvents(){this.getContentsContainer().find(".js-filter-preferences").on("change",".js-filter-preference",function(e){var currentTarget=$(e.currentTarget),iconElement=currentTarget.next();currentTarget.prop("checked")?iconElement.removeClass(iconElement.data("unchecked")).addClass(iconElement.data("check")):iconElement.removeClass(iconElement.data("check")).addClass(iconElement.data("unchecked"));});}},{key:"registerColorEvent",value:function registerColorEvent(){var container=this.getContentsContainer(),picker=container.find(".js-color-picker"),pickerField=picker.find(".js-color-picker__field");picker.on("click",function showPicker(){App.Fields.Colors.showPicker({color:pickerField.val(),bgToUpdate:picker.find(".js-color-picker__color"),fieldToUpdate:pickerField});});}/**
	 * Get list of fields to duplicates
	 * @returns {Array}
	 */},{key:"getDuplicateFields",value:function getDuplicateFields(){var fields=[],container=this.getContentsContainer();return container.find(".js-duplicates-container .js-duplicates-row").each(function(){fields.push({fieldid:$(this).find(".js-duplicates-field").val(),ignore:$(this).find(".js-duplicates-ignore").is(":checked")});}),fields}/**
	 * Register events for block "Find duplicates"
	 */},{key:"registerDuplicatesEvents",value:function registerDuplicatesEvents(){var container=this.getContentsContainer();App.Fields.Picklist.showSelect2ElementView(container.find(".js-duplicates-container .js-duplicates-field")),container.on("click",".js-duplicates-remove",function(){$(this).closest(".js-duplicates-row").remove();}),container.find(".js-duplicate-add-field").on("click",function(){var template=container.find(".js-duplicates-field-template").clone();template.removeClass("d-none"),template.removeClass("js-duplicates-field-template"),App.Fields.Picklist.showSelect2ElementView(template.find(".js-duplicates-field")),container.find(".js-duplicates-container").append(template);});}},{key:"registerSubmitEvent",value:function registerSubmitEvent(select2Element){var _this2=this;$("#CustomView").on("submit",function(e){var form=$(e.currentTarget),selectElement=_this2.getColumnSelectElement();if(100<$("#viewname").val().length)return app.showNotify({title:app.vtranslate("JS_MESSAGE"),text:app.vtranslate("JS_VIEWNAME_ALERT"),type:"error"}),void e.preventDefault();//Mandatory Fields selection validation
//Any one Mandatory Field should select while creating custom view.
var mandatoryFieldsList=JSON.parse($("#mandatoryFieldsList").val()),selectedOptions=selectElement.val(),mandatoryFieldsMissing=!0;if(selectedOptions&&(mandatoryFieldsMissing=0>=selectedOptions.filter(function(value){return mandatoryFieldsList.includes(value)}).length),mandatoryFieldsMissing)return selectElement.validationEngine("showPrompt",app.vtranslate("JS_PLEASE_SELECT_ATLEAST_ONE_MANDATORY_FIELD"),"error","topLeft",!0),void e.preventDefault();//Mandatory Fields validation ends
select2Element.validationEngine("hide");var result=form.validationEngine("validate");if(result){//handled standard filters saved values.
var stdfilterlist={};""!=$("#standardFilterCurrentDate").val()&&""!=$("#standardFilterEndDate").val()&&"none"!=$("select.standardFilterColumn option:selected").val()&&(stdfilterlist.columnname=$("select.standardFilterColumn option:selected").val(),stdfilterlist.stdfilter=$("select#standardDateFilter option:selected").val(),stdfilterlist.startdate=$("#standardFilterCurrentDate").val(),stdfilterlist.enddate=$("#standardFilterEndDate").val(),$("#stdfilterlist").val(JSON.stringify(stdfilterlist)));//handled advanced filters saved values.
var contentContainer=_this2.getContentsContainer();return $("#advfilterlist").val(JSON.stringify(_this2.advanceFilterInstance.getConditions())),form.find("#advancedConditions").val(JSON.stringify(CustomView.getAdvancedConditions(form))),$("[name=\"duplicatefields\"]").val(JSON.stringify(_this2.getDuplicateFields())),$("input[name=\"columnslist\"]",contentContainer).val(JSON.stringify(_this2.getSelectedColumns())),contentContainer.find(".js-custom-field-names").val(JSON.stringify(_this2.getCustomLabels())),_this2.saveAndViewFilter(),!1}app.formAlignmentAfterValidation($(e.currentTarget));});}/**
	 * Block submit on press enter key
	 */},{key:"registerDisableSubmitOnEnter",value:function registerDisableSubmitOnEnter(){this.getContentsContainer().find("#viewname, [name=\"color\"]").on("keydown",function(e){"Enter"===e.key&&e.preventDefault();});}/**
	 * Function to register the advanced conditions events for customview
	 * @param {jQuery} listViewContainer
	 */},{key:"registerChangeSelectedColumns",value:/**
	 * Register change selected columns
	 */function registerChangeSelectedColumns(){var _this3=this;this.container.find(".js-view-columns-select").on("change",function(){_this3.registerAppendCustomLabels();});}/**
	 *	Register append custom labels
	 */},{key:"registerAppendCustomLabels",value:function registerAppendCustomLabels(){var shorterNamesContainer=this.container.find(".js-custom-name-fields"),selectedColumns=this.container.find(".js-view-columns-select option:selected").toArray().map(function(item){return {text:item.getAttribute("data-field-label"),value:item.value,customLabel:item.getAttribute("data-custom-label")||""}});shorterNamesContainer.empty();var newCustomLabelElement="",customLabelElement="",customLabelValue="",inputContainerElement="",inputElement="";$.each(selectedColumns,function(_index,element){newCustomLabelElement=document.createElement("div"),newCustomLabelElement.setAttribute("class","d-flex mb-1"),customLabelElement=document.createElement("div"),customLabelElement.setAttribute("class","col-form-label col-md-2 pl-0"),customLabelValue=document.createTextNode(element.text),customLabelElement.appendChild(customLabelValue),newCustomLabelElement.appendChild(customLabelElement),inputContainerElement=document.createElement("div"),inputContainerElement.setAttribute("class","col-md-4"),inputElement=document.createElement("input"),inputElement.setAttribute("type","text"),inputElement.setAttribute("class","form-control js-short-label"),inputElement.setAttribute("data-field-value",element.value),inputElement.setAttribute("data-validation-engine","validate[maxSize[50], funcCall[Vtiger_Base_Validator_Js.invokeValidation]]"),inputElement.setAttribute("data-validator","[{\"name\":\"FieldLabel\"}]"),inputElement.setAttribute("value",element.customLabel),inputContainerElement.appendChild(inputElement),newCustomLabelElement.appendChild(inputContainerElement),shorterNamesContainer.append(newCustomLabelElement);});}/**
	 * Register events
	 */},{key:"registerEvents",value:function registerEvents(){var _this4=this;this.container=this.getContentsContainer(),this.registerIconEvents(),App.Fields.Tree.register(this.getContentsContainer()),App.Tools.Form.registerBlockToggle(this.getContentsContainer()),this.registerColorEvent(),this.registerDuplicatesEvents();var select2Element=App.Fields.Picklist.showSelect2ElementView(this.getColumnSelectElement());this.registerSubmitEvent(select2Element),$(".stndrdFilterDateSelect").datepicker(),$("#standardDateFilter").on("change",function(){_this4.loadDateFilterValues();}),$("#CustomView").validationEngine(app.validationEngineOptions),this.registerDisableSubmitOnEnter(),this.registerChangeSelectedColumns(),this.registerAppendCustomLabels();}}],[{key:"registerCustomViewAdvCondEvents",value:function registerCustomViewAdvCondEvents(listViewContainer){var _this5=this;listViewContainer.on("click",".js-custom-view-adv-cond-modal",function(){var customViewAdvCond=listViewContainer.find(".js-custom-view-adv-cond"),advancedConditions=customViewAdvCond.val();advancedConditions&&(advancedConditions=JSON.parse(advancedConditions)),AppConnector.request({module:app.getModuleName(),view:"CustomViewAdvCondModal",advancedConditions:advancedConditions}).done(function(data){data&&app.showModalWindow(data,function(modalContainer){App.Tools.Form.registerBlockToggle(modalContainer),_this5.registerAdvancedConditionsEvents(modalContainer),modalContainer.find("[name=\"saveButton\"]").on("click",function(){customViewAdvCond.val(JSON.stringify(_this5.getAdvancedConditions(modalContainer))),app.hideModalWindow(),"undefined"!=typeof app.pageController.getListViewRecords&&app.pageController.getListViewRecords();});});}).fail(function(_textStatus,errorThrown){app.showNotify({textTrusted:!1,title:app.vtranslate("JS_ERROR"),text:errorThrown,type:"error"});});});}/**
	 * Function to register the advanced conditions events for custom view
	 * @param {jQuery} container
	 */},{key:"registerAdvancedConditionsEvents",value:function registerAdvancedConditionsEvents(container){var self=this,builder=container.find(".js-adv-condition-builder-view"),relationSelect=container.find(".js-relation-select");0!=relationSelect.val()&&(this.advancedConditionsBuilder=new Vtiger_ConditionBuilder_Js(builder.find(".js-condition-builder"),relationSelect.find("option:selected").data("module")),this.advancedConditionsBuilder.registerEvents()),relationSelect.on("change",function(){var moduleName=$(this).find("option:selected").data("module");builder.html(""),delete self.advancedConditionsBuilder,moduleName&&AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),view:"ConditionBuilder",mode:"builder",sourceModuleName:moduleName}).done(function(data){builder.html(data),self.advancedConditionsBuilder=new Vtiger_ConditionBuilder_Js(builder.find(".js-condition-builder"),moduleName),self.advancedConditionsBuilder.registerEvents();});});}/**
	 * Function to register the advanced conditions events for custom view
	 * @param {jQuery} container
	 * @return {object}
	 */},{key:"getAdvancedConditions",value:function getAdvancedConditions(container){var advancedConditions={relationId:container.find(".js-relation-select").val()};return container.find(".js-relation-checkbox:checked").each(function(){"undefined"==typeof advancedConditions.relationColumns&&(advancedConditions.relationColumns=[]),advancedConditions.relationColumns.push($(this).val());}),this.advancedConditionsBuilder&&(advancedConditions.relationConditions=this.advancedConditionsBuilder.getConditions()),advancedConditions}}])}();_defineProperty(CustomView,"advancedConditionsBuilder",void 0),Vtiger_Base_Validator_Js("Vtiger_FieldLabel_Validator_Js",{/** @inheritdoc */invokeValidation:function invokeValidation(field){var instance=new Vtiger_FieldLabel_Validator_Js;instance.setElement(field);var response=instance.validate();if(!0!==response)return instance.getError()}},{/** @inheritdoc */validate:function validate(){return this.validateValue(this.getFieldValue())},/** @inheritdoc */validateValue:function validateValue(fieldValue){if(/[&\<\>\:\'\"\,]/.test(fieldValue)){var errorInfo=app.vtranslate("JS_SPECIAL_CHARACTERS")+" & < > ' \" : , "+app.vtranslate("JS_NOT_ALLOWED");return this.setError(errorInfo),!1}return !0}});
//# sourceMappingURL=CustomView.min.js.map
