/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */
'use strict';

jQuery.Class(
	'Settings_Map_Config_Js',
	{},
	{
		registerTileLayer: function () {
			let tab = $('#TileLayer');
			tab.find('input').on('change', function () {
				AppConnector.request({
					module: 'Map',
					parent: 'Settings',
					action: 'Config',
					mode: 'setTileLayer',
					value: this.value
				})
					.done(function (data) {
						app.showNotify({
							text: data['result']['message'],
							type: 'success'
						});
					})
					.fail(function () {
						app.showNotify({
							text: app.vtranslate('JS_ERROR'),
							type: 'error'
						});
					});
			});
		},
		registerCoordinates: function () {
			let tab = $('#Coordinates');
			tab.find('input').on('change', function () {
				AppConnector.request({
					module: 'Map',
					parent: 'Settings',
					action: 'Config',
					mode: 'setCoordinate',
					value: this.value
				})
					.done(function (data) {
						app.showNotify({
							text: data['result']['message'],
							type: 'success'
						});
					})
					.fail(function () {
						app.showNotify({
							text: app.vtranslate('JS_ERROR'),
							type: 'error'
						});
					});
			});
		},
		registerRouting: function () {
			let tab = $('#Routing');
			tab.find('input').on('change', function () {
				AppConnector.request({
					module: 'Map',
					parent: 'Settings',
					action: 'Config',
					mode: 'setRouting',
					value: this.value
				})
					.done(function (data) {
						app.showNotify({
							text: data['result']['message'],
							type: 'success'
						});
					})
					.fail(function () {
						app.showNotify({
							text: app.vtranslate('JS_ERROR'),
							type: 'error'
						});
					});
			});
		},
		registerConfigModal() {
			$('.tab-content').find('.js-show-config-modal').on('click', (e) => {
				const tab = e.currentTarget.dataset.tab;
				const driver = e.currentTarget.dataset.driver;

				app.showModalWindow({
					url: `index.php?module=Map&parent=Settings&view=ConfigModal&tab=${tab}&driver=${driver}`,
					cb: (modalContainer) => {
						App.Fields.Password.register(modalContainer);
						modalContainer.on('click', '.js-modal__save', () => {
							let form = modalContainer.find('form');
							if (form.validationEngine('validate')) {
								let formData = form.serializeFormData();
								let progress = $.progressIndicator({
									message: app.vtranslate('JS_SAVE_LOADER_INFO'),
									blockInfo: { enabled: true }
								});

								app.saveAjax('', [], formData)
									.done(() => {
										app.showNotify({
											text: app.vtranslate('JS_SAVE_NOTIFY_OK'),
											type: 'success'
										});
									})
									.fail((textStatus, errorThrown, jqXHR) => {
										if (406 === jqXHR.status) {
											app.showNotify({
												text: app.vtranslate('JS_ERROR_VALIDATION'),
												type: 'error'
											});
										} else {
											app.showNotify({
												text: app.vtranslate('JS_ERROR'),
												type: 'error'
											});
										}
									})
									.always(() => {
										app.hideModalWindow();
										progress.progressIndicator({ mode: 'hide' });
									});
							}
						});
					}
				});
			});
		},
		registerEvents: function () {
			this.registerTileLayer();
			this.registerCoordinates();
			this.registerRouting();
			this.registerConfigModal();
		}
	}
);
