'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";$.Class("Base_TreeInventoryModal_JS",{},{/**
		 * Container
		 */container:!1,/**
		 * Tree instance
		 */treeInstance:!1,/**
		 * Set event for select row
		 * @param {function} cb
		 */setSelectEvent:function setSelectEvent(cb){this.selectEvent=cb;},/**
		 * Gets tree data
		 */getTreeData:function getTreeData(){var treeData=this.container.find(".js-tree-value").val();return treeData?JSON.parse(treeData):[]},/*
		 * Function generates a tree.
		 */generateTree:function generateTree(){if(!1==this.treeInstance){this.treeInstance=this.container.find(".js-tree-contents");this.treeInstance.jstree($.extend(!0,{core:{data:this.getTreeData(),themes:{name:"proton",responsive:!0}},checkbox:{three_state:!1},plugins:["search","category","checkbox"]},this.treeInstance.data("params")));}},/*
		 * Function looks up the entered phrases.
		 */searching:function searching(text){this.treeInstance.jstree(!0).search(text);},/*
		 * Function retrieves the search terms.
		 */registerSearchEvent:function registerSearchEvent(){var _this=this,valueSearch=this.container.find("#valueSearchTree"),btnSearch=this.container.find("#btnSearchTree");valueSearch.on("keypress",function(e){13==e.which&&_this.searching(valueSearch.val());}),btnSearch.on("click",function(){_this.searching(valueSearch.val());});},/*
		 * Function retrieves the selected records.
		 */registerSelectRecords:function registerSelectRecords(){var _this2=this;this.container.find(".js-modal__save").on("click",function(){var recordsToAdd=[];$.each(_this2.treeInstance.jstree("getCategory",!0),function(_,treeElement){"record"===treeElement.attr&&(recordsToAdd[treeElement.record_id]=treeElement.text);}),recordsToAdd.length?(_this2.selectEvent(recordsToAdd),app.hideModalWindow(!1,_this2.container.parent().attr("id"))):app.showNotify({text:app.vtranslate("JS_PLEASE_SELECT_ONE_RECORD")});});},/**
		 * Register modal events
		 */registerEvents:function registerEvents(container){this.container=container,this.generateTree(),this.registerSelectRecords(),this.registerSearchEvent();}});
//# sourceMappingURL=TreeInventoryModal.min.js.map
