<?php

namespace App\TextParser;

use App\Language;

/**
 * Table tax summary class fo correct.
 *
 * @package TextParser
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Tomasz Kur <t.kur@yetiforce.com>
 */
class TableCorrectTaxSummary extends Base
{
	/** @var string Class name */
	public $name = 'LBL_TABLE_TAX_SUMMARY_FOR_CORRECT';

	/** @var mixed Parser type */
	public $type = 'pdf';

	/** @var array Allowed modules */
	public $allowedModules = ['FCorectingInvoice'];
	/** @var array Related modules fields */
	protected $relatedModulesFields = ['FCorectingInvoice' => 'finvoiceid'];

	/**
	 * Process.
	 *
	 * @return string
	 */
	public function process()
	{
		if (!$this->textParser->recordModel || !$this->textParser->recordModel->getModule()->isInventory()) {
			return '';
		}

		$relatedRecordModel = \Vtiger_Record_Model::getInstanceById($this->textParser->recordModel->get($this->relatedModulesFields[$this->textParser->recordModel->getModuleName()]));

		$correctionTaxSummary = \Vtiger_Inventory_Model::getInstance($this->textParser->recordModel->getModuleName())
			->getCorrectionTaxSummary($relatedRecordModel, $this->textParser->recordModel);

		$html = '';
		$inventory = \Vtiger_Inventory_Model::getInstance($this->textParser->moduleName);
		$fields = $inventory->getFieldsByBlocks();
		$currencySymbol = $inventory->getCurrency($this->textParser->recordModel)['currency_symbol'] ?? '';

		if (!empty($fields[0]) && isset($correctionTaxSummary['total'])) {
			$totalValue = $correctionTaxSummary['total'];
			$taxLabel = $totalValue > 0 ? 'LBL_VAT_INCREASE_AMOUNT' : 'LBL_VAT_REDUCTION_AMOUNT';
			$html .= '
						<table class="table-correct-tax-summary" style="width:100%;vertical-align:top;border-collapse:collapse;border:1px solid #ddd;">
						<thead>
								<tr>
									<th colspan="2" style="font-weight:bold;padding:0px 4px;">' . Language::translate($taxLabel, $this->textParser->moduleName) . '</th>
								</tr>
								</thead><tbody>';

			foreach ($correctionTaxSummary['groups'] as $key => $value) {
				$html .= '<tr>
									<td class="name" style="text-align:left;font-weight:bold;padding:0px 4px;">' . $key . '</td>
									<td class="value" style="text-align:right;font-weight:bold;padding:0px 4px;">' . \CurrencyField::convertToUserFormatSymbol($value, true, $currencySymbol) . '</td>
								</tr>';
			}
			$html .= '<tr>
									<th class="name" style="text-align:left;font-weight:bold;padding:0px 4px;">' . Language::translate('LBL_AMOUNT', $this->textParser->moduleName) . '</th>
									<th class="value" style="text-align:right;font-weight:bold;padding:0px 4px;">' . \CurrencyField::convertToUserFormatSymbol($totalValue, true, $currencySymbol) . '</th>
								</tr>
								</tbody>
						</table>';
		}

		return $html;
	}
}
