{*<!-- {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} -->*}
{strip}
	{assign var=INVENTORY_MODEL value=\Vtiger_Inventory_Model::getInstance($MODULE_NAME)}
	{assign var=BASE_RECORD value=\FInvoice_Record_Model::getInstanceById($RECORD->get('finvoiceid'))}
	{assign var=CORRECTION_TAX_SUMMARY value=$INVENTORY_MODEL->getCorrectionTaxSummary($BASE_RECORD, $RECORD)}
	{assign var="INVENTORY_ROWS" value=$RECORD->getInventoryData()}
	{assign var=INVENTORY_ROW value=current($INVENTORY_ROWS)}
	{if $INVENTORY_MODEL->isField('currency')}
		{if $INVENTORY_ROW && !empty($INVENTORY_ROW['currency'])}
			{assign var="CURRENCY" value=$INVENTORY_ROW['currency']}
		{else}
			{assign var="CURRENCY" value=$BASE_CURRENCY['id']}
		{/if}
		{assign var="CURRENCY_SYMBOLAND" value=\App\Fields\Currency::getById($CURRENCY)}
	{/if}
	<div class="detailViewTable">
		<div class="js-toggle-panel c-panel">
			<div class="blockHeader c-panel__header d-flex justify-content-between">
				<div class="d-inline-flex align-items-center">
					<h5>
						<span class="menuIcon yfm-FInvoiceCost" aria-hidden="true"></span> {\App\Language::translate('LBL_CORRECTION_SUMMARY','FCorectingInvoice')}
					</h5>
					<div class="m-2">
						<span class="u-cursor-pointer js-block-toggle fas fa-angle-right d-none" data-js="click" alt="{\App\Language::translate('LBL_EXPAND_BLOCK')}" data-mode="hide"></span>
						<span class="u-cursor-pointer js-block-toggle fas fa-angle-down" data-js="click" alt="{\App\Language::translate('LBL_COLLAPSE_BLOCK')}" data-mode="show"></span>
					</div>
				</div>
			</div>
			<div class="c-panel__body blockContent p-2" data-js="container">
				<div class="row">
					{assign var="TAX_FIELD" value=$INVENTORY_MODEL->getField('tax')}
					{if $TAX_FIELD && isset($CORRECTION_TAX_SUMMARY['total'])}
						{assign var="TAXES" value=$TAX_FIELD->getTaxSummary($RECORD)}
						<div class="col-md-4">
							<table class="table inventorySummaryContainer">
								<thead>
								<tr>
									<th colspan="2">
										<img src="{\App\Layout::getImagePath('Tax24.png')}" alt="{\App\Language::translate('LBL_TAX', $MODULE_NAME)}" />&nbsp;&nbsp;
										<strong>
											{if $CORRECTION_TAX_SUMMARY['total'] < 0}
												{\App\Language::translate('LBL_VAT_REDUCTION_AMOUNT','FCorectingInvoice')}
											{else}
												{\App\Language::translate('LBL_VAT_INCREASE_AMOUNT','FCorectingInvoice')}
											{/if}
										</strong>
									</th>
								</tr>
								</thead>
								<tbody>
								{foreach item=TAX key=KEY from=$CORRECTION_TAX_SUMMARY['groups']}
									<tr>
										<td class="textAlignRight" width='70px'>
											{$KEY}
										</td>
										<td class="textAlignRight">
											{CurrencyField::convertToUserFormatSymbol($TAX, true, $CURRENCY_SYMBOLAND['currency_symbol'])}
										</td>
									</tr>
								{/foreach}
								<tr>
									<td class="textAlignRight" width='70px'>
										{\App\Language::translate('LBL_AMOUNT',$MODULE_NAME)}
									</td>
									<td class="textAlignRight">
										{CurrencyField::convertToUserFormatSymbol($CORRECTION_TAX_SUMMARY['total'], true, $CURRENCY_SYMBOLAND['currency_symbol'])}
									</td>
								</tr>
								</tbody>
							</table>
						</div>
					{/if}
					<div class="col-md-4">
						<table class="table inventorySummaryContainer">
							<thead>
							<tr>
								<th colspan="2">
									<strong>{\App\Language::translate('LBL_AMOUNT_TO_PAY', $MODULE_NAME)}</strong>
								</th>
							</tr>
							</thead>
							<tbody>
							<tr>
								<td class="textAlignRight">
									{CurrencyField::convertToUserFormatSymbol($INVENTORY_MODEL->getCorrectionGrossSummary($BASE_RECORD, $RECORD), true, $CURRENCY_SYMBOLAND['currency_symbol'])}
								</td>
							</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
{/strip}
