<?php
/**
 * Plugin for Smarty.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

namespace App\Extension\Smarty;

use Smarty\Extension\Base;

/**
 * The extension allows to use any valid PHP callable as a modifier.
 */
class CallablePassThroughExtension extends Base
{

    public function getModifierCallback(string $modifierName) {
        return is_callable($modifierName) ? $modifierName : null;
    }
}
