<?php

/**
 * Comarch invoice synchronization map file.
 *
 * The file is part of the paid functionality. Using the file is allowed only after purchasing a subscription.
 * File modification allowed only with the consent of the system producer.
 *
 * @package Integration
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Integrations\Comarch\Xl\Maps;

/**
 * Comarch invoice synchronization map class.
 */
class Invoice extends \App\Integrations\Comarch\InventoryMap
{
	/** {@inheritdoc} */
	const API_NAME_ID = 'trN_GIDNumer';
	/** {@inheritdoc} */
	protected $moduleName = 'FInvoice';
	/** {@inheritdoc} */
	protected $fieldMap = [
		'accountid' => [
			'names' => ['get' => 'knt_Akronim', 'create' => 'Akronim'],
			'fn' => 'findBySynchronizer', 'synchronizer' => 'Accounts', 'fieldName' => 'account_short_name',
			'importIfNotExist' => true,  'importFn' => 'importByAkronim'
		],
		'subject' => ['names' => ['get' => 'trN_GIDNumer']],
		'vat_id_a' => ['names' => ['get' => 'knt_Nip']],
		'company_name_a' => ['names' => ['get' => 'knt_Nazwa1']],
		'comarch_number' => ['names' => ['get' => 'numerDokumentu'], 'direction' => 'yf'],
		'addresslevel5a' => [
			'names' => ['get' => 'knA_GIDNumer', 'create' => 'AdrNumer'], 'accountKey' => 'knt_Akronim',
			'fn' => 'convertAddress', 'addressType' => 'a', 'accountField' => 'accountid',
			'addressFields' => [
				'addresslevel1', 'addresslevel2', 'addresslevel5', 'addresslevel7', 'addresslevel8',
				'buildingnumber', 'email_', 'phone_', 'company_name_', 'vat_id_'
			]
		],
		'addresslevel5b' => [
			'names' => ['get' => 'trN_AdWNumer', 'create' => 'AdwNumer'], 'accountKey' => 'knt_Akronim',
			'fn' => 'convertAddress', 'addressType' => 'b',  'accountField' => 'accountid',
			'addressFields' => [
				'addresslevel1', 'addresslevel2', 'addresslevel5', 'addresslevel7', 'addresslevel8',
				'buildingnumber', 'email_', 'phone_', 'company_name_', 'vat_id_'
			]
		],
		'payment_methods' => [
			'names' => ['get' => 'trN_FormaNr', 'create' => 'Forma'],
			'fn' => 'findBySynchronizer', 'synchronizer' => 'PaymentMethods'
		],
		'issue_time' => [
			'names' => ['get' => 'dataWystawienia', 'create' => 'DataWystawienia']
		],
		'saledate' => ['names' => ['get' => 'dataTransakcji', 'create' => 'DataTransakcji']],
		'paymentdate' => [
			'names' => ['get' => 'dataPlatnosci', 'create' => 'Termin'],
			'fn' => 'convertPaymentDate', 'synchronizer' => 'PaymentMethods'
		],
		'description' => ['names' => ['get' => 'tnO_Opis', 'create' => 'Opis']],
		'currency_id' => [
			'names' => ['get' => 'rkB_Waluta', 'create' => 'Waluta'],
			'fn' => 'convertCurrency', 'direction' => 'api'
		],
	];
	/** {@inheritdoc} */
	protected $invFieldMap = [
		'name' => [
			'names' => ['get' => 'trE_TwrKod', 'create' => 'TowarKod'],
			'fn' => 'findBySynchronizer', 'synchronizer' => 'Products', 'fieldName' => 'product_code'
		],
		'qty' => [
			'names' => ['get' => 'trE_Ilosc', 'create' => 'Ilosc'],
		],
		'price' => [
			'names' => ['get' => 'trE_Cena', 'create' => 'Cena'],
		],
		'unit' => [
			'names' => ['get' => 'trE_JmZ', 'create' => 'JM'],
			'fn' => 'findBySynchronizer', 'synchronizer' => 'ProductUnit'
		],
		'comment1' => [
			'names' => ['get' => 'teO_Opis', 'create' => 'Opis'],
			'fn' => 'convertInvDesc',
		],
		'taxparam' => [
			'names' => ['get' => 'trE_GrupaPod', 'create' => 'Vat'],
			'fn' => 'convertInvTax', 'synchronizer' => 'Taxes'
		],
		'currency' => [
			'names' => ['get' => 'trE_Waluta', 'create' => 'Waluta'],
			'fn' => 'convertCurrency', 'direction' => 'yf'
		],
	];
	/** {@inheritdoc} */
	protected $defaultDataYf = [
		'fieldMap' => [
			'finvoice_type' => 'PLL_DOMESTIC_INVOICE',
			'comarch_invoice_status' => 'PLL_FROM_COMARCH',
			'finvoice_status' => 'PLL_ACCEPTED',
		],
		'invFieldMap' => [
			'comment1' => '',
			'discountmode' => 1,
			'discountparam' => '{"aggregationType":"individual","individualDiscountType":"amount","individualDiscount":0}',
		]
	];
	/** {@inheritdoc} */
	protected $defaultDataApi = [
		'Typ' => 2033,
		'ZamTryb' => 0,
	];

	/** {@inheritdoc} */
	public function saveInApi(): bool
	{
		if (empty($this->dataApi['id'])) {
			$response = $this->synchronizer->controller->getConnector()
				->request('POST', 'Document', $this->dataApi);
			$response = \App\Json::decode($response);
			$this->recordModel->set(self::FIELD_NAME_ID, $response['id']);
			$this->recordModel->set('comarch_number', $response['numerDokumentu']);
			$this->recordModel->set('comarch_invoice_status', 'PLL_COMARCH_SENT');
			$this->recordModel->save();
			$this->dataYf[self::FIELD_NAME_ID] = $this->dataApi['id'] = $response['id'];
			$status = true;
		} else {
			// No update method. Comarch does not properly support updates using the API
			$status = false;
		}
		$this->synchronizer->updateMapIdCache(
			$this->recordModel->getModuleName(),
			$this->dataApi['id'],
			$this->recordModel->getId()
		);
		return $status;
	}

	/** {@inheritdoc} */
	public function setErrorLog(array $errorLog): void
	{
		parent::setErrorLog($errorLog);
		if ($errorLog) {
			$this->recordModel->set('comarch_invoice_status', 'PLL_COMARCH_ERROR');
		}
	}
}
