<?php
/**
 * Esri WorldImagery driver file to get tile layer.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Klaudia Łozowska <k.lozowska@yetiforce.com>
 *
 * @see      https://server.arcgisonline.com/arcgis/rest/services/World_Imagery/MapServer
 */

declare(strict_types=1);

namespace App\Map\TileLayer;

/**
 * Connector for service Esri WorldImagery to get tile layer.
 */
class EsriWorldImagery extends Base
{
	/**
	 * @inheritdoc
	 */
	protected string $label = 'LBL_TILE_LAYER_ESRI_WORLDIMAGERY';

	/**
	 * @inheritdoc
	 */
	protected string $url = 'https://www.arcgis.com/home/item.html?id=10df2279f9684e4a9f6a7f08febac2a9';

	/**
	 * @inheritdoc
	 */
	protected string $urlTemplate = 'https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}';

	/**
	 * @inheritdoc
	 */
	protected array $formFields = [];
}
