<?php
/**
 * OpenStreetMap HOT driver file to get tile layer.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Klaudia Łozowska <k.lozowska@yetiforce.com>
 *
 * @see       https://learnosm.org/en/
 */

declare(strict_types=1);

namespace App\Map\TileLayer;

/**
 * Connector for service OpenStreetMapHOT to get tile layer.
 */
class OpenStreetMapHOT extends Base
{
	/**
	 * @inheritdoc
	 */
	protected string $label = 'LBL_TILE_LAYER_OSM_HOT';

	/**
	 * @inheritdoc
	 */
	protected string $url = 'https://www.hotosm.org/';

	/**
	 * @inheritdoc
	 */
	protected string $urlTemplate = 'https://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png';

	/**
	 * @inheritdoc
	 */
	protected array $formFields = [];
}
