<?php

/**
 * Service for build queries used in Query Generator.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 * @author Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Builder;

use App\Report\Model\Query;

final class QueryBuilder
{
	public function __construct(
		private readonly ExpressionBuilder $expressionBuilder,
		private readonly FilterGroupBuilder $filterGroupBuilder,
		private readonly FilterBuilder $filterBuilder,
	) {}

	public function query(string $moduleName, int $queryId = 0): Query
	{
		return new Query($queryId, $moduleName);
	}

	public function addExpressions(Query $query, array $exceptions): self
	{
		foreach ($exceptions as $exception) {
			$query->addExpression($this->expressionBuilder->build($exception, $query));
		}

		return $this;
	}

	public function addFilters(Query $query, array $filters): self
	{
		$groupFilter = $this->filterGroupBuilder->build($filters, $query);
		if (!$query->getFilterGroup()) {
			$query->setFilterGroup($groupFilter);
		}
		foreach ($filters['rules'] ?? [] as $filter) {
			if (isset($filter['rules'])) {
				$filter['filter_group_parent_id'] = $groupFilter->getId();
				$this->addFilters($query, $filter);
			} else {
				$groupFilter->addFilter($this->filterBuilder->build($filter, $groupFilter));
			}
		}

		return $this;
	}
}
