<?php
/**
 * Service for handling product formula
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Formula\Processor;

use App\Report\Enums\FunctionType;
use App\Report\Formula\FormulaProcessor;

/** ProductProcessor class */
final class ProductProcessor implements FormulaProcessor
{
	/** {@inheritDoc} */
	public function process(array $data, FunctionType $function): float
	{
		return array_product($data);
	}

	/** {@inheritDoc} */
	public function supports(FunctionType $function): bool
	{
		return FunctionType::PROD === $function;
	}
}
