# Report module

This module introduces new way of designing and coding Yetiforce inside
modules.

## Pros

- Encapsulation of module logic
- Opened for modifications
- Module's components cna be easy used outside of module
- Only one entrypoint to use module components
- Single Responsibility Principle not broken
- Model data representation
- Only one point of data fetching
- Yetiforce components and logic can be still used inside the module

## System impact

There's almost no impact of this module to the rest of the system. Module is
totally encapsulated, it does all the job on its own and, on demand, can be
used outside on from the module facade.

## Module namespaces and files

- Report.php - The main entrypoint of the module and Dependency Injection
  Manger at the same time. This is the point where the services and their
  dependencies are registered.
- Builder - Namespace with construction services
- Model - Namespace with models representing our data - e.g. from database
- Provider - Namespace with providers for report file generation
- Repository - Namespace with services for fetching data - e.g. from
  database
