<?php
/**
 * Report service main class
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report;

use App\Report\DependencyInjection\Container;

/** Report class */
final class Report
{
	private Container $container;

	private static ?self $instance = null;

	private function __construct()
	{
		$this->container = new Container();
	}

	/**
	 * @template T
	 * @var class-string<T> $class
	 * @return T|null
	 */
	public static function get(string $class): ?object
	{
		return self::instance()->container->get($class);
	}

	/** Get Report service instance */
	private static function instance(): self
	{
		return self::$instance ?? self::$instance = new self();
	}
}
