<?php

namespace App\TextParser;

use App\Language;

/**
 * Table tax summary class fo correct.
 *
 * @package TextParser
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Tomasz Kur <t.kur@yetiforce.com>
 */
class TableCorrectDiscountSummary extends Base
{
	/** @var string Class name */
	public $name = 'LBL_TABLE_DISCOUNT_SUMMARY_FOR_CORRECT';

	/** @var mixed Parser type */
	public $type = 'pdf';

	/** @var array Allowed modules */
	public $allowedModules = ['FCorectingInvoice'];
	/** @var array Related modules fields */
	protected $relatedModulesFields = ['FCorectingInvoice' => 'finvoiceid'];

	/**
	 * Process.
	 *
	 * @return string
	 */
	public function process()
	{
		if (!$this->textParser->recordModel || !$this->textParser->recordModel->getModule()->isInventory()) {
			return '';
		}

		$relatedRecordModel = \Vtiger_Record_Model::getInstanceById($this->textParser->recordModel->get($this->relatedModulesFields[$this->textParser->recordModel->getModuleName()]));
		$inventory = \Vtiger_Inventory_Model::getInstance($this->textParser->moduleName);
		if (!$inventory->isField('discount')) {
			return '';
		}

		$currencySymbol = $inventory->getCurrency($this->textParser->recordModel)['currency_symbol'] ?? '';
		$relatedSummary = $inventory->getAllSummaryValues($relatedRecordModel);
		$summary = $inventory->getAllSummaryValues($this->textParser->recordModel);

		$html = '';
		$fields = $inventory->getFieldsByBlocks();
		if (!empty($fields[0])) {
			$totalValue = $summary['total']['sum_discount'] - $relatedSummary['total']['sum_discount'];
			$taxLabel = $totalValue > 0 ? 'LBL_DISCOUNT_INCREASE_AMOUNT' : 'LBL_DISCOUNT_REDUCTION_AMOUNT';
			$html .= '
						<table class="table-correct-tax-summary" style="width:100%;vertical-align:top;border-collapse:collapse;border:1px solid #ddd;">
						<thead>
								<tr>
									<th style="font-weight:bold;padding:0px 4px;">' . Language::translate($taxLabel, $this->textParser->moduleName) . '</th>
								</tr>
								</thead><tbody>';
			$html .= '<tr>
									<td class="value" style="text-align:right;font-weight:bold;padding:0px 4px;border:1px solid #ddd;">' . \CurrencyField::convertToUserFormatSymbol($totalValue, true, $currencySymbol) . '</td>
								</tr>
								</tbody>
						</table>';
		}

		return $html;
	}
}
