{*<!-- {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} -->*}
{strip}
	<!-- tpl-Base-inventoryfields-EditViewCurrency -->
	{assign var=SELECTED_CURRENCY value=$INVENTORY_MODEL->getEditValue($ITEM_DATA, $FIELD->getColumnName())}
	{assign var=CURRENCY_PARAMS_RAW value=$INVENTORY_MODEL->getEditValue($ITEM_DATA, 'currencyparam')}
	{assign var=CURRENCIES value=\App\Fields\Currency::getAll(true)}
	{assign var=CURRENCY_PARAMS value=$FIELD->getCurrencyParam($CURRENCIES, $CURRENCY_PARAMS_RAW)}
	<input {if $ROW_NO} name="inventory[{$ROW_NO}][currencyparam]" {/if} type="hidden" value="{\App\Purifier::encodeHtml(\App\Json::encode($CURRENCY_PARAMS))}"
		class="js-currencyparam" data-js="" />
	<div class="input-group input-group-sm">
		<div class="input-group-prepend col p-0">
			<select class="select2 form-control js-currency" data-minimum-results-for-search="-1" data-old-value="{$SELECTED_CURRENCY}"
				{if $ROW_NO} name="inventory[{$ROW_NO}][{$FIELD->getColumnName()}]" {/if}
				title="{\App\Language::translate('LBL_CURRENCY', $MODULE_NAME)}"
				{if $FIELD->isReadOnly()}readonly="readonly" {/if}>
				{foreach item=CURRENCY key=count from=$CURRENCIES}
					{assign var=CURRENCY_PARAM value=$CURRENCY_PARAMS[$CURRENCY.id]}
					<option value="{$CURRENCY.id}" class="textShadowNone" data-conversion-rate="{$CURRENCY_PARAM.conversion}"
						data-conversion-date="{$CURRENCY_PARAM.date}"
						data-conversion-symbol="{$CURRENCY.currency_symbol}"
						data-base-currency="{if $CURRENCY.defaultid < 0}1{else}0{/if}"
						{if $SELECTED_CURRENCY eq $CURRENCY.id}selected{/if}>
						{\App\Language::translate($CURRENCY.currency_code, 'Other.Currency')} ({$CURRENCY.currency_symbol})
					</option>
				{/foreach}
			</select>
		</div>
		{if count($CURRENCIES) > 1 && !empty($FIELD->getParamConfig('reset_currency')) && $FIELD->isEditable()}
			<div class="input-group-append">
				<button type="button" class="btn btn-light js-inv-currency_reset"
						title="{\App\Language::translate('LBL_INV_CURRENCY_RESET_BTN', $MODULE_NAME)}"
						data-url="index.php?module={$MODULE_NAME}&action=Inventory&mode=getCurrencyData"
						data-confirmation="{\App\Language::translate('LBL_INV_CURRENCY_RESET_CONFIRMATION', $MODULE_NAME)}"
				>
					<span class="adminIcon-currencies"></span>
				</button>
			</div>
		{/if}
	</div>
	<div class="modelContainer modal fade">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">
						<span class="fas fa-euro-sign mr-1"></span>
						{\App\Language::translate('LBL_CHANGE_CURRENCY', $MODULE_NAME)}
					</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					{if $CURRENCY_PARAMS == false}
					<div class="alert alert-warning"
						 role="alert">{\App\Language::translate('LBL_NO_EXCHANGE_RATES', $MODULE_NAME)}</div>
					{else}
					<ul class="nav nav-tabs my-2 mr-0 js-currency-tabs" data-tabs="tabs" role="tablist">
						<li class="nav-item">
							<a class="nav-link active" href="" data-toggle="tab" data-name="vatExchange" data-target=".js-currency-tab-vat">
								{\App\Language::translate('LBL_EXCHANGE_VAT', $QUALIFIED_MODULE)}
							</a>
						</li>
						{if $FIELD->getParamConfig('cit_exchange')}
							<li class="nav-item">
								<a class="nav-link" href="" data-toggle="tab" data-name="citExchange" data-target=".js-currency-tab-cit">
									{\App\Language::translate('LBL_EXCHANGE_CIT', $QUALIFIED_MODULE)}
								</a>
							</li>
						{/if}
					</ul>
					<div class="tab-content ml-1 mr-1 js-currency-tabs-content">
						<div class="tab-pane font-weight-normal js-currency-tab-vat active" role="tabpanel">
							<div class="alert alert-warning" role="alert">
								{\App\Language::translate('LBL_CHANGE_CURRENCY_INFO', $MODULE_NAME)}
							</div>
							<div class="input-group mb-2">
								<span class="input-group-prepend">
									<span class="input-group-text"> {\App\Language::translate('Currency Name', $MODULE_NAME)}:</span>
								</span>
								<input id="currencyName"
									   type="text"
									   class="form-control dateField currencyName"
									   name="currencyName"
									   disabled/>
							</div>
							<div class="input-group mb-2">
								<span class="input-group-prepend">
									<span class="input-group-text"> {\App\Language::translate('LBL_EXCHANGE_DATE', $MODULE_NAME)}:</span>
								</span>
								<input id="currencyDate" type="text"
									   class="form-control dateField currencyDate" name="currencyDate"
									   data-type="vat" data-date-format="{$USER_MODEL->get('date_format')}"
									   value=""/>
							</div>
							<div class="input-group">
								<span class="input-group-prepend">
									<span class="input-group-text">{\App\Language::translate('LBL_EXCHANGE_RATE', $MODULE_NAME)}:</span>
								</span>
								<input type="text" class="form-control currencyRate" value=""
									   aria-label="{\App\Language::translate('LBL_EXCHANGE_RATE', $MODULE_NAME)}">
								<span class="input-group-append"><span
										class="input-group-text">{$BASE_CURRENCY['currency_symbol']}</span></span>
							</div>
						</div>
						{if $FIELD->getParamConfig('cit_exchange')}
							<div class="tab-pane font-weight-normal js-currency-tab-cit" role="tabpanel">
								<div class="input-group mb-2">
								<span class="input-group-prepend">
									<span class="input-group-text"> {\App\Language::translate('Currency Name', $MODULE_NAME)}:</span>
								</span>
									<input id="currencyName"
										   type="text"
										   class="form-control dateField currencyName"
										   name="currencyName"
										   disabled/>
								</div>
								<div class="input-group mb-2">
								<span class="input-group-prepend">
									<span class="input-group-text"> {\App\Language::translate('LBL_EXCHANGE_DATE', $MODULE_NAME)}:</span>
								</span>
									<input id="currencyDate" type="text"
										   class="form-control dateField currencyDate" name="currencyDate"
										   data-type="cit" data-date-format="{$USER_MODEL->get('date_format')}"
										   value=""/>
								</div>
								<div class="input-group">
								<span class="input-group-prepend">
									<span class="input-group-text">{\App\Language::translate('LBL_EXCHANGE_RATE', $MODULE_NAME)}:</span>
								</span>
									<input type="text" class="form-control currencyRate" value=""
										   aria-label="{\App\Language::translate('LBL_EXCHANGE_RATE', $MODULE_NAME)}">
									<span class="input-group-append"><span
											class="input-group-text">{$BASE_CURRENCY['currency_symbol']}</span></span>
								</div>
							</div>
						{/if}
					</div>
					{/if}
					<div class="modal-footer">
						{if $CURRENCY_PARAMS != false}
							<button class="btn btn-primary" type="submit">
								<strong>
									<span class="fas fa-check mr-1"></span>
									{\App\Language::translate('LBL_SAVE', $MODULE_NAME)}
								</strong>
							</button>
						{/if}
						<button class="btn btn-outline-primary" type="reset" data-dismiss="modal">
							<strong>
								<span class="fas fa-times mr-1"></span>
								{\App\Language::translate('LBL_CANCEL', $MODULE_NAME)}
							</strong>
						</button>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /tpl-Base-inventoryfields-EditViewCurrency -->
{/strip}
