<?php

/**
 * Module Model.
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Tomasz Kur <t.kur@yetiforce.com>
 * @author Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */
class OpenStreetMap_Module_Model extends Vtiger_Module_Model
{
	/** @var string Table name of coordinates for records */
	const COORDINATES_TABLE_NAME = 'u_#__openstreetmap';
	/** @var string Column name for type */
	const COORDINATE_TYPE_COLUMN = 'u_#__openstreetmap.type';

	/**
	 * Check if module is allowed.
	 *
	 * @param string $moduleName
	 *
	 * @return bool
	 */
	public function isAllowModules($moduleName)
	{
		return \in_array($moduleName, \App\Config::module($this->getName(), 'mapModules', []));
	}

	/**
	 * Function to get allow modules with checking permissions.
	 *
	 * @param string $sourceModule
	 *
	 * @return string[]
	 */
	public function getAllowedModules(string $sourceModule): array
	{
		$allAllowedModules = \App\Config::module($this->getName(), 'mapModules', []);
		foreach ($allAllowedModules as $key => $moduleName) {
			if (!\App\Privilege::isPermitted($moduleName)) {
				unset($allAllowedModules[$key]);
			}
		}
		if (!\in_array($sourceModule, $allAllowedModules) && Vtiger_Module_Model::getInstance($sourceModule)->getFieldsByType('mapCoordinates')) {
			$allAllowedModules[] = $sourceModule;
		}
		return $allAllowedModules;
	}

	/**
	 * Get map scripts.
	 *
	 * @return array
	 */
	public function getMapScripts(): array
	{
		$js = [
			'~libraries/leaflet/dist/leaflet.js',
			'~libraries/leaflet.markercluster/dist/leaflet.markercluster.js',
			'~libraries/leaflet.awesome-markers/dist/leaflet.awesome-markers.js',
		];
		$tileLayerServer = \App\Map\Layer::getTileServer();
		if ($tileLayerServer && 'maps.googleapis.com' === parse_url($tileLayerServer)['host']) {
			$js[] = '~libraries/leaflet.gridlayer.googlemutant/dist/Leaflet.GoogleMutant.js';
		}
		$js[] = 'modules.OpenStreetMap.resources.Map';
		return $js;
	}
}
