<?php
/**
 * Inventory record details handler.
 *
 * @package Handler
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Fields\Currency;

/**
 * Inventory record details handler class.
 */
class Products_InventoryRecordDetails_Handler
{
	/**
	 * InventoryRecordDetails handler function.
	 *
	 * @param App\EventHandler $eventHandler
	 */
	public function inventoryRecordDetails(App\EventHandler $eventHandler)
	{
		$recordModel = $eventHandler->getRecordModel();
		$params = $eventHandler->getParams();
		$currencyId = empty($params['currencyId']) ? Currency::getDefault()['id'] : $params['currencyId'];
		$currencyParams = $eventHandler->getParam('currencyParams') ?? [];
		$info = $params['info'];
		$info['qtyPerUnit'] = $recordModel->getDisplayValue('qty_per_unit');
		if (($fieldModel = $recordModel->getField('unit_price')) && $fieldModel->isActiveField()) {
			$info['unitPriceValues'] = $fieldModel->getUITypeModel()->getEditViewFormatData($recordModel->get($fieldModel->getName()))['currencies'] ?? [];
			$info['price'] = $fieldModel->getUITypeModel()->getValueForCurrency($recordModel->get($fieldModel->getName()), $currencyId, $currencyParams);
		}
		if (($fieldModel = $recordModel->getField('purchase')) && $fieldModel->isActiveField()) {
			$info['purchase'] = $fieldModel->getUITypeModel()->getValueForCurrency($recordModel->get($fieldModel->getName()), $currencyId, $currencyParams);
		}
		$eventHandler->addParams('info', $info);
	}
}
