<?php
/*
 * Create Quick Details Nodal
 *
 * @package   ReportTemplates
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

use App\Report\Provider\FieldsProvider;
use App\Report\Provider\ReportProvider;
use App\Report\Report;
use App\Request;
use App\User;

/** ReportTemplate_QuickDetailModal_View class */
class ReportTemplate_QuickDetailModal_View extends Vtiger_QuickDetailModal_View
{
	public function process(Request $request): void
	{
		$viewer = $this->getViewer($request);
		$reportPreview = $this->getReportDataForPreview($request->getInteger('record'));
		$viewer->assign('PREVIEW_DATA', $reportPreview['previewData']);
		$viewer->assign('PREVIEW_HEADERS', $reportPreview['previewHeaders']);
		parent::process($request);
	}

	/** Provide data for quick review for document */
	private function getReportDataForPreview(int $recordId): array
	{
		$userId = User::getCurrentUserId();
		$previewData = Report::get(ReportProvider::class)->provide($recordId, $userId, true);
		$fieldsProvider = Report::get(FieldsProvider::class)->provide(
			$recordId,
			\count($previewData) > 0 ? $previewData[0] : [],
		);
		return ['previewData' => $previewData, 'previewHeaders' => $fieldsProvider];
	}
}
