<?php

/**
 * Reservations time UIType class.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 */
class Reservations_Time_UIType extends Vtiger_Time_UIType
{
	/** {@inheritdoc} */
	public function getEditViewDisplayValue($value, $recordModel = false)
	{
		if (!empty($value)) {
			return parent::getEditViewDisplayValue($value, $recordModel);
		}
		$specialTimeFields = ['time_start', 'time_end'];
		$fieldName = $this->getFieldModel()->getFieldName();
		if (!\in_array($fieldName, $specialTimeFields)) {
			return parent::getEditViewDisplayValue($value, $recordModel);
		}
		return $this->getDisplayTimeDifferenceValue($fieldName, $value ?? '');
	}

	/**
	 * Function to get the calendar event call duration value in hour format.
	 *
	 * @param string $fieldName
	 * @param string $value
	 *
	 * @return string - getTimeValue
	 */
	public function getDisplayTimeDifferenceValue($fieldName, $value)
	{
		$date = new DateTime($value ?? 'now');
		if ('time_end' === $fieldName && empty($value)) {
			$date->modify('+15 minutes');
		}
		return (new DateTimeField($date->format('Y-m-d H:i:s')))->getDisplayTime();
	}
}
