'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";Vtiger_Edit_Js("Documents_Edit_Js",{},{INTERNAL_FILE_LOCATION_TYPE:"I",EXTERNAL_FILE_LOCATION_TYPE:"E",isFileLocationInternalType:function isFileLocationInternalType(fileLocationElement){return !(fileLocationElement.val()!=this.INTERNAL_FILE_LOCATION_TYPE)},isFileLocationExternalType:function isFileLocationExternalType(fileLocationElement){return !(fileLocationElement.val()!=this.EXTERNAL_FILE_LOCATION_TYPE)},convertFileSizeInToDisplayFormat:function convertFileSizeInToDisplayFormat(fileSizeInBytes){var i=-1;do fileSizeInBytes/=1024,i++;while(1024<fileSizeInBytes);return Math.max(fileSizeInBytes,.1).toFixed(1)+[" kB"," MB"," GB"," TB","PB","EB","ZB","YB"][i]},/**
		 * Register file location type change event.
		 * @param {jQuery} container
		 */registerFileLocationTypeChangeEvent:function registerFileLocationTypeChangeEvent(container){var thisInstance=this,fileLocationTypeElement=container.find("[name=\"filelocationtype\"]");fileLocationTypeElement.on("change",function(){var typeFile=$(".js-type-file"),typeText=$(".js-type-text"),fileNameElement="",name="filename";thisInstance.isFileLocationInternalType(fileLocationTypeElement)?(fileNameElement=typeFile,fileNameElement.addClass("show").attr("disabled",!1).removeClass("d-none").attr("name",name),typeText.addClass("d-none").attr("disabled",!0).removeClass("show").attr("name","")):(fileNameElement=typeText,fileNameElement.addClass("show").attr("disabled",!1).removeClass("d-none").attr("name",name),typeFile.addClass("d-none").attr("disabled",!0).removeClass("show").attr("name",""));var uploadFileDetails=fileNameElement.closest(".fieldValue").find(".uploadedFileDetails");thisInstance.isFileLocationExternalType(fileLocationTypeElement)?uploadFileDetails.addClass("d-none").removeClass("show"):uploadFileDetails.addClass("show").removeClass("d-none");});},registerFileChangeEvent:function registerFileChangeEvent(container){var thisInstance=this;container.on("change","input[name=\"filename\"]",function(e){if("text"===e.target.type)return !1;var element=container.find("[name=\"filename\"]");//ignore all other types than file
if("file"===element.attr("type")){var uploadFileSizeHolder=element.closest(".fileUploadContainer").find(".uploadedFileSize"),fileSize=element.get(0).files[0].size;fileSize>CONFIG.maxUploadLimit?(app.showAlert(app.vtranslate("JS_UPLOADED_FILE_SIZE_EXCEEDS")),element.val(""),uploadFileSizeHolder.text("")):uploadFileSizeHolder.text(thisInstance.convertFileSizeInToDisplayFormat(fileSize));}});},/**
		 * Function to save the quickcreate module
		 * @param accepts form element as parameter
		 * @returns {Promise}
		 */quickCreateSave:function quickCreateSave(form){var aDeferred=jQuery.Deferred(),formData=new FormData(form[0]),fileLocationTypeElement=form.find("[name=\"filelocationtype\"]");//Using formData object to send data to server as a multipart/form-data form submit
return AppConnector.request({url:"index.php",type:"POST",data:formData,processData:!1,contentType:!1}).done(function(data){aDeferred.resolve(data);}).fail(function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown);}),aDeferred.promise()},registerBasicEvents:function registerBasicEvents(container){this._super(container),this.registerFileLocationTypeChangeEvent(container),this.registerFileChangeEvent(container);},registerEvents:function registerEvents(){this._super();}});
//# sourceMappingURL=Edit.min.js.map
