'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";/**
 * Class representing a modal calendar.
 * @extends Vtiger_Calendar_Js
 */function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Constructor}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}function _callSuper(t,o,e){return o=_getPrototypeOf(o),_possibleConstructorReturn(t,_isNativeReflectConstruct()?Reflect.construct(o,e||[],_getPrototypeOf(t).constructor):o.apply(t,e))}function _possibleConstructorReturn(self,call){if(call&&("object"===_typeof(call)||"function"==typeof call))return call;if(void 0!==call)throw new TypeError("Derived constructors may only return object or undefined");return _assertThisInitialized(self)}function _assertThisInitialized(self){if(void 0===self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return self}function _isNativeReflectConstruct(){try{var t=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));}catch(t){}return (_isNativeReflectConstruct=function(){return !!t})()}function _get(){return _get="undefined"!=typeof Reflect&&Reflect.get?Reflect.get.bind():function(target,property,receiver){var base=_superPropBase(target,property);if(base){var desc=Object.getOwnPropertyDescriptor(base,property);return desc.get?desc.get.call(3>arguments.length?target:receiver):desc.value}},_get.apply(this,arguments)}function _superPropBase(object,property){for(;!Object.prototype.hasOwnProperty.call(object,property)&&(object=_getPrototypeOf(object),null!==object););return object}function _getPrototypeOf(o){return _getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(o){return o.__proto__||Object.getPrototypeOf(o)},_getPrototypeOf(o)}function _inherits(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),Object.defineProperty(subClass,"prototype",{writable:!1}),superClass&&_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){return _setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(o,p){return o.__proto__=p,o},_setPrototypeOf(o,p)}window.Occurrences_CalendarModal_Js=/*#__PURE__*/function(_Vtiger_Calendar_Js){function Occurrences_CalendarModal_Js(container,readonly){var _this;return _classCallCheck(this,Occurrences_CalendarModal_Js),_this=_callSuper(this,Occurrences_CalendarModal_Js,[container,readonly]),_this.isSwitchAllDays=!1,_this.sidebarName="add",_this.eventCreate=!1,_this.module=container.find("[name=\"module\"]").val(),_this.renderCalendar(),_this.registerEvents(),_this}/**
	 * Function sets calendar module's options
	 * @returns {{eventClick: function, headerToolbar: object, selectable: boolean}}
	 */return _inherits(Occurrences_CalendarModal_Js,_Vtiger_Calendar_Js),_createClass(Occurrences_CalendarModal_Js,[{key:"setCalendarModuleOptions",value:function setCalendarModuleOptions(){var options=_get(_getPrototypeOf(Occurrences_CalendarModal_Js.prototype),"setCalendarModuleOptions",this).call(this);options.selectable=!0,options.eventClick=function(info){info.jsEvent.preventDefault();};var date=this.container.find(".js-selected-date").val();return date&&(options.initialDate=date),options}/**
	 * Function registers calendar events
	 */},{key:"registerEvents",value:function registerEvents(){var calendarView=this.getCalendarView();this.switchContainer=$("<div class=\"js-calendar-switch-container\"></div>").insertAfter(calendarView.find(".fc-center")),this.registerSwitchEvents(),this.registerUsersChange();}/**
	 * Function registers calendar switch event
	 */},{key:"registerSwitchEvents",value:function registerSwitchEvents(){var _this2=this;!1!==app.getMainParams("hiddenDays",!0)&&(this.switchContainer.html(this.createSwitch()),this.switchContainer.find("input").on("change",function(e){var currentTarget=$(e.currentTarget),hiddenDays=[];"undefined"==typeof currentTarget.data("on-text")?_this2.isSwitchAllDays=!0:(hiddenDays=app.getMainParams("hiddenDays",!0),_this2.isSwitchAllDays=!1),_this2.fullCalendar.setOption("hiddenDays",hiddenDays),_this2.registerSwitchEvents();}));}/**
	 * Generate filter buttons
	 * @returns {string}
	 */},{key:"createSwitch",value:function createSwitch(){var on=app.vtranslate("JS_WORK_DAYS"),off=app.vtranslate("JS_ALL"),state=this.isSwitchAllDays;return "<div class=\"btn-group btn-group-toggle js-switch c-calendar-switch\" data-toggle=\"buttons\">\n\t\t\t\t\t<label class=\"btn btn-outline-primary c-calendar-switch__button js-switch--label-on ".concat(state?"":"active","\">\n\t\t\t\t\t\t<input type=\"radio\" name=\"options\" data-on-text=\"").concat(on,"\" autocomplete=\"off\" ").concat(state?"":"checked",">").concat(on,"\n\t\t\t\t\t</label>\n\t\t\t\t\t<label class=\"btn btn-outline-primary c-calendar-switch__button ").concat(state?"active":"","\">\n\t\t\t\t\t\t<input type=\"radio\" name=\"options\" data-off-text=\"").concat(off,"\" autocomplete=\"off\" ").concat(state?"checked":"",">").concat(off,"\n\t\t\t\t\t</label>\n\t\t\t\t</div>")}/**
	 * Function registers select's user change event
	 */},{key:"registerUsersChange",value:function registerUsersChange(){var _this3=this;this.container.find(".assigned_user_id").on("change",function(){_this3.reloadCalendarData();});}/**
	 * Get selected users
	 * @returns {{ selectedIds: array, excludedIds: array }}
	 */},{key:"getSelectedUsersCalendar",value:function getSelectedUsersCalendar(){return {selectedIds:[this.container.find(".assigned_user_id").val()],excludedIds:[]}}/**
	 * Function invokes by FullCalendar, sets selected days in form
	 * @param {Object} info
	 * @returns
	 */},{key:"selectDays",value:function selectDays(info){var _this4=this;if("status"===this.sidebarName)return this.sidebarName="add",void this.getCalendarCreateView().done(function(){_this4.selectDays(info);});var startDate=info.start,endDate=info.end;if(info.allDay){endDate.setDate(endDate.getDate()-1);var d=new Date;startDate.setHours(d.getHours(),d.getMinutes()),endDate.setHours(d.getHours(),d.getMinutes()+30);}this.container.find("[name=\"date_start\"]").val(App.Fields.DateTime.dateToUserFormat(startDate)),this.container.find("[name=\"date_end\"]").val(App.Fields.DateTime.dateToUserFormat(endDate));}}])}(Vtiger_Calendar_Js),$.Class("Occurrences_QuickCreate_Js",{},{registerEvents:function registerEvents(container){var className=container.find("[name=\"module\"]").val()+"_CalendarModal_Js";this.calendarView=new window[className](container.closest(".js-modal-container"),!0);}});
//# sourceMappingURL=QuickCreate.min.js.map
