/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */
'use strict';

Vtiger_Edit_Js(
	'ReportTemplate_Edit_Js',
	{},
	{
		container: false,
		conditionBuilder: false,
		getSourceModuleName: function () {
			return JSON.parse(this.container.find('input[name="data-sources"]').val()).sourceModule;
		},
		getRelatedModulesAndRelations() {
			return JSON.parse(this.container.find('input[name="data-sources"]').val()).relations;
		},
		showReportModulesOptions() {
			const self = this;
			if (!app.getRecordId() && 'Edit' === app.getViewName() && !this.isDuplicated()) {
				AppConnector.request({
					module: app.getModuleName(),
					view: 'SelectModulesModal'
				}).done(function (data) {
					app.showModalWindow(data, (modalContainer) => {
						self.selectBaseModule(modalContainer);
						let containerValidate = modalContainer.find('form');
						containerValidate.validationEngine(app.validationEngineOptions);
						modalContainer.find('.js-save-data-source-modules').on('click', () => {
							if (containerValidate.validationEngine('validate')) {
								const progressIndicatorElement = jQuery.progressIndicator({
									position: 'html',
									blockInfo: {
										enabled: true
									}
								});
								let sourceModule = modalContainer.find('.js-base-module').val();
								let selectedRelatedModules = modalContainer
									.find('.js-related-module option:selected')
									.map(function () {
										return {
											sourceModule: $(this).data('reference-base-module'),
											isRelatedAdvModule: $(this).data('related-adv-module'),
											relatedItem: $(this).val()
										};
									})
									.get();
								let jsonData = JSON.stringify({
									sourceModule: sourceModule,
									relations: selectedRelatedModules
								});
								$('input[name="data-sources"]').val(jsonData);
								app.hideModalWindow();
								self.getReportFields();
								self.getAggregateColumns();
								self.registerFormulaWizardModal();
								self.loadConditionBuilderView();
								progressIndicatorElement.progressIndicator({ mode: 'hide' });
							}
						});
					});
				});
			}
		},
		loadConditionBuilderView: function () {
			let progress = $.progressIndicator({
				position: 'html',
				blockInfo: {
					enabled: true
				}
			});
			let conditionBuilderParams = this.getParamsForConditionBuilder();
			conditionBuilderParams.view = 'Conditions';
			conditionBuilderParams.mode = 'builder';
			conditionBuilderParams.advanceCriteria = this.container.find("[name='advanceCriteria']").val();
			conditionBuilderParams.record = this.isDuplicated() ? this.getDuplicatedRecordId() : app.getRecordId();
			AppConnector.request(conditionBuilderParams).done((data) => {
				progress.progressIndicator({ mode: 'hide' });
				this.container.find('.js-condition-builder-view').html(data);
				this.registerConditionBuilder();
			});
		},
		registerConditionBuilder() {
			let conditionBuilderParams = this.getParamsForConditionBuilder();
			this.container.find('.js-condition-builder').each((_, e) => {
				this.conditionBuilder = new ReportTemplate_ConditionBuilder_Js($(e), conditionBuilderParams);
				this.conditionBuilder.registerEvents();
			});
		},
		getParamsForConditionBuilder: function () {
			let referencedModules = [];
			let relatedModules = [];
			let relatedItem;
			$.each(this.getRelatedModulesAndRelations(), function (_, relation) {
				relatedItem = relation.relatedItem;
				if (isNaN(parseInt(relatedItem))) {
					referencedModules.push(relatedItem);
				} else {
					relatedModules.push(relatedItem);
				}
			});
			return {
				module: app.getModuleName(),
				baseModule: this.getSourceModuleName(),
				relatedModules: relatedModules,
				referencedModules: referencedModules
			};
		},
		getReportFields: function () {
			return new Promise((resolve, _) => {
				const progressIndicatorElement = jQuery.progressIndicator({
					position: 'html',
					blockInfo: {
						enabled: true
					}
				});
				AppConnector.request({
					module: app.getModuleName(),
					view: 'Fields',
					sourceModule: this.getSourceModuleName(),
					relations: this.getRelatedModulesAndRelations()
				}).done((data) => {
					this.container.find('.js-report-fields-container').html(data);
					this.selectReportColumn();
					this.removeReportColumn();
					this.sortableColumns();
					App.Fields.Picklist.showSelect2ElementView(this.container.find('select.select2'));
					progressIndicatorElement.progressIndicator({ mode: 'hide' });
					resolve(true);
				});
			});
		},
		sortableColumns: function () {
			this.container.find('.js-report-selected-columns').sortable();
		},
		selectGroupColumn: function () {
			let groupColumnsSelect = $('.js-select-report-group');
			groupColumnsSelect.on('change', (e) => {
				let selectedOption = $(e.currentTarget).find('option:selected');
				this.addGroupColumn(selectedOption);
				this.removeGroupColumn();
				groupColumnsSelect.val(null);
			});
		},
		addGroupColumn: function (selectedOption) {
			let fieldFunction =
				selectedOption.data('field-function') === undefined ? '' : selectedOption.data('field-function');
			$('.js-report-group-columns').append(
				`<p
					data-field-expression="${selectedOption.data('field-expression')}"
					data-field-function="${fieldFunction}"
					class="c-modernBlockListElement">
					<span class="c-modernBlockListElement__title">
						${selectedOption.val()}
					</span>
					<div class="c-modernBlockListElement__actions">
						<span class="btn btn--square btn-primary js-remove-selected-group">
							<i class="ti ti-trash"></i>
						</span>
					</div>
				</p>`
			);
		},
		removeGroupColumn() {
			$('.js-remove-selected-group').on('click', (e) => {
				let groupToRemove = $(e.currentTarget).closest('p');
				let groupToRemoveId = groupToRemove.data('field-expression');
				let optionToEnable = $('option[data-field-expression="' + groupToRemoveId + '"]');
				if (optionToEnable.length > 0) {
					optionToEnable.prop('disabled', false);
				}
				groupToRemove.remove();
			});
		},
		selectBaseModule: function (modalContainer) {
			modalContainer.find('.js-base-module').on('change', (e) => {
				let progress = $.progressIndicator({ position: 'html', blockInfo: { enabled: true } });
				AppConnector.request({
					module: app.getModuleName(),
					view: 'GetRelatedModules',
					selectedRelatedModules: [$(e.currentTarget).val()]
				}).done(function (data) {
					let relatedModulesContainer = modalContainer.find('.js-related-modules-container');
					relatedModulesContainer.empty();
					relatedModulesContainer.append(data);
					App.Fields.Picklist.showSelect2ElementView(relatedModulesContainer.find('select.select2'));
					progress.progressIndicator({ mode: 'hide' });
				});
			});
		},
		getAggregateColumns: function () {
			return new Promise((resolve, _) => {
				AppConnector.request({
					module: app.getModuleName(),
					view: 'AggregateFields',
					sourceModule: this.getSourceModuleName(),
					relations: this.getRelatedModulesAndRelations()
				}).done((data) => {
					this.container.find('.js-aggregate-columns-container').html(data);
					this.selectAggregateColumn();
					App.Fields.Picklist.showSelect2ElementView(this.container.find('select.select2'));
					resolve(true);
				});
			});
		},
		selectAggregateColumn: function () {
			let aggregateColumnSelect = $('.js-select-aggregate-column');
			aggregateColumnSelect.on('change', (e) => {
				let selectedOption = $(e.currentTarget).find('option:selected');
				this.appendAggregateColumn(selectedOption);
				aggregateColumnSelect.val(null);
			});
		},
		appendAggregateColumn: function (selectedOption) {
			selectedOption.prop('disabled', true);
			$('.js-selected-aggregate-columns-container').append(
				`<p
					data-field-expression="${selectedOption.data('field-expression')}"
					data-field-function="${selectedOption.data('field-function')}"
					class="c-modernBlockListElement js-aggregate-column">
					<span class="c-modernBlockListElement__title">${selectedOption.val()}</span>
					<span class="c-modernBlockListElement__actions">
						<span class="btn btn--square btn-primary js-remove-selected-aggregate">
							<i class="ti ti-trash"></i>
						</span>
					</span>
				</p>
				`
			);
			this.removeAggregateColumn();
		},
		removeAggregateColumn() {
			$('.js-remove-selected-aggregate').on('click', (e) => {
				let groupToRemove = $(e.currentTarget).closest('p');
				let aggregateToRemoveId = groupToRemove.data('field-expression');
				let optionToEnable = $('option[data-field-expression="' + aggregateToRemoveId + '"]');
				if (optionToEnable.length > 0) {
					optionToEnable.prop('disabled', false);
				}
				groupToRemove.remove();
			});
		},
		selectReportColumn: function () {
			const self = this;
			let reportColumnsSelect = $('.js-select-report-column');
			reportColumnsSelect.on('change', (e) => {
				let selectedOption = $(e.currentTarget).find('option:selected');
				self.handleSelectedReportColumn(selectedOption);
				reportColumnsSelect.val(null);
			});
		},
		handleSelectedReportColumn: function (selectedOption, orderBy = '') {
			const self = this;
			selectedOption.prop('disabled', true);
			AppConnector.request({
				module: app.getModuleName(),
				view: 'SelectedField',
				icon: selectedOption.data('field-icon'),
				fieldExpression: selectedOption.data('field-expression'),
				selectedField: selectedOption.val(),
				orderBy: orderBy
			}).done((data) => {
				self.container.find('.js-report-selected-columns').append(data);
				self.removeReportColumn();
			});
		},
		removeReportColumn: function () {
			let removeSelectedColumnButton = this.container.find('.js-remove-selected-column');
			removeSelectedColumnButton.off('click');
			removeSelectedColumnButton.on('click', (e) => {
				let columnToRemove = $(e.currentTarget).closest('p');
				let formulaIdToDelete = columnToRemove.attr('data-field-formula-id');
				columnToRemove.remove();
				if (formulaIdToDelete > 0) {
					this.removeFormulaColumn(formulaIdToDelete);
				} else {
					this.enableOptionInSelect(columnToRemove.data('field-expression'));
				}
			});
		},
		removeFormulaColumn: function (formulaIdToDelete) {
			let addedFormulas = this.getAddedFormulas();
			this.container.find('p[data-column-formula-id="' + formulaIdToDelete + '"]').remove();
			if (addedFormulas.length > formulaIdToDelete) {
				const allFormulasColumn = this.container.find('p[data-field-formula-id]:not([data-field-formula-id=""])');
				$.each(allFormulasColumn, (_, item) => {
					const itemId = parseInt($(item).data('field-formula-id'));
					if (itemId > formulaIdToDelete) {
						$(item).attr('data-field-formula-id', itemId - 1);
						let relatedColumnsWithFormula = this.container.find('p[data-column-formula-id="' + itemId + '"]');
						$.each(relatedColumnsWithFormula, (_, relatedColumn) => {
							$(relatedColumn).attr('data-column-formula-id', itemId - 1);
						});
					}
				});
			}
			addedFormulas.splice(formulaIdToDelete - 1, 1);
			$('input[name="field-formula"]').val(JSON.stringify(addedFormulas));
		},
		enableOptionInSelect: function (columnToRemoveId) {
			let optionToEnable = $('option[data-field-expression="' + columnToRemoveId + '"]');
			if (optionToEnable.length > 0) {
				optionToEnable.prop('disabled', false);
			}
		},
		sortOrderButton: function () {
			$('.js-report-wizard-container').on('click', '.js-sort-order-button', (e) => {
				let element = $(e.currentTarget);
				let sortContainer = element.closest('.js-sort-container-element');
				let activeOrder = sortContainer.find('.js-sort-icon-active');
				let allOrders = sortContainer.find('.js-sort-icon');
				let nextOrder = activeOrder.next('.js-sort-icon');
				if (!nextOrder.length) {
					nextOrder = allOrders.first();
				}
				allOrders.removeClass('js-sort-icon-active');
				allOrders.addClass('d-none');
				nextOrder.addClass('js-sort-icon-active');
				nextOrder.removeClass('d-none');
			});
		},
		registerFormulaWizardModal: function () {
			const self = this;
			$('.js-add-field-formula').on('click', () => {
				AppConnector.request({
					module: app.getModuleName(),
					view: 'FieldFormulaModal',
					sourceModule: this.getSourceModuleName(),
					relations: this.getRelatedModulesAndRelations()
				}).done(function (data) {
					app.showModalWindow(data, (modalContainer) => {
						self.registerChangeFormulaFunction(modalContainer);
						self.registerAddNewFunctionField(modalContainer);
						self.saveFormulas(modalContainer);
						self.removeFormulaField(modalContainer);
					});
				});
			});
		},
		registerChangeFormulaFunction: function (modalContainer) {
			modalContainer.find('.js-select-formula-method').on('change', (e) => {
				let functionIcon = $(e.currentTarget).find('option:selected').data('function-sign');
				modalContainer.find('.js-function-method').text(functionIcon);
			});
		},
		registerAddNewFunctionField: function (modalContainer) {
			modalContainer.find('.js-add-function-field').on('click', () => {
				this.addFunctionField(modalContainer);
			});
		},
		addFunctionField: function (modalContainer) {
			let baseField = modalContainer.find('.js-base-function-field.d-none').clone(true, true);
			$(baseField).removeClass('d-none');
			$(baseField).find('.js-formula-field-select').addClass('select2');
			App.Fields.Picklist.showSelect2ElementView($(baseField).find('select.select2'));
			modalContainer.find('.js-field-function-container').append(baseField);
		},
		saveFormulas: function (modalContainer) {
			let containerValidate = modalContainer.find('form');
			containerValidate.validationEngine(app.validationEngineOptions);
			modalContainer.find('.js-save-formulas').on('click', () => {
				if (containerValidate.validationEngine('validate')) {
					let formula = this.getFormulaValuesToSave(modalContainer);
					this.addNewFormula(formula);
					app.hideModalWindow();
				}
			});
		},
		getFormulaValuesToSave: function (modalContainer) {
			let reportFormulaFields = modalContainer
				.find('.js-report-formula-container .js-formula-field-select')
				.map(function () {
					return $(this)
						.find('option:selected')
						.map(function () {
							return {
								expression: $(this).data('field-expression'),
								function: $(this).data('field-function'),
								label: $(this).data('field-label')
							};
						})
						.get();
				})
				.get()
				.flat()
				.filter(function (field) {
					return field.expression !== undefined && field.label !== undefined;
				});
			return {
				function: modalContainer.find('.js-select-formula-method option:selected').val(),
				field: reportFormulaFields
			};
		},
		addNewFormula: function (newFormula, addedFromModal = true) {
			let addedFormulas = this.getAddedFormulas();
			addedFormulas.push(newFormula);
			this.container.find('input[name="field-formula"]').val(JSON.stringify(addedFormulas));
			let formulaId = addedFormulas.length;
			if (addedFromModal) {
				this.addColumnsForFieldsUsedInFormula(newFormula, formulaId);
			}
			this.addFormulaToReportColumns(newFormula, formulaId);
		},
		getAddedFormulas: function () {
			let fieldFormulaInput = this.container.find('input[name="field-formula"]');
			let addedFormulas = [];
			if (fieldFormulaInput.val()) {
				addedFormulas = JSON.parse(fieldFormulaInput.val());
			}
			return addedFormulas;
		},
		addFormulaToReportColumns: function (newFormula, newFormulaId) {
			const self = this;
			AppConnector.request({
				module: app.getModuleName(),
				view: 'SelectedField',
				icon: 'fa-solid fa-square-root-variable',
				selectedField: this.getLabelForFormula(newFormula, newFormulaId),
				formulaId: newFormulaId
			}).done((data) => {
				self.container.find('.js-report-selected-columns').append(data);
				self.removeReportColumn();
				self.editFormula();
			});
		},
		getLabelForFormula: function (formula, formulaId) {
			let label = app.vtranslate('JS_FORMULA') + ' ' + formulaId + ' ' + app.vtranslate(formula.function);
			let reportQuery = this.container.find('input[name="query"]');
			reportQuery = reportQuery.val() ? JSON.parse(reportQuery.val()) : [];
			$.each(formula.field, function (_, field) {
				let functionFromExpression = '';
				$.each(reportQuery.expressions, function (_key, value) {
					if (value.field === field) {
						functionFromExpression = app.vtranslate(value.function) + ' ';
					}
				});
				const fieldLabel =
					$('.js-select-report-column option[data-field-expression="' + field + '"]').data('field-label') ||
					$('.js-select-aggregate-column option[data-field-expression="' + field + '"]').data('field-label') ||
					field.label ||
					'';
				label += ' ' + functionFromExpression + fieldLabel;
			});
			return label;
		},
		addColumnsForFieldsUsedInFormula: function (newFormula, formulaId) {
			const self = this;
			$.each(newFormula.field, (_, field) => {
				AppConnector.request({
					module: app.getModuleName(),
					view: 'SelectedField',
					icon: 'fa-solid fa-square-root-variable',
					fieldExpression: typeof field === 'string' ? field : field.expression,
					formulaColumnId: formulaId,
					function: typeof field === 'string' ? '' : field.function,
					selectedField: self.getLabelForFormulaColumn(field, formulaId)
				}).done((data) => {
					self.container.find('.js-report-selected-columns').append(data);
					self.removeReportColumn();
				});
			});
		},
		getLabelForFormulaColumn: function (field, formulaId) {
			const label =
				$('.js-select-report-column option[data-field-expression="' + field + '"]').data('field-label') ||
				$('.js-select-aggregate-column option[data-field-expression="' + field + '"]').data('field-label') ||
				field.label;
			return app.vtranslate('JS_FORMULA') + ' ' + formulaId + ' ' + (label || '');
		},
		removeFormulaField: function (modalContainer) {
			modalContainer.find('.js-remove-field-formula').on('click', (e) => {
				let formulaToRemove = $(e.currentTarget).closest('.js-base-function-field');
				formulaToRemove.remove();
			});
		},
		editFormula: function () {
			const self = this;
			let editFormulaButton = this.container.find('.js-edit-formula');
			editFormulaButton.on('click', (e) => {
				let formulaElement = $(e.currentTarget).closest('p');
				let formulaId = parseInt(formulaElement.data('field-formula-id'));
				let formulaKey = formulaId - 1;
				let addedFormulas = this.getAddedFormulas();
				if (formulaKey in addedFormulas) {
					let formulaToEdit = addedFormulas[formulaKey];
					AppConnector.request({
						module: app.getModuleName(),
						view: 'FieldFormulaModal',
						sourceModule: this.getSourceModuleName(),
						relations: this.getRelatedModulesAndRelations()
					}).done(function (data) {
						app.showModalWindow(data, (modalContainer) => {
							let formulaFunctionSelect = modalContainer.find('.js-select-formula-method');
							formulaFunctionSelect.val(formulaToEdit.function);
							let functionIcon = formulaFunctionSelect.find('option:selected').data('function-sign');
							modalContainer.find('.js-function-method').text(functionIcon);
							self.setFieldsUsedInFormula(modalContainer, formulaToEdit.field);
							self.registerChangeFormulaFunction(modalContainer);
							self.registerAddNewFunctionField(modalContainer);
							self.saveEditedFormulas(modalContainer, formulaId);
							self.removeFormulaField(modalContainer);
						});
					});
				}
			});
		},
		setFieldsUsedInFormula: function (modalContainer, formulaFields) {
			const self = this;
			let visibleFieldSelects = modalContainer.find('.js-formula-field-select:visible');
			let reportQuery = this.container.find('input[name="query"]');
			reportQuery = reportQuery.val() ? JSON.parse(reportQuery.val()) : [];
			$.each(formulaFields, (fieldOrder, formulaField) => {
				let functionFromExpression = '';
				let formulaExpression = formulaField.expression || formulaField;
				if (!formulaField.expression) {
					$.each(reportQuery.expressions, function (_key, value) {
						if (value.field === formulaExpression) {
							functionFromExpression = value.function;
						}
					});
				}
				let formulaFunction = formulaField.function || functionFromExpression || '';
				let valueToSelect;
				if (formulaFunction)
					valueToSelect = modalContainer
						.find(
							'.js-formula-field-select option[data-field-expression="' +
								formulaExpression +
								'"][data-field-function="' +
								formulaFunction +
								'"]'
						)
						.val();
				else {
					valueToSelect = modalContainer
						.find('.js-formula-field-select option[data-field-expression="' + formulaExpression + '"]')
						.val();
				}
				if (valueToSelect) {
					if (!(fieldOrder in visibleFieldSelects)) {
						self.addFunctionField(modalContainer);
						visibleFieldSelects = modalContainer.find('.js-formula-field-select:visible');
					}
					let selectContainer = visibleFieldSelects[fieldOrder];
					$(selectContainer).val(valueToSelect);
				}
			});
		},
		saveEditedFormulas: function (modalContainer, formulaId) {
			let containerValidate = modalContainer.find('form');
			containerValidate.validationEngine(app.validationEngineOptions);
			modalContainer.find('.js-save-formulas').on('click', () => {
				if (containerValidate.validationEngine('validate')) {
					$(
						'.js-report-selected-columns [data-field-formula-id="' + formulaId + '"] .js-remove-selected-column'
					).trigger('click');
					let formula = this.getFormulaValuesToSave(modalContainer);
					this.addNewFormula(formula);
					app.hideModalWindow();
				}
			});
		},
		removeAllSelectedColumns: function () {
			this.container.find('.js-remove-all-selected-columns').on('click', () => {
				this.container.find('.js-report-selected-columns').empty();
				this.container.find('[name="field-formula"]').val('');
				this.container.find('.js-select-report-column option').prop('disabled', false);
			});
		},
		preSaveReport: function () {
			let editViewForm = this.getForm();
			editViewForm.on(Vtiger_Edit_Js.recordPreSave, () => {
				if (!this.validIfAnyColumnIsSelect()) {
					return false;
				}
				this.setQueryParams();
			});
		},
		validIfAnyColumnIsSelect: function () {
			let result = true;
			let reportColumns = this.getSelectedColumns();
			if (reportColumns.length === 0) {
				app.showNotify({
					text: app.vtranslate('JS_SELECT_AT_LEAST_ONE_REPORT_COLUMN'),
					type: 'info'
				});
				result = false;
			}
			return result;
		},
		setQueryParams: function () {
			let reportColumns = this.getSelectedColumns();
			let aggregateColumns = this.getSelectedAggregateColumns();
			let fieldFormulas = this.parseInputValueToJson('field-formula');
			let expression = [];
			let formulaExpression = [];
			let baseItem;
			let columnFormula;
			let sort = 0;
			$.each(reportColumns, (_, reportColumn) => {
				baseItem = this.getCleanExpressionField();
				baseItem.sort = ++sort;
				baseItem.field = reportColumn.field;
				baseItem.order_by = reportColumn.sortOrder;
				baseItem.function = reportColumn.function;
				baseItem.formula_field = reportColumn.isFormulaField;
				if (reportColumn.formulaId > 0) {
					columnFormula = fieldFormulas[reportColumn.formulaId - 1];
					formulaExpression = [];
					$.each(columnFormula.field, function (_, obj) {
						formulaExpression.push(obj.expression || obj);
					});
					baseItem.field = JSON.stringify(formulaExpression);
					baseItem.function = columnFormula.function;
				}
				expression.push(baseItem);
			});
			$.each(aggregateColumns, (_, reportColumn) => {
				baseItem = this.getCleanExpressionField();
				baseItem.sort = ++sort;
				baseItem.field = reportColumn.field;
				baseItem.function = reportColumn.function;
				expression.push(baseItem);
			});
			let queryParam = {
				base_module_id: this.getSourceModuleName(),
				data_sources: this.container.find('input[name="data-sources"]').val(),
				expressions: expression,
				filter_group: this.conditionBuilder.getConditions(),
				joins: []
			};
			$('input[name="query"]').val(JSON.stringify(queryParam));
		},
		getSelectedColumns: function () {
			return this.container
				.find('.js-report-selected-columns .js-selected-columns')
				.map(function () {
					return {
						field: $(this).data('field-expression'),
						sortOrder: $(this).find('.js-sort-icon-active').data('val') || null,
						formulaId: $(this).attr('data-field-formula-id'),
						function: $(this).attr('data-field-function'),
						isFormulaField: $(this).attr('data-column-formula-id') ? $(this).attr('data-column-formula-id') : null
					};
				})
				.get();
		},
		getSelectedAggregateColumns: function () {
			return this.container
				.find('.js-selected-aggregate-columns-container .js-aggregate-column')
				.map(function () {
					return {
						field: $(this).data('field-expression'),
						function: $(this).data('field-function')
					};
				})
				.get();
		},
		parseInputValueToJson: function (inputName) {
			let inputValue = this.container.find('input[name="' + inputName + '"]').val();
			let result = [];
			if (inputValue) {
				result = JSON.parse(inputValue);
			}
			return result;
		},
		getCleanExpressionField: function () {
			return {
				field: '',
				function: '',
				group_by: null,
				order_by: null,
				sort: '',
				formula_field: 0
			};
		},
		loadReportData: function () {
			if (app.getRecordId() || this.isDuplicated()) {
				let reportQuery = this.container.find('input[name="query"]');
				reportQuery = JSON.parse(reportQuery.val());
				this.setReportFields(reportQuery.expressions)
					.then(() => {
						this.setAggregateColumns(reportQuery.expressions);
						this.registerFormulaWizardModal();
						this.loadConditionBuilderView();
						if (app.getRecordId()) {
							this.refreshPreview(false);
						}
					})
					.catch((error) => {
						console.error('Error in setReportFields:', error);
					});
			}
		},
		setReportFields: function (reportColumns) {
			return new Promise((resolve, reject) => {
				const self = this;
				this.getReportFields()
					.then(function () {
						const promises = [];
						$.each(reportColumns, (_, column) => {
							if (!column.group_by) {
								if (self.isJson(column.field)) {
									let formulaId = 1;
									let formulaFields = JSON.parse(column.field);
									$.each(formulaFields, (_, field) => {
										let formulaColumn = self.findObjectByFieldValue(reportColumns, field);
										if (formulaColumn) {
											promises.push(
												new Promise((resolve, reject) => {
													AppConnector.request({
														module: app.getModuleName(),
														view: 'SelectedField',
														icon: 'fa-solid fa-square-root-variable',
														fieldExpression: formulaColumn.field,
														formulaColumnId: formulaId,
														function: formulaColumn.function,
														selectedField: formulaColumn.field
													})
														.done((data) => {
															self.container.find('.js-report-selected-columns').append(data);
															self.removeReportColumn();
															resolve();
														})
														.fail((_jqXHR, _textStatus, errorThrown) => {
															reject(errorThrown);
														});
												})
											);
										}
									});
									self.addNewFormula(
										{
											function: column.function,
											field: formulaFields
										},
										false
									);
									formulaId++;
								} else if (!column.function && 1 !== column.formula_field) {
									let selectedOption = $(
										'.js-select-report-column option[data-field-expression="' + column.field + '"]'
									);
									selectedOption.prop('disabled', true);
									self.appendReportColumn(
										selectedOption.data('field-icon'),
										selectedOption.data('field-expression'),
										selectedOption.val(),
										column.order_by
									);
								}
							}
						});
						Promise.all(promises)
							.then(() => {
								resolve(true);
							})
							.catch((error) => {
								reject(error);
							});
					})
					.catch((error) => {
						reject(error);
					});
			});
		},
		findObjectByFieldValue: function (data, fieldValue) {
			return Object.values(data).some((obj) =>
				Array.isArray(obj.field) ? obj.field.includes(fieldValue) : obj.field === fieldValue
			)
				? Object.values(data).find((obj) =>
						Array.isArray(obj.field) ? obj.field.includes(fieldValue) : obj.field === fieldValue
				  )
				: null;
		},
		appendReportColumn: function (icon, fieldExpression, selectedField, orderBy) {
			let reportColumn = this.container.find('.js-selected-columns.d-none').clone(true, true);
			$(reportColumn).removeClass('d-none');
			if (icon) {
				let iconElement = $(reportColumn).find('.js-report-column-icon');
				$(iconElement).removeClass('d-none');
				$(iconElement).addClass(icon);
			}
			$(reportColumn).attr('data-field-expression', fieldExpression);
			$(reportColumn).find('.js-column-title').text(selectedField);
			let orderByContainer = $(reportColumn).find('.js-sort-container-element');
			$(orderByContainer).removeClass('d-none');
			if (orderBy) {
				$(orderByContainer)
					.find('[data-val="' + orderBy + '"]')
					.addClass('js-sort-icon-active')
					.removeClass('d-none');
			} else {
				$(orderByContainer).find('[data-val=""]').addClass('js-sort-icon-active').removeClass('d-none');
			}
			$('.js-report-selected-columns').append(reportColumn);
		},
		setAggregateColumns: function (reportColumns) {
			const self = this;
			this.getAggregateColumns().then(function () {
				$.each(reportColumns, (_, column) => {
					if (column.function && !column.group_by && !self.isJson(column.field)) {
						if (!self.ifFieldAndFunctionUsedInFormula(column.field, column.function)) {
							self.appendAggregateColumn(
								$(
									'.js-select-aggregate-column  option[data-field-expression="' +
										column.field +
										'"][data-field-function="' +
										column.function +
										'"]'
								)
							);
						}
					}
				});
			});
		},
		ifFieldAndFunctionUsedInFormula: function (fieldExpression, fieldFunction) {
			return $(
				'.js-report-selected-columns p[data-field-expression="' +
					fieldExpression +
					'"][data-field-function="' +
					fieldFunction +
					'"]'
			).length;
		},
		isJson: function (str) {
			try {
				JSON.stringify(JSON.parse(str));
				return true;
			} catch (e) {
				return false;
			}
		},
		registerRefreshPreview: function () {
			this.container.find('.js-refresh-report').on('click', () => {
				this.refreshPreview();
			});
		},
		refreshPreview: function (query = true) {
				if (!this.validIfAnyColumnIsSelect()) {
					return false;
				}
				const progressIndicatorElement = jQuery.progressIndicator({
					position: 'html',
					blockInfo: {
						enabled: true
					}
				});
				let params = {
					module: app.getModuleName(),
					view: 'Preview',
					record: this.container.find('input[name="record"]').val()
				}
				if (query) {
					this.setQueryParams();
					params.query = this.container.find('input[name="query"]').val();
				}
				AppConnector.request(params)
				.done((data) => {
					this.container.find('.js-report-preview').html(data);
					progressIndicatorElement.progressIndicator({ mode: 'hide' });
				}).fail(function (_error) {
					progressIndicatorElement.progressIndicator({ mode: 'hide' });
					app.showError({
						title: app.vtranslate('JS_ERROR')
					});
				});

		},
		isDuplicated: function () {
			return this.container.find('input[name="_duplicateRecord"]').length > 0;
		},
		getDuplicatedRecordId: function () {
			return this.container.find('input[name="_duplicateRecord"]').val();
		},
		registerBasicEvents: function (container) {
			this.container = container;
			this._super(container);
			this.showReportModulesOptions();
			this.selectReportColumn();
			this.removeReportColumn();
			this.removeAllSelectedColumns();
			this.preSaveReport();
			this.sortOrderButton();
			this.registerRefreshPreview();
			this.loadReportData();
		}
	}
);
