'use strict';

/**
 * InRelation SlaPolicy
 *
 * @description InRelation scripts for SlaPolicy module
 * @license     YetiForce Public License 7.0
 * @author      Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author      Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */"use strict";function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter(function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable})),t.push.apply(t,o);}return t}function _objectSpread(e){for(var t,r=1;r<arguments.length;r++)t=null==arguments[r]?{}:arguments[r],r%2?ownKeys(Object(t),!0).forEach(function(r){_defineProperty(e,r,t[r]);}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach(function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r));});return e}function _defineProperty(obj,key,value){return key=_toPropertyKey(key),key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}Vtiger_Detail_Js("ServiceContracts_Detail_Js",{},{/**
		 * Hide all settings
		 *
		 * @return  {self}
		 */hideAll:function hideAll(){return this.container.find(".js-sla-policy-template, .js-sla-policy-custom").addClass("d-none"),this},/**
		 * Show template settings
		 *
		 * @return  {self}
		 */showTemplateSettings:function showTemplateSettings(){return this.container.find(".js-sla-policy-template").removeClass("d-none"),this},/**
		 * Show custom settings
		 *
		 * @return  {self}
		 */showCustomSettings:function showCustomSettings(){return this.container.find(".js-sla-policy-custom").removeClass("d-none"),this},/**
		 * Get default params
		 * @returns {Object}
		 */getDefaultParam:function getDefaultParam(){return {module:"ServiceContracts",view:"PolicyTemplatesAjax",targetModule:this.targetModule,record:Number($("#recordId").val())}},/**
		 * Load predefined sla policy templates
		 * @param {Object} param
		 * @returns
		 */loadTemplates:function loadTemplates(param){var progress=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});return new Promise(function(resolve){AppConnector.request(param).done(function(data){progress.progressIndicator({mode:"hide"}),resolve(data);}).fail(function(e,t){progress.progressIndicator({mode:"hide"}),app.errorLog(e,t),app.showNotify({text:app.vtranslate("JS_ERROR"),type:"error"});});})},/**
		 * On policy type change event handler
		 */onPolicyTypeChange:function onPolicyTypeChange(){var _this=this;this.policyType=Number(this.container.find("[name=\"policy_type\"]:checked").val()),1===this.policyType?this.hideAll().showTemplateSettings().loadTemplates(_objectSpread({mode:"slaPolicyTemplate"},this.getDefaultParam())).then(function(data){_this.container.find(".js-sla-policy-template--container").html(data);}):2===this.policyType?this.hideAll().showCustomSettings():this.hideAll();},/**
		 * On submit event handler
		 *
		 * @param {Event} ev
		 */onSubmit:function onSubmit(ev){var _this2=this;ev.preventDefault(),ev.stopPropagation(),this.container.validationEngine(app.validationEngineOptions);var policyType=Number(this.container.find("[name=\"policy_type\"]:checked").val()),policyId=Number(this.container.find("[name=\"policy_id\"]:checked").val());if(2!==policyType||this.container.validationEngine("validate")){if(2===policyType&&!this.container.find(".js-custom-row").length)return void app.showNotify({text:app.vtranslate("JS_NO_ITEM_SELECTED"),type:"notice",animation:"show"});if(1===policyType&&isNaN(policyId))return void app.showNotify({text:app.vtranslate("JS_NO_ITEM_SELECTED"),type:"notice",animation:"show"});var progress=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params=this.container.serializeFormData();params.module="ServiceContracts",params.action="PolicySaveAjax",params.targetModule=this.targetModule,params.record=$("#recordId").val(),params.policyType=policyType,params.policyId=policyId,AppConnector.request({data:params}).done(function(data){progress.progressIndicator({mode:"hide"}),Array.isArray(data.result)?data.result.forEach(function(row,index){var rowElem=_this2.container.find(".js-custom-row").eq(index);rowElem.data("id",row.id),rowElem.find(".js-custom-row-id").val(row.id);}):$.each(_this2.container.find(".js-custom-row"),function(_index,rowElem){rowElem=$(rowElem),rowElem.data("id",0),rowElem.find(".js-custom-row-id").val(0);}),app.showNotify({text:app.vtranslate("JS_SAVE_NOTIFY_OK"),type:"success",animation:"show"});});}},/**
		 * Register add record button click
		 */registerAddRecordBtnClick:function registerAddRecordBtnClick(){var _this3=this,addPolicyBtn=this.container.find(".js-sla-policy-add-record-btn");addPolicyBtn.on("click",function(e){e.preventDefault(),e.stopPropagation(),_this3.loadTemplates(_objectSpread({mode:"slaPolicyCustom",index:_this3.container.find(".js-custom-row").length},_this3.getDefaultParam())).then(function(data){var html=$(data);App.Fields.TimePeriod.register(html),_this3.registerDelBtnClick(html),App.Fields.Picklist.showSelect2ElementView(html.find(".select2")),_this3.registerConditionBuilder(html.find(".js-condition-builder").eq(0),_this3.container.find(".js-conditions-col").length),_this3.container.find(".js-custom-conditions").append(html);});});},/**
		 * Register delete button click
		 *
		 * @param {jQuery} container
		 */registerDelBtnClick:function registerDelBtnClick(container){var _this4=this;container.find(".js-delete-row-action").on("click",function(e){e.preventDefault(),e.stopPropagation();var row=$(e.target).closest(".js-custom-row"),rowId=Number(row.data("id"));if(!rowId)return void row.remove();var progress=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request({module:"ServiceContracts",action:"PolicyDeleteAjax",targetModule:_this4.targetModule,record:row.data("record-id"),rowId:rowId}).done(function(){progress.progressIndicator({mode:"hide"}),$(e.target).closest(".card").remove(),app.showNotify({text:app.vtranslate("JS_SAVE_NOTIFY_OK"),type:"success",animation:"show"});});});},/**
		 * On condition change event
		 *
		 * @param   {Vtiger_ConditionBuilder_Js}  instance
		 */onConditionsChange:function onConditionsChange(instance){var index=this.conditionBuilders.indexOf(instance);this.conditionsBuildersContainers[index].parent().find(".js-conditions-value").val(JSON.stringify(instance.getConditions()));},/**
		 * Register condition builder
		 *
		 * @param {jQuery} container
		 * @param {Number} index
		 */registerConditionBuilder:function registerConditionBuilder(container,index){this.conditionBuilders[index]=new Vtiger_ConditionBuilder_Js(container,this.targetModule,this.onConditionsChange.bind(this)),this.conditionBuilders[index].registerEvents(),this.conditionsBuildersContainers[index]=container;},/**
		 * Init sla policy events
		 */initSlaPolicy:function initSlaPolicy(){var _this5=this;this.container=this.getForm(),this.policyType=Number(this.container.find("[name=\"policy_type\"]:checked").val()),this.targetModule=this.container.find("[name=\"target\"]").val(),this.conditionBuilders=[],this.conditionsBuildersContainers=[],this.container.off("submit").on("submit",this.onSubmit.bind(this)),this.container.find(".js-sla-policy-type-radio").on("click",function(){return _this5.onPolicyTypeChange()}),this.onPolicyTypeChange(),App.Fields.TimePeriod.register(this.container),this.registerAddRecordBtnClick(),this.registerDelBtnClick(this.container),$.each(this.container.find(".js-custom-conditions .js-condition-builder"),function(index,col){_this5.registerConditionBuilder($(col),index);});},registerEvents:function registerEvents(){this._super();var detailViewForm=this.getForm();detailViewForm.find(".js-sla-policy").length&&this.initSlaPolicy(),app.event.on("DetailView.Tab.AfterLoad",function(_event,_data,instance){instance.getForm().find(".js-sla-policy").length&&instance.initSlaPolicy();});}});
//# sourceMappingURL=Detail.min.js.map
