'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter(function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable})),t.push.apply(t,o);}return t}function _objectSpread(e){for(var t,r=1;r<arguments.length;r++)t=null==arguments[r]?{}:arguments[r],r%2?ownKeys(Object(t),!0).forEach(function(r){_defineProperty(e,r,t[r]);}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach(function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r));});return e}function _defineProperty(obj,key,value){return key=_toPropertyKey(key),key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}$.Class("Vtiger_List_Js",{listInstance:!1,getRelatedModulesContainer:!1,getInstance:function getInstance(){if(!1===Vtiger_List_Js.listInstance){var moduleClassName,fallbackClassName,instance,module=app.getModuleName(),parentModule=app.getParentModuleName();return "Settings"==parentModule?(moduleClassName=parentModule+"_"+module+"_List_Js","undefined"==typeof window[moduleClassName]&&(moduleClassName=module+"_List_Js"),fallbackClassName=parentModule+"_Vtiger_List_Js","undefined"==typeof window[fallbackClassName]&&(fallbackClassName="Vtiger_List_Js")):(moduleClassName=module+"_List_Js",fallbackClassName="Vtiger_List_Js"),instance="undefined"==typeof window[moduleClassName]?new window[fallbackClassName]:new window[moduleClassName],Vtiger_List_Js.listInstance=instance,instance}return Vtiger_List_Js.listInstance},/**
		 * function to trigger send Email
		 * @param {Object} params - a split object.
		 */triggerSendEmail:function triggerSendEmail(params){var listInstance=Vtiger_List_Js.getInstance();if(!0!==listInstance.checkListRecordSelected()){var postData=listInstance.getSearchParams();postData.cvid=listInstance.getCurrentCvId(),params&&$.extend(postData,params),this.showSendEmail(postData);}else listInstance.noRecordSelectedAlert();},showSendEmail:function showSendEmail(postData,callBackFunction){delete postData.parent,delete postData.mode,postData.view="SendMailModal",AppConnector.request(postData).done(function(response){app.showModalWindow(response,function(data){data.find("[name=\"saveButton\"]").on("click",function(){data.find("form").validationEngine("validate")&&($.extend(postData,{field:data.find("#field").val(),template:data.find("#template").val(),mailNotes:data.find("#mail_notes").val(),action:"Mail",mode:"sendMails"}),delete postData.view,AppConnector.request(postData).done(function(response){!0==response.result&&(app.hideModalWindow(),"function"==typeof callBackFunction&&callBackFunction(response));}).fail(function(){app.hideModalWindow();}));});});});},triggerMassQuickCreate:function triggerMassQuickCreate(moduleName,data){var listInstance=Vtiger_List_Js.getInstance();if(!0!=listInstance.checkListRecordSelected()){var progress=$.progressIndicator({blockInfo:{enabled:!0}}),params={callbackFunction:function callbackFunction(){},noCache:!0,data:$.extend(data,listInstance.getSearchParams(),{sourceView:"ListView"})};App.Components.QuickCreate.getForm("index.php?module="+moduleName+"&view=MassQuickCreateModal&sourceModule="+app.getModuleName(),moduleName,params).done(function(data){progress.progressIndicator({mode:"hide"}),App.Components.QuickCreate.showModal(data,params),app.registerEventForClockPicker();});}else listInstance.noRecordSelectedAlert();},triggerTransferOwnership:function triggerTransferOwnership(massActionUrl){var listInstance=Vtiger_List_Js.getInstance();!0==listInstance.checkListRecordSelected()?listInstance.noRecordSelectedAlert():app.showModalWindow(null,massActionUrl);},triggerQuickExport:function triggerQuickExport(module){var progressIndicatorElement=$.progressIndicator();app.showModalWindow(null,"index.php?module="+module+"&view=ExportRecords",function(container){container.find(".js-modal__save").on("click",function(){var formData=container.find(".js-modal-form").serializeFormData(),listInstance=Vtiger_List_Js.getInstance();$.extend(formData,listInstance.getSearchParams()),AppConnector.requestForm("index.php",formData),Vtiger_Helper_Js.showMessage({text:app.vtranslate("JS_STARTED_GENERATING_FILE"),type:"info"}),app.hideModalWindow();});}),progressIndicatorElement.progressIndicator({mode:"hide"});},triggerMassAction:function triggerMassAction(massActionUrl,callBackFunction,beforeShowCb,css){"undefined"==typeof beforeShowCb&&(beforeShowCb=function(){return !0}),"object"==_typeof(beforeShowCb)&&(css=beforeShowCb,beforeShowCb=function(){return !0});var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),actionParams={type:"POST",url:massActionUrl,dataType:"html",data:Vtiger_List_Js.getInstance().getSearchParams()};"undefined"==typeof css&&(css={}),css=$.extend({"text-align":"left"},css),AppConnector.request(actionParams).done(function(data){if(progressIndicatorElement.progressIndicator({mode:"hide"}),data){var result=beforeShowCb(data);if(!result)return;app.showModalWindow(data,function(data){"function"==typeof callBackFunction&&callBackFunction(data);},css);}}).fail(function(error,err){progressIndicatorElement.progressIndicator({mode:"hide"}),app.showNotify({title:app.vtranslate("JS_MESSAGE"),text:err,type:"error"});});},triggerMassEdit:function triggerMassEdit(massEditUrl){var listInstance=Vtiger_List_Js.getInstance();if(!0!==listInstance.checkListRecordSelected()){var selectedCount=this.getSelectedRecordCount();if(selectedCount>$("#listMaxEntriesMassEdit").val()){var params={title:app.vtranslate("JS_MESSAGE"),text:app.vtranslate("JS_MASS_EDIT_LIMIT"),type:"error"};return void app.showNotify(params)}Vtiger_List_Js.triggerMassAction(massEditUrl,function(container){app.event.trigger("MassEditModal.AfterLoad",container,massEditUrl);});}else listInstance.noRecordSelectedAlert();},getSelectedRecordCount:function getSelectedRecordCount(){var count,listInstance=Vtiger_List_Js.getInstance(),cvId=listInstance.getCurrentCvId(),selectedIdObj=$("#selectedIds").data(cvId+"selectedIds");if(selectedIdObj!=null)if("all"!=selectedIdObj)count=selectedIdObj.length;else {var excludedIdsCount=$("#excludedIds").data(cvId+"Excludedids").length,totalRecords=$("#recordsCount").val();count=totalRecords-excludedIdsCount;}return count},/**
		 * function to trigger export action
		 * returns UI
		 */triggerExportAction:function triggerExportAction(exportActionUrl,newTab){var formAttr={};newTab&&(formAttr.target="_blank");var params=Vtiger_List_Js.getInstance().getSearchParams();delete params.view,AppConnector.requestForm(exportActionUrl,params,formAttr);},/**
		 * Function to reload list
		 */clearList:function clearList(){$("#deSelectAllMsg").trigger("click"),$("#selectAllMsgDiv").hide();},triggerListSearch:function triggerListSearch(){var listInstance=Vtiger_List_Js.getInstance(),listViewContainer=listInstance.getListViewContentContainer();listViewContainer.find("[data-trigger=\"listSearch\"]").trigger("click");},getSelectedRecordsParams:function getSelectedRecordsParams(checkList){var listInstance=Vtiger_List_Js.getInstance();return !1==checkList||!0!==listInstance.checkListRecordSelected()?listInstance.getSearchParams():(listInstance.noRecordSelectedAlert(),!1)},triggerGenerateRecords:function triggerGenerateRecords(){var selected=Vtiger_List_Js.getSelectedRecordsParams();if(!1===selected)return !1;selected.view="GenerateModal",selected.fromview="List";var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});app.showModalWindow(null,"index.php?"+$.param(selected),function(){progressIndicatorElement.progressIndicator({mode:"hide"});});},showMap:function showMap(){var selectedParams=Vtiger_List_Js.getSelectedRecordsParams(!1),url="index.php?module=OpenStreetMap&view=MapModal&srcModule="+app.getModuleName();app.showModalWindow(null,url,function(container){var mapView=new OpenStreetMap_Map_Js;mapView.setSelectedParams(selectedParams),mapView.registerModalView(container);});},triggerReviewChanges:function triggerReviewChanges(reviewUrl){var listInstance=Vtiger_List_Js.getInstance(),validationResult=listInstance.checkListRecordSelected();!0===validationResult?listInstance.noRecordSelectedAlert():app.showConfirmModal({icon:"fa fa-check-circle",title:app.vtranslate("JS_LBL_REVIEW_CHANGES"),text:app.vtranslate("JS_MASS_REVIEWING_CHANGES_CONFIRMATION"),confirmedCallback:function confirmedCallback(){var params=_objectSpread({},listInstance.getSearchParams()),deleteMessage=app.vtranslate("JS_LOADING_PLEASE_WAIT"),progressIndicatorElement=$.progressIndicator({message:deleteMessage,position:"html",blockInfo:{enabled:!0}});delete params.view,delete params.module,delete params.parent,AppConnector.request({url:reviewUrl,data:params}).done(function(data){if(progressIndicatorElement.progressIndicator({mode:"hide"}),data.result){var _params={text:data.result,type:"info"};app.showNotify(_params);}else listInstance.getListViewRecords();}).fail(function(error,err){app.errorLog(error,err);});},rejectedCallback:function rejectedCallback(){Vtiger_List_Js.clearList();}});},/**
		 * Function to register the submit event for mass comment
		 */triggerMassComment:function triggerMassComment(massActionUrl){var listInstance=Vtiger_List_Js.getInstance();listInstance.checkListRecordSelected()?listInstance.noRecordSelectedAlert():Vtiger_List_Js.triggerMassAction(massActionUrl,function(data){new App.Fields.Text.Completions($(data).find(".js-completions").eq(0)),$(data).on("submit","#massSave",function(e){e.preventDefault();var form=$(e.currentTarget),commentContent=form.find(".js-comment-content"),commentContentValue=commentContent.html();if(""===commentContentValue){var errorMsg=app.vtranslate("JS_LBL_COMMENT_VALUE_CANT_BE_EMPTY");return void commentContent.validationEngine("showPrompt",errorMsg,"error","bottomLeft",!0)}form.find(".js-comment-value").val(commentContentValue),commentContent.validationEngine("hide"),form.find("[name=saveButton]").attr("disabled","disabled"),listInstance.massActionSave(form).done(function(){Vtiger_List_Js.clearList();});});});}},{//contains the List View element.
listViewContainer:!1,//Contains list view top menu element
listViewTopMenuContainer:!1,//Contains list view content element
listViewContentContainer:!1,//Contains filter Block Element
filterBlock:!1,filterSelectElement:!1,listSearchInstance:!1,noEventsListSearch:!0,//Contains float table head
listFloatThead:!1,getListSearchInstance:function getListSearchInstance(events){return null!=events&&(this.noEventsListSearch=events),!1==this.listSearchInstance&&(this.getListViewContainer().find(".searchField").length||this.getListViewContainer().find(".picklistSearchField").length)&&(this.listSearchInstance=YetiForce_ListSearch_Js.getInstance(this.getListViewContainer(),this.noEventsListSearch)),this.listSearchInstance},getListViewContainer:function getListViewContainer(){return !1==this.listViewContainer&&(this.listViewContainer=$("div.listViewPageDiv")),this.listViewContainer},getListViewTopMenuContainer:function getListViewTopMenuContainer(){return !1==this.listViewTopMenuContainer&&(this.listViewTopMenuContainer=$(".listViewTopMenuDiv")),this.listViewTopMenuContainer},getListViewContentContainer:function getListViewContentContainer(){return !1==this.listViewContentContainer&&(this.listViewContentContainer=$(".listViewContentDiv")),this.listViewContentContainer},getFilterBlock:function getFilterBlock(){if(!1==this.filterBlock){var filterSelectElement=this.getFilterSelectElement();0>=filterSelectElement.length?this.filterBlock=$():filterSelectElement.is("select")&&(this.filterBlock=filterSelectElement.data("select2").$dropdown);}return this.filterBlock},getFilterSelectElement:function getFilterSelectElement(){return !1==this.filterSelectElement&&(this.filterSelectElement=$("#customFilter")),this.filterSelectElement},getSearchParams:function getSearchParams(){var params=this.getDefaultParams();return !0!==this.checkListRecordSelected()&&(params.selected_ids=this.readSelectedIds(!0),params.excluded_ids=this.readExcludedIds(!0)),params},getDefaultParams:function getDefaultParams(){var params={module:app.getModuleName(),view:app.getViewName(),viewname:this.getCurrentCvId(),page:$("#pageNumber").val(),orderby:$("#orderBy").val(),entityState:$("#entityState").val()};app.getUrlVar("mid")&&(params.mid=app.getUrlVar("mid")),app.getParentModuleName()&&(params.parent=app.getParentModuleName()),$("#sortOrder").length&&(params.sortorder=$("#sortOrder").val());var advancedConditions=$("#listViewContents .js-custom-view-adv-cond");advancedConditions.length&&(params.advancedConditions=advancedConditions.val());var listSearchInstance=this.getListSearchInstance();if(!1!==listSearchInstance){var searchValue=listSearchInstance.getAlphabetSearchValue();params.search_params=listSearchInstance.getListSearchParams(!0),"undefined"!=typeof searchValue&&0<searchValue.length&&(params.search_key=listSearchInstance.getAlphabetSearchField(),params.search_value=searchValue,params.operator="s"),listSearchInstance.parseConditions(params),params.search_params=JSON.stringify(params.search_params);}return params},/**
		 * Function which will give you all the list view params
		 */getListViewRecords:function getListViewRecords(urlParams){var aDeferred=$.Deferred();"undefined"==typeof urlParams&&(urlParams={});var thisInstance=this,listViewContentsContainer=$("#listViewContents"),loadingMessage=$(".listViewLoadingMsg").text(),progressIndicatorElement=$.progressIndicator({message:loadingMessage,position:"html",blockInfo:{enabled:!0}}),defaultParams=this.getDefaultParams();return urlParams=$.extend(defaultParams,urlParams),AppConnector.requestPjax(urlParams).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),listViewContentsContainer.html(data),app.event.trigger("RecordListView.AfterLoad",data,thisInstance),thisInstance.calculatePages().done(function(data){aDeferred.resolve(data),app.notifyPostAjaxReady();}),thisInstance.postLoadListViewRecordsEvents(listViewContentsContainer),thisInstance.massUpdatePagination(urlParams),Vtiger_List_Js.clearList();}).fail(function(textStatus,errorThrown){progressIndicatorElement.progressIndicator({mode:"hide"}),app.showNotify({text:app.vtranslate("JS_NOT_ALLOWED_VALUE"),type:"error"}),aDeferred.reject(textStatus,errorThrown);}),aDeferred.promise()},postLoadListViewRecordsEvents:function postLoadListViewRecordsEvents(container){var self=this;this.registerPostLoadDesktopEvents(container),App.Fields.Picklist.showSelect2ElementView(container.find("select.select2")),App.Fields.Picklist.changeSelectElementView(container);var searchInstance=self.getListSearchInstance();!1!==searchInstance&&searchInstance.registerBasicEvents(),Vtiger_Index_Js.registerMailButtons(container),Vtiger_Helper_Js.showHorizontalTopScrollBar();var selectedIds=self.readSelectedIds();if(""!=selectedIds){if("all"==selectedIds){$(".listViewEntriesCheckBox").each(function(){$(this).prop("checked",!0).closest("tr").addClass("highlightBackgroundColor");}),$("#deSelectAllMsgDiv").show();var excludedIds=self.readExcludedIds();""!=excludedIds&&($("#listViewEntriesMainCheckBox").prop("checked",!1),$(".listViewEntriesCheckBox").each(function(index,element){-1!=$.inArray($(element).val(),excludedIds)&&$(element).prop("checked",!1).closest("tr").removeClass("highlightBackgroundColor");}));}else $(".listViewEntriesCheckBox").each(function(index,element){-1!=$.inArray($(element).val(),selectedIds)&&$(this).prop("checked",!0).closest("tr").addClass("highlightBackgroundColor");});self.checkSelectAll();}self.registerUnreviewedCountEvent(),self.registerLastRelationsEvent();},/**
		 * Function to calculate number of pages
		 */calculatePages:function calculatePages(){var aDeferred=$.Deferred(),element=$("#totalPageCount"),totalPageNumber=element.text();if(""==totalPageNumber){var totalRecordCount=$("#totalCount").val();if(""!=totalRecordCount){var pageLimit=$("#pageLimit").val();"0"==pageLimit&&(pageLimit=1);var pageCount=Math.ceil(totalRecordCount/pageLimit);return 0==pageCount&&(pageCount=1),element.text(pageCount),aDeferred.resolve(),aDeferred.promise()}aDeferred.resolve();}else aDeferred.resolve();return aDeferred.promise()},/**
		 * Function to return alerts if no records selected.
		 */noRecordSelectedAlert:function noRecordSelectedAlert(){var text=0<arguments.length&&arguments[0]!==void 0?arguments[0]:"JS_PLEASE_SELECT_ONE_RECORD";app.showNotify({text:app.vtranslate(text),type:"error"});},massActionSave:function massActionSave(form){var aDeferred=$.Deferred(),massActionUrl=form.serializeFormData(),progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});return AppConnector.request(massActionUrl).done(function(data){if(progressIndicatorElement.progressIndicator({mode:"hide"}),app.hideModalWindow(),!data.result){var params={text:app.vtranslate("JS_MASS_EDIT_NOT_SUCCESSFUL"),type:"info"};app.showNotify(params);}aDeferred.resolve(data);}).fail(function(error,err){app.hideModalWindow(),app.errorLog(error,err),aDeferred.reject(error,err);}),aDeferred.promise()},checkSelectAll:function checkSelectAll(){var state=!0;$(".listViewEntriesCheckBox").each(function(index,element){return $(element).is(":checked")?void(state=!0):(state=!1,!1)}),!0==state?$("#listViewEntriesMainCheckBox").prop("checked",!0):$("#listViewEntriesMainCheckBox").prop("checked",!1);},getRecordsCount:function getRecordsCount(){var aDeferred=$.Deferred(),recordCountVal=$("#recordsCount").val();if(""!=recordCountVal)aDeferred.resolve(recordCountVal);else {var count="",params=this.getDefaultParams();params.view="ListAjax",params.mode="getRecordsCount",AppConnector.request(params).done(function(data){var response=JSON.parse(data);$("#recordsCount").val(response.result.count),count=response.result.count,aDeferred.resolve(count);});}return aDeferred.promise()},getSelectOptionFromChosenOption:function getSelectOptionFromChosenOption(liElement){var id=liElement.attr("id"),idArr=id.split("-"),currentOptionId="";if(0<idArr.length)currentOptionId=idArr[idArr.length-1];else return !1;return $("#filterOptionId_"+currentOptionId)},readSelectedIds:function readSelectedIds(decode){var cvId=this.getCurrentCvId(),selectedIdsElement=$("#selectedIds");if(0>=selectedIdsElement.length)return "";var selectedIdsDataAttr=cvId+"selectedIds",selectedIdsElementDataAttributes=selectedIdsElement.data(),selectedIds=[];return selectedIdsDataAttr in selectedIdsElementDataAttributes?selectedIds=selectedIdsElementDataAttributes[selectedIdsDataAttr]:this.writeSelectedIds(selectedIds),!0==decode&&"object"==_typeof(selectedIds)?JSON.stringify(selectedIds):selectedIds},readExcludedIds:function readExcludedIds(decode){var cvId=this.getCurrentCvId(),excludedIds=[],exlcudedIdsElement=$("#excludedIds"),excludedIdsDataAttr=cvId+"Excludedids",excludedIdsElementDataAttributes=exlcudedIdsElement.data();return excludedIdsDataAttr in excludedIdsElementDataAttributes?excludedIds=excludedIdsElementDataAttributes[excludedIdsDataAttr]:this.writeExcludedIds(excludedIds),!0==decode&&"object"==_typeof(excludedIds)?JSON.stringify(excludedIds):excludedIds},writeSelectedIds:function writeSelectedIds(selectedIds){var cvId=this.getCurrentCvId();Array.isArray(selectedIds)||(selectedIds=[selectedIds]),$("#selectedIds").data(cvId+"selectedIds",selectedIds);},writeExcludedIds:function writeExcludedIds(excludedIds){var cvId=this.getCurrentCvId();$("#excludedIds").data(cvId+"Excludedids",excludedIds);},getCurrentCvId:function getCurrentCvId(){return $("#customFilter").find("option:selected").data("id")},getAlphabetSearchField:function getAlphabetSearchField(){return $("#alphabetSearchKey").val()},getAlphabetSearchValue:function getAlphabetSearchValue(){return $("#alphabetValue").val()},/**
		 * Function to check whether atleast minNumberOfRecords is checked
		 * @param {number} minNumberOfRecords
		 * @returns {boolean}
		 */checkListRecordSelected:function checkListRecordSelected(){var minNumberOfRecords=0<arguments.length&&arguments[0]!==void 0?arguments[0]:1;if(!1!=this.listViewContentContainer&&0!=this.listViewContentContainer.length&&0==this.listViewContentContainer.find("#selectedIds").length||(!1==this.listViewContentContainer||0==this.listViewContentContainer.length)&&0==$("#selectedIds").length)return !0;var selectedIds=this.readSelectedIds();return !!("object"===_typeof(selectedIds)&&selectedIds.length<minNumberOfRecords)},/**
		 * Function to go to page
		 * @param {int} page
		 */paginationGoToPage:function paginationGoToPage(page){var self=this,listViewPageDiv=self.getListViewContainer(),aDeferred=$.Deferred(),pageNumber=listViewPageDiv.find("#pageNumber");pageNumber.val(page),listViewPageDiv.find(".js-page-jump").val(page),self.getListViewRecords({orderby:listViewPageDiv.find("#orderBy").val(),sortorder:listViewPageDiv.find("#sortOrder").val(),viewname:self.getCurrentCvId()}).done(function(){aDeferred.resolve();}).fail(function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown);});},/**
		 * Function to register List view Page Navigation
		 */registerPageNavigationEvents:function registerPageNavigationEvents(){var _this=this,listViewPageDiv=this.getListViewContainer();listViewPageDiv.find(".js-next-page").on("click",function(e){_this.jumpToNextPage(e);}),listViewPageDiv.find(".js-page--previous").on("click",function(){_this.jumpToPreviousPage();}),listViewPageDiv.find(".pageNumber").on("click",function(e){_this.jumpToClickedPage($(e.currentTarget));}),listViewPageDiv.find(".js-count-number-records").on("click",function(){_this.updatePaginationAjax(!0);}),listViewPageDiv.find(".js-page--jump-drop-down").on("click","li",function(e){e.stopImmediatePropagation();}).on("keypress",".js-page-jump",function(e){_this.jumpToPage(e);});},/**
		 * Jump to next page
		 * @param {$} element
		 */jumpToNextPage:function jumpToNextPage(element){if(!$(element.currentTarget).hasClass("disabled")){var listViewPageDiv=this.getListViewContainer();listViewPageDiv.find("#noOfEntries").val()===listViewPageDiv.find("#pageLimit").val()&&this.paginationGoToPage(parseInt(listViewPageDiv.find("#pageNumber").val())+1);}},/**
		 * Jump to previous page
		 */jumpToPreviousPage:function jumpToPreviousPage(){var pageNumber=this.getListViewContainer().find("#pageNumber");1<pageNumber.val()&&this.paginationGoToPage(parseInt(pageNumber.val())-1);},/**
		 * Jump to clicked page function
		 * @param {$} element
		 */jumpToClickedPage:function jumpToClickedPage(element){return !element.hasClass("disabled")&&void this.paginationGoToPage(element.data("id"))},/**
		 * Jump to page function
		 * @param {$.Event} e
		 * @returns {boolean}
		 */jumpToPage:function jumpToPage(e){var self=this,listViewPageDiv=this.getListViewContainer();if(13===e.which){e.stopImmediatePropagation();var element=$(e.currentTarget),response=Vtiger_WholeNumberGreaterThanZero_Validator_Js.invokeValidation(element);if("undefined"!=typeof response)element.validationEngine("showPrompt",response,"","topLeft",!0);else {element.validationEngine("hideAll");var currentPageElement=listViewPageDiv.find("#pageNumber"),currentPageNumber=parseInt(currentPageElement.val()),newPageNumber=parseInt(element.val()),totalPages=parseInt(listViewPageDiv.find(".js-page--total").text());if(newPageNumber>totalPages)return void element.validationEngine("showPrompt",app.vtranslate("JS_PAGE_NOT_EXIST"),"","topLeft",!0);if(newPageNumber===currentPageNumber)return void Vtiger_Helper_Js.showMessage({text:app.vtranslate("JS_YOU_ARE_IN_PAGE_NUMBER")+" "+newPageNumber,type:"info"});currentPageElement.val(newPageNumber),self.getListViewRecords();}return !1}},/**
		 * Function to get page count and total number of records in list
		 */getPageCount:function getPageCount(){var aDeferred=$.Deferred(),pageCountParams=this.getPageJumpParams();return AppConnector.request(pageCountParams).done(function(data){var response;response="object"==_typeof(data)?data:JSON.parse(data),aDeferred.resolve(response);}).fail(function(){}),aDeferred.promise()},/**
		 * Function to get Page Jump Params
		 */getPageJumpParams:function getPageJumpParams(){var params=this.getDefaultParams();return params.view="ListAjax",params.mode="getPageCount",params},/**
		 * Function to update Pagining status
		 */updatePagination:function updatePagination(pageNumber){var _this2=this;pageNumber="undefined"==typeof pageNumber?1:pageNumber,AppConnector.request(Object.assign(this.getDefaultParams(),{module:app.getModuleName(),view:"Pagination",page:pageNumber,mode:"getPagination",sourceModule:$("#moduleFilter").val(),totalCount:$(".pagination").data("totalCount"),noOfEntries:$("#noOfEntries").val()})).done(function(data){$(".paginationDiv").html(data),_this2.registerPageNavigationEvents();});},/**
		 * Function to update pagination page numer
		 * @param {boolean} force
		 */updatePaginationAjax:function updatePaginationAjax(){var force=!!(0<arguments.length&&arguments[0]!==void 0)&&arguments[0],self=this,listViewPageDiv=this.getListViewContainer(),params=self.getDefaultParams(),container=listViewPageDiv.find(".paginationDiv");Vtiger_Helper_Js.showMessage({title:app.vtranslate("JS_LBL_PERMISSION"),text:app.vtranslate("JS_GET_PAGINATION_INFO"),type:"info"}),(0<container.find(".js-pagination-list").data("total-count")||force)&&(params.totalCount=-1,params.view="Pagination",params.mode="getPagination",AppConnector.request(params).done(function(data){container.html(data),self.registerPageNavigationEvents();}));},/**
		 * Function to register the event for changing the custom Filter
		 */registerChangeCustomFilterEvent:function registerChangeCustomFilterEvent(event){var _this3=this,target=$(event.currentTarget),selectOption="",selectOptionId="";target.is("option")?selectOption=target:"select2:selecting"===event.type?(selectOptionId=event.params.args.data.id,selectOption=$("#filterOptionId_".concat(selectOptionId))):"mouseup"===event.type&&(selectOptionId=event.currentTarget.id.split("-").pop(),selectOption=$("#filterOptionId_".concat(selectOptionId)),this.getFilterSelectElement().val(event.currentTarget.id.split("-").pop()).trigger("change")),0===$(".nav-item[data-cvid='".concat(selectOptionId,"'] .nav-link")).tab("show").length&&$(".js-filter-tab .active").removeClass("active"),app.setMainParams("pageNumber","1"),app.setMainParams("pageToJump","1"),app.setMainParams("orderBy",selectOption.data("orderby")),app.setMainParams("sortOrder",selectOption.data("sortorder"));var urlParams={viewname:selectOption.val(),//to make alphabetic search empty
search_key:this.getAlphabetSearchField(),search_value:"",search_params:"",advancedConditions:""},tileSelect=this.getListViewTopMenuContainer().find(".js-selected-tile-size");//Make the select all count as empty
//Make total number of pages as empty
0<tileSelect.length&&(urlParams.tile_size=tileSelect.attr("data-selected-tile-size")),$("#recordsCount").val(""),$("#totalPageCount").text(""),$(".pagination").data("totalCount",0),this.getListViewRecords(urlParams).done(function(){if(_this3.breadCrumbsFilter(selectOption.text()),_this3.ListViewPostOperation(),_this3.updatePagination(1),0<tileSelect.length){var tileInstance=new Vtiger_Tiles_Js;tileInstance.contentContainer=_this3.getListViewContainer(),tileInstance.setHeightOfTiles();}}),event.stopPropagation();},/**
		 * Function to register the event listeners for changing the custom Filter
		 */registerChangeCustomFilterEventListeners:function registerChangeCustomFilterEventListeners(){var _this4=this,filterSelect=this.getFilterSelectElement();// select change event must be replaced by click to avoid triggering while clicking on options' buttons
// event triggered by tab filter click
filterSelect.on("select2:selecting",function(event){//prevent default select2 event if it isn't keyboard event
return $(":focus").length?void _this4.registerChangeCustomFilterEvent(event):(event.preventDefault(),filterSelect.select2("close"),!1)}),filterSelect.on("click","option",this.registerChangeCustomFilterEvent.bind(this)),this.getFilterBlock().on("mouseup",".select2-results__option",this.registerChangeCustomFilterEvent.bind(this)),this.getListViewTopMenuContainer().find(".js-filter-tab").on("click",function(e){var cvId=$(e.currentTarget).data("cvid");filterSelect.find("[value=".concat(cvId,"]")).trigger("click"),filterSelect.val(cvId).trigger("change");});},breadCrumbsFilter:function breadCrumbsFilter(text){var breadCrumbs=$(".breadcrumbsContainer"),breadCrumbsLastSpan=breadCrumbs.last("span"),filterExist=breadCrumbsLastSpan.find(".breadCrumbsFilter");filterExist.length&&text!=null?filterExist.text(" ["+app.vtranslate("JS_FILTER")+": "+text+"]"):1>filterExist.length&&(text=text==null?this.getFilterSelectElement().find(":selected").text():text,breadCrumbsLastSpan.hasClass("breadCrumbsFilter")?breadCrumbsLastSpan.text(": "+text):breadCrumbs.append("<small class=\"breadCrumbsFilter hideToHistory p-1 js-text-content u-text-ellipsis--no-hover\" data-js=\"text\"> ["+app.vtranslate("JS_FILTER")+": "+text+"]</small>"));},ListViewPostOperation:function ListViewPostOperation(){return !0},/**
		 * Function to register the click event for list view main check box.
		 */registerMainCheckBoxClickEvent:function registerMainCheckBoxClickEvent(){var listViewPageDiv=this.getListViewContainer(),thisInstance=this;listViewPageDiv.on("click","#listViewEntriesMainCheckBox",function(){var selectedIds=thisInstance.readSelectedIds(),excludedIds=thisInstance.readExcludedIds();if($("#listViewEntriesMainCheckBox").is(":checked")){var recordCountObj=thisInstance.getRecordsCount();recordCountObj.done(function(data){$("#totalRecordsCount").text(data),"none"==$("#deSelectAllMsgDiv").css("display")&&$("#selectAllMsgDiv").show();}),$(".listViewEntriesCheckBox").each(function(index,element){$(this).prop("checked",!0).closest("tr").addClass("highlightBackgroundColor"),"all"==selectedIds?-1!=$.inArray($(element).val(),excludedIds)&&excludedIds.splice($.inArray($(element).val(),excludedIds),1):-1==$.inArray($(element).val(),selectedIds)&&selectedIds.push($(element).val());});}else $("#selectAllMsgDiv").hide(),$(".listViewEntriesCheckBox").each(function(index,element){$(this).prop("checked",!1).closest("tr").removeClass("highlightBackgroundColor"),"all"==selectedIds?(excludedIds.push($(element).val()),selectedIds="all"):selectedIds.splice($.inArray($(element).val(),selectedIds),1);});thisInstance.writeSelectedIds(selectedIds),thisInstance.writeExcludedIds(excludedIds);});},/**
		 * Function  to register click event for list view check box.
		 */registerCheckBoxClickEvent:function registerCheckBoxClickEvent(){var listViewPageDiv=this.getListViewContainer(),thisInstance=this;listViewPageDiv.on("click",".listViewEntriesCheckBox",function(e){var selectedIds=thisInstance.readSelectedIds(),excludedIds=thisInstance.readExcludedIds(),elem=$(e.currentTarget);elem.is(":checked")?(elem.closest("tr").addClass("highlightBackgroundColor"),"all"==selectedIds?excludedIds.splice($.inArray(elem.val(),excludedIds),1):-1==$.inArray(elem.val(),selectedIds)&&selectedIds.push(elem.val())):(elem.closest("tr").removeClass("highlightBackgroundColor"),"all"==selectedIds?(excludedIds.push(elem.val()),selectedIds="all"):selectedIds.splice($.inArray(elem.val(),selectedIds),1)),thisInstance.checkSelectAll(),thisInstance.writeSelectedIds(selectedIds),thisInstance.writeExcludedIds(excludedIds);});},/**
		 * Function to register the click event for select all.
		 */registerSelectAllClickEvent:function registerSelectAllClickEvent(){var listViewPageDiv=this.getListViewContainer(),thisInstance=this;listViewPageDiv.on("click","#selectAllMsg",function(){$("#selectAllMsgDiv").hide(),$("#deSelectAllMsgDiv").show(),$("#listViewEntriesMainCheckBox").prop("checked",!0),$(".listViewEntriesCheckBox").each(function(){$(this).prop("checked",!0).closest("tr").addClass("highlightBackgroundColor");}),thisInstance.writeSelectedIds("all");});},/**
		 * Function to register the click event for deselect All.
		 */registerDeselectAllClickEvent:function registerDeselectAllClickEvent(){var listViewPageDiv=this.getListViewContainer(),thisInstance=this;listViewPageDiv.on("click","#deSelectAllMsg",function(){$("#deSelectAllMsgDiv").hide(),$("#listViewEntriesMainCheckBox").prop("checked",!1),$(".listViewEntriesCheckBox").each(function(){$(this).prop("checked",!1).closest("tr").removeClass("highlightBackgroundColor");});thisInstance.writeSelectedIds([]),thisInstance.writeExcludedIds([]);});},/**
		 * Function to register the click event for listView headers
		 */registerHeadersClickEvent:function registerHeadersClickEvent(){var _this5=this;YetiForce_ListSearch_Js.registerSearch(this.getListViewContainer(),function(data){_this5.getListViewRecords(data);});},/**
		 * function to register the click event event for create filter
		 */createFilterClickEvent:function createFilterClickEvent(event){//to close the dropdown
this.getFilterSelectElement().data("select2").close(),new CustomView($(event.currentTarget).find("#createFilter").data("createurl"));},registerFeaturedFilterClickEvent:function registerFeaturedFilterClickEvent(){var thisInstance=this,listViewFilterBlock=this.getFilterBlock();!1!=listViewFilterBlock&&listViewFilterBlock.on("mouseup",".js-filter-favorites",function(event){var liElement=$(this).closest(".select2-results__option"),currentOptionElement=thisInstance.getSelectOptionFromChosenOption(liElement),params={cvid:currentOptionElement.attr("value"),module:"CustomView",action:"Featured",sorceModuleName:app.getModuleName()};params.actions=1===currentOptionElement.data("featured")?"remove":"add",AppConnector.request(params).done(function(){window.location.reload();}),event.stopPropagation();});},/**
		 * Function to register the click event for duplicate filter
		 */registerDuplicateFilterClickEvent:function registerDuplicateFilterClickEvent(){var thisInstance=this,listViewFilterBlock=this.getFilterBlock();!1!=listViewFilterBlock&&listViewFilterBlock.on("mouseup",".js-filter-duplicate",function(event){thisInstance.getFilterSelectElement().data("select2").close();var liElement=$(event.currentTarget).closest(".select2-results__option"),currentOptionElement=thisInstance.getSelectOptionFromChosenOption(liElement),editUrl=currentOptionElement.data("duplicateurl");new CustomView(editUrl),event.stopPropagation();});},/**
		 * Function to register the click event for edit filter
		 */registerEditFilterClickEvent:function registerEditFilterClickEvent(){var thisInstance=this,listViewFilterBlock=this.getFilterBlock();!1!=listViewFilterBlock&&listViewFilterBlock.on("mouseup",".js-filter-edit",function(event){thisInstance.getFilterSelectElement().data("select2").close();var liElement=$(event.currentTarget).closest(".select2-results__option"),currentOptionElement=thisInstance.getSelectOptionFromChosenOption(liElement),editUrl=currentOptionElement.data("editurl");new CustomView(editUrl),event.stopPropagation();});},/**
		 * Function to register the click event for delete filter
		 */registerDeleteFilterClickEvent:function registerDeleteFilterClickEvent(){var self=this,listViewFilterBlock=this.getFilterBlock();!1!=listViewFilterBlock&&listViewFilterBlock.on("mouseup",".js-filter-delete",function(event){self.getFilterSelectElement().data("select2").close();var liElement=$(event.currentTarget).closest(".select2-results__option");app.showConfirmModal({title:app.vtranslate("JS_LBL_ARE_YOU_SURE_YOU_WANT_TO_DELETE_FILTER"),confirmedCallback:function confirmedCallback(){AppConnector.requestForm(self.getSelectOptionFromChosenOption(liElement).data("deleteurl"));}}),event.stopPropagation();});},/**
		 * Function to register the click event for approve filter
		 */registerApproveFilterClickEvent:function registerApproveFilterClickEvent(){var thisInstance=this,listViewFilterBlock=this.getFilterBlock();!1!=listViewFilterBlock&&listViewFilterBlock.on("mouseup",".js-filter-approve",function(event){thisInstance.getFilterSelectElement().data("select2").close();var liElement=$(event.currentTarget).closest(".select2-results__option");AppConnector.requestForm(thisInstance.getSelectOptionFromChosenOption(liElement).data("approveurl")),event.stopPropagation();});},/**
		 * Function to register the click event for deny filter
		 */registerDenyFilterClickEvent:function registerDenyFilterClickEvent(){var thisInstance=this,listViewFilterBlock=this.getFilterBlock();!1!=listViewFilterBlock&&listViewFilterBlock.on("mouseup",".js-filter-deny",function(event){thisInstance.getFilterSelectElement().data("select2").close();var liElement=$(event.currentTarget).closest(".select2-results__option");AppConnector.requestForm(thisInstance.getSelectOptionFromChosenOption(liElement).data("denyurl")),event.stopPropagation();});},/**
		 * Function to generate filter actions template
		 */appendFilterActionsTemplate:function appendFilterActionsTemplate(liElement){var currentOptionElement=this.getSelectOptionFromChosenOption(liElement),template=$("<span class=\"js-filter-actions o-filter-actions noWrap float-right\">\n\t\t\t\t\t<span ".concat(1===currentOptionElement.data("featured")?"title=\""+app.vtranslate("JS_REMOVE_TO_FAVORITES")+"\"":"title=\""+app.vtranslate("JS_ADD_TO_FAVORITES")+"\""," data-value=\"favorites\" data-js=\"click\"\n\t\t\t\t\t\t  class=\" mr-1 js-filter-favorites ").concat(1===currentOptionElement.data("featured")?"fas ti ti-star-filled":"far ti ti-star","\n\t\t\t\t\t\t  \t\t ").concat(currentOptionElement.data("featured")===void 0?"d-none":"","\"\"></span>\n\t\t\t\t\t<span title=\"").concat(app.vtranslate("JS_DUPLICATE"),"\" data-value=\"duplicate\" data-js=\"click\"\n\t\t\t\t\t\t  class=\"fas fa-retweet mr-1 js-filter-duplicate ").concat(0===$("#createFilter").length?"d-none":"","\"></span>\n\t\t\t\t\t<span title=\"").concat(app.vtranslate("JS_EDIT"),"\" data-value=\"edit\" data-js=\"click\"\n\t\t\t\t\t\t  class=\"fas fa-pencil-alt mr-1 js-filter-edit ").concat(1===currentOptionElement.data("editable")?"":"d-none","\"></span>\n\t\t\t\t\t<span title=\"").concat(app.vtranslate("JS_DELETE"),"\" data-value=\"delete\" data-js=\"click\"\n\t\t\t\t\t\t  class=\"fas fa-trash-alt mr-1 js-filter-delete ").concat(1===currentOptionElement.data("deletable")?"":"d-none","\"></span>\n\t\t\t\t\t<span title=\"").concat(app.vtranslate("JS_DENY"),"\" data-value=\"deny\" data-js=\"click\"\n\t\t\t\t\t\t  class=\"fas fa-exclamation-circle mr-1 js-filter-deny ").concat(1===currentOptionElement.data("public")?"":"d-none","\"></span>\n\t\t\t\t\t<span title=\"").concat(app.vtranslate("JS_APPROVE"),"\" data-value=\"approve\" data-js=\"click\"\n\t\t\t\t\t\t  class=\"fas fa-check mr-1 js-filter-approve ").concat(1===currentOptionElement.data("pending")?"":"d-none","\"></span>\n\t\t\t\t</span>"));template.appendTo(liElement.find(".js-filter__title"));},/**
		 * Function to register the hover event for customview filter options
		 */registerCustomFilterOptionsHoverEvent:function registerCustomFilterOptionsHoverEvent(){var _this6=this,filterBlock=this.getFilterBlock();!1!=filterBlock&&filterBlock.on("mouseenter mouseleave","li.select2-results__option[role=\"option\"]",function(event){var liElement=$(event.currentTarget),liFilterImages=liElement.find(".js-filter-actions");liElement.hasClass("group-result")||"mouseenter"===event.type&&0===liFilterImages.length&&_this6.appendFilterActionsTemplate(liElement);});},/**
		 * Function to register the list view row click event
		 */registerRowClickEvent:function registerRowClickEvent(){var lastEvent=!1;this.getListViewContentContainer().on("click",".listViewEntries",function(e){if(!$(e.target).hasClass("js-no-link")&&!$(e.target).closest("div").hasClass("actions")&&!($(e.target).is("button")||$(e.target).parent().is("button"))&&!$(e.target).closest("a").hasClass("noLinkBtn")&&!$(e.target).is("a")&&!$(e.target).is("input[type=\"checkbox\"]")){var element=$(e.currentTarget);if(!$(e.target,element).is("td:first-child")&&!$.contains(element.find("td:last-child").get(0),e.target)&&!$.contains(element.find("td:first-child").get(0),e.target)){var recordUrl=element.data("recordurl");"undefined"==typeof recordUrl||(lastEvent?(lastEvent=e.timeStamp,element.find(".js-quick-edit-modal").length?element.find(".js-quick-edit-modal").trigger("click"):element.find(".js-full-edit").length&&element.find(".js-full-edit").trigger("click")):(lastEvent=e.timeStamp,setTimeout(function(){lastEvent===e.timeStamp?window.location.href=recordUrl:lastEvent=!1;},300)));}}});},/**
		 * Register mass records events.
		 */registerMassRecordsEvents:function registerMassRecordsEvents(){var self=this;this.getListViewContainer().on("click",".js-mass-record-event",function(){var target=$(this),listInstance=Vtiger_List_Js.getInstance();if(!(!0!=listInstance.checkListRecordSelected()))listInstance.noRecordSelectedAlert();else if("modal"===target.data("type")){var vars={};target.data("url").replace(/[?&]+([^=&]+)=([^&]*)/gi,function(m,key,value){vars[key]=value;}),AppConnector.request({type:"POST",url:target.data("url"),data:$.extend(self.getSearchParams(),vars)}).done(function(modal){app.showModalWindow(modal);});}else {var params={icon:!1,confirmedCallback:function confirmedCallback(){var progressIndicatorElement=$.progressIndicator(),dataParams=self.getSearchParams();delete dataParams.view,AppConnector.request({type:"POST",url:target.data("url"),data:dataParams}).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),data&&data.result&&data.result.notify&&Vtiger_Helper_Js.showMessage(data.result.notify),self.getListViewRecords();}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"});});}};target.data("confirm")?(params.text=target.data("confirm"),params.title=target.html()):params.text=target.html(),app.showConfirmModal(params);}});},/**
		 * Update pagination row
		 * @param {Array} urlParams
		 */massUpdatePagination:function massUpdatePagination(){var urlParams=0<arguments.length&&arguments[0]!==void 0?arguments[0]:[],self=this,listViewPageDiv=this.getListViewContainer(),paginationObject=listViewPageDiv.find(".js-pagination-list"),totalCount=paginationObject.data("totalCount"),pageNumber=parseInt(listViewPageDiv.find("#pageNumber").val()),tempPageNumber=pageNumber,selectedIds=self.readSelectedIds(!1);"all"===selectedIds[0]?(pageNumber=1,totalCount=0):(""!==totalCount&&0!==totalCount&&(totalCount-=selectedIds.length),0>=listViewPageDiv.find("#noOfEntries").val()&&1!==pageNumber&&pageNumber--),paginationObject.data("totalCount",totalCount),self.updatePagination(pageNumber),tempPageNumber!==pageNumber&&(!$.isEmptyObject(urlParams)&&(urlParams.page=pageNumber),self.getListViewRecords(urlParams)),self.writeSelectedIds([]);},/**
		 * Function to register the click event of url field
		 */registerUrlFieldClickEvent:function registerUrlFieldClickEvent(){var listViewContentDiv=this.getListViewContentContainer();listViewContentDiv.on("click",".urlField",function(e){e.stopPropagation();});},changeCustomFilterElementView:function changeCustomFilterElementView(){var thisInstance=this,filterSelectElement=this.getFilterSelectElement();if(0<filterSelectElement.length&&filterSelectElement.is("select")){App.Fields.Picklist.showSelect2ElementView(filterSelectElement,{templateSelection:function templateSelection(data){var resultContainer=document.createElement("span"),span=document.createElement("span"),image=$(".filterImage").clone();return image.removeAttr("style"),span.innerText=data.text,resultContainer.appendChild(image.get(0)),resultContainer.appendChild(span),resultContainer},customSortOptGroup:!0,templateResult:function templateResult(data){var main=document.createElement("div"),actualElement=$(data.element);if(actualElement.is("option")){var div=document.createElement("div"),divSec=document.createElement("div"),divInner=document.createElement("div");divSec.className="u-text-ellipsis--no-hover",div.className="js-filter__title d-flex justify-content-between",actualElement.data("option")!==void 0&&(divInner.className="u-max-w-lg-100 u-text-ellipsis--no-hover d-inline-block small",divInner.innerText=actualElement.data("option")),divSec.innerText=actualElement.text(),div.appendChild(divSec),main.appendChild(div),main.appendChild(divInner);}else main.innerText=actualElement.attr("label");return main},closeOnSelect:!0});var select2Instance=filterSelectElement.data("select2");$(".filterActionsDiv").appendTo(select2Instance.$dropdown.find(".select2-dropdown:last")).removeClass("d-none").on("click",function(e){thisInstance.createFilterClickEvent(e);});}},/**
		 * Function to show total records count in listview on hover
		 * of pageNumber text
		 */registerEventForTotalRecordsCount:function registerEventForTotalRecordsCount(){var thisInstance=this;$(".totalNumberOfRecords").on("click",function(e){var element=$(e.currentTarget),totalRecordsElement=$("#totalCount"),totalNumberOfRecords=totalRecordsElement.val();element.addClass("d-none"),element.parent().progressIndicator({}),""==totalNumberOfRecords?thisInstance.getPageCount().done(function(data){totalNumberOfRecords=data.result.numberOfRecords,totalRecordsElement.val(totalNumberOfRecords),thisInstance.showPagingInfo();}):thisInstance.showPagingInfo(),element.parent().progressIndicator({mode:"hide"});});},showPagingInfo:function showPagingInfo(){var totalNumberOfRecords=$("#totalCount").val(),pageNumberElement=$(".pageNumbersText"),pageRange=pageNumberElement.text(),listViewEntriesCount=parseInt($("#noOfEntries").val());0==listViewEntriesCount?$(".pageNumbersText").html(""):$(".pageNumbersText").html(pageRange+" ("+totalNumberOfRecords+")");},registerUnreviewedCountEvent:function registerUnreviewedCountEvent(){var _this7=this,ids=[],listViewContentDiv=this.getListViewContentContainer(),isUnreviewedActive=listViewContentDiv.find(".unreviewed").length;listViewContentDiv.find("tr.listViewEntries").each(function(){var id=$(this).data("id");id&&ids.push(id);});!ids||1>isUnreviewedActive||AppConnector.request({action:"ChangesReviewedOn",mode:"getUnreviewed",module:"ModTracker",sourceModule:app.getModuleName(),recordsId:ids}).done(function(appData){var data=appData.result;$.each(data,function(id,value){0<value.a&&listViewContentDiv.find("tr[data-id=\""+id+"\"] .unreviewed .badge.all").text(value.a).parent().removeClass("d-none"),0<value.m&&listViewContentDiv.find("tr[data-id=\""+id+"\"] .unreviewed .badge.mail").text(value.m).parent().removeClass("d-none");}),_this7.reflowThead();});},registerLastRelationsEvent:function registerLastRelationsEvent(){var _this8=this,ids=[],listViewContentDiv=this.getListViewContentContainer(),isTimeLineActive=listViewContentDiv.find(".timeLineIconList").length;listViewContentDiv.find("tr.listViewEntries").each(function(){var id=$(this).data("id");id&&ids.push(id);});!ids||1>isTimeLineActive||AppConnector.request({action:"LastRelation",module:"ModTracker",sourceModule:app.getModuleName(),recordsId:ids}).done(function(appData){var data=appData.result;$.each(data,function(id,value){value.type&&listViewContentDiv.find("tr[data-id=\""+id+"\"] .timeLineIconList").addClass(value.color+" yfm-"+value.type).removeClass("d-none").on("click",function(e){var element=$(e.currentTarget),url=element.data("url");app.showModalWindow(null,url,function(data){Vtiger_Index_Js.registerMailButtons(data);});});}),_this8.reflowThead();});},registerChangeEntityStateEvent:function registerChangeEntityStateEvent(){var thisInstance=this;$(".dropdownEntityState a").on("click",function(){var element=$(this);element.closest("ul").find("a").removeClass("active"),element.addClass("active"),$("#entityState").val(element.data("value")),app.setMainParams("pageNumber","1"),app.setMainParams("pageToJump","1"),$("#recordsCount").val(""),$("#totalPageCount").text(""),$(".pagination").data("totalCount",0),$("#dropdownEntityState").find(".js-icon").attr("class",element.find(".js-icon").attr("class")),thisInstance.getListViewRecords().done(function(){thisInstance.calculatePages().done(function(){thisInstance.updatePagination();});});});},registerSummationEvent:function registerSummationEvent(){var self=this,listContainer=this.getListViewContentContainer();listContainer.on("click",".listViewSummation button",function(){var button=$(this),calculateValue=button.closest("td").find(".calculateValue"),params=self.getSearchParams(),progress=$.progressIndicator({message:app.vtranslate("JS_CALCULATING_IN_PROGRESS"),position:"html",blockInfo:{enabled:!0}});params.action="List",params.mode="calculate",params.fieldName=button.data("field"),params.calculateType=button.data("operator"),delete params.view,app.hidePopover(button);var scrollLeft=listContainer.scrollLeft(),scrollTop=listContainer.scrollTop();AppConnector.request(params).done(function(response){response.success?calculateValue.html(response.result):calculateValue.html(""),self.registerFixedThead(listContainer),listContainer.scrollLeft(scrollLeft),listContainer.scrollTop(scrollTop),progress.progressIndicator({mode:"hide"});});});},registerListScroll:function registerListScroll(container){var containerH=container.height(),containerOffsetTop=container.offset().top,footerH=$(".js-footer").height(),windowH=$(window).height();//	if list is bigger than window fit its height to it
containerH+containerOffsetTop+footerH>windowH&&container.height(windowH-(containerOffsetTop+footerH)),container.find(".js-fixed-thead").floatThead("destroy"),container.siblings(".floatThead-container").remove(),app.showNewScrollbarTopBottomRight(container),app.registerMiddleClickScroll(container);},registerFixedThead:function registerFixedThead(container){Quasar.plugins.Platform.is.desktop||(this.listFloatThead=container.find(".js-fixed-thead"),this.listFloatThead.floatThead("destroy"),this.listFloatThead.floatThead({scrollContainer:function scrollContainer(){return container}}),this.listFloatThead.floatThead("reflow"));},getFloatTheadContainer:function getFloatTheadContainer(){var container=0<arguments.length&&void 0!==arguments[0]?arguments[0]:this.getListViewContentContainer();return !1===this.listFloatThead&&(this.listFloatThead=container.find(".js-fixed-thead")),this.listFloatThead},reflowThead:function reflowThead(){Quasar.plugins.Platform.is.desktop&&this.getFloatTheadContainer().floatThead("reflow");},registerMassActionsBtnEvents:function registerMassActionsBtnEvents(){var _this9=this;this.getListViewContainer().on("click",".js-mass-action",function(e){e.preventDefault();var element=$(e.currentTarget),url=element.data("url");if("undefined"!=typeof url)if(void 0!==element.data("checkSelected")&&0==element.data("checkSelected")||!0!==_this9.checkListRecordSelected())switch(element.data("type")){case"modal":Vtiger_List_Js.triggerMassAction(url);break;case"formRedirect":Vtiger_List_Js.triggerExportAction(url,"new"===element.data("tab")),Vtiger_List_Js.clearList();break;case"reload":var params=self.getSearchParams();delete params.view,delete params.action,params.sourceModule=params.module,delete params.module,AppConnector.request({type:"POST",url:url,data:params}).done(function(response){self.getListViewRecords(),Vtiger_List_Js.clearList(),response.result&&Vtiger_Helper_Js.showMessage(response.result.message);});}else _this9.noRecordSelectedAlert();e.stopPropagation();});},registerMassActionsBtnMergeEvents:function registerMassActionsBtnMergeEvents(){var _this10=this;this.getListViewContainer().on("click",".js-mass-action--merge",function(e){var url=$(e.target).data("url");"undefined"!=typeof url&&(!0===_this10.checkListRecordSelected(2)?_this10.noRecordSelectedAlert("JS_SELECT_ATLEAST_TWO_RECORD_FOR_MERGING"):Vtiger_List_Js.triggerMassAction(url));});},/**
		 * Register desktop events
		 * @param {$} listViewContainer
		 */registerDesktopEvents:function registerDesktopEvents(listViewContainer){Quasar.plugins.Platform.is.desktop&&listViewContainer.length&&(this.registerListScroll(listViewContainer),this.registerFixedThead(listViewContainer));},registerPostLoadDesktopEvents:function registerPostLoadDesktopEvents(listViewContainer){Quasar.plugins.Platform.is.desktop&&(new PerfectScrollbar(listViewContainer[0]).destroy(),listViewContainer.find(".js-fixed-thead").floatThead("destroy"),listViewContainer.siblings(".floatThead-container").remove(),new PerfectScrollbar(listViewContainer[0]),this.registerFixedThead(listViewContainer));},/**
		 * Register keyboard shortcuts events
		 */registerKeyboardShortcutsEvent:function registerKeyboardShortcutsEvent(){document.addEventListener("keydown",function(event){event.shiftKey&&event.ctrlKey&&"KeyA"===event.code&&$(".js-add-record").length&&(window.location.href="index.php?module="+app.getModuleName()+"&view=Edit");});},/**
		 * Function that executes after the mass delete action
		 */postMassDeleteRecords:function postMassDeleteRecords(){var aDeferred=$.Deferred(),listInstance=Vtiger_List_Js.getInstance();return app.hideModalWindow(),listInstance.getListViewRecords().done(function(){$("#recordsCount").val(""),$("#totalPageCount").text(""),$("#deSelectAllMsg").trigger("click"),listInstance.calculatePages().done(function(){listInstance.updatePagination();}),aDeferred.resolve();}),$("#recordsCount").val(""),aDeferred.promise()},/**
		 * Function to register events
		 */registerEvents:function registerEvents(){this.registerRowClickEvent(),this.registerPageNavigationEvents(),this.registerMainCheckBoxClickEvent(),this.registerCheckBoxClickEvent(),this.registerSelectAllClickEvent(),this.registerDeselectAllClickEvent(),this.registerMassRecordsEvents(),this.registerMassActionsBtnMergeEvents(),this.registerHeadersClickEvent(),this.changeCustomFilterElementView(),this.registerFeaturedFilterClickEvent(),this.registerChangeCustomFilterEventListeners(),this.registerChangeEntityStateEvent(),this.registerDuplicateFilterClickEvent(),this.registerEditFilterClickEvent(),this.registerDeleteFilterClickEvent(),this.registerApproveFilterClickEvent(),this.registerDenyFilterClickEvent(),this.registerCustomFilterOptionsHoverEvent(),"undefined"!=typeof CustomView&&CustomView.registerCustomViewAdvCondEvents(this.getListViewContainer()),App.Fields.Text.registerCopyClipboard(this.getListViewContainer()),this.registerMassActionsBtnEvents(),Vtiger_Helper_Js.showHorizontalTopScrollBar(),this.registerUrlFieldClickEvent(),this.registerEventForTotalRecordsCount(),this.registerSummationEvent();//Just reset all the checkboxes on page load: added for chrome issue.
var listViewContainer=this.getListViewContentContainer();listViewContainer.find("#listViewEntriesMainCheckBox,.listViewEntriesCheckBox").prop("checked",!1),this.getListSearchInstance(!1),this.registerDesktopEvents(listViewContainer),this.registerUnreviewedCountEvent(),this.registerLastRelationsEvent(),this.registerKeyboardShortcutsEvent(),Vtiger_Index_Js.registerMailButtons(listViewContainer);}});
//# sourceMappingURL=List.min.js.map
