'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";$.Class("Vtiger_Tiles_Js",{},{contentContainer:!1,/**
		 * Register tiles size change action
		 * @param {jQuery} topMenuContainer
		 */registerTileSizeChange:function registerTileSizeChange(topMenuContainer){var _this=this;topMenuContainer.find(".js-tile-size").on("click",function(e){var selectedTileSize=$(e.currentTarget).attr("data-tile-size");topMenuContainer.find(".js-tile-dropdown-title").text($(e.currentTarget).text()),topMenuContainer.find(".js-selected-tile-size").attr("data-selected-tile-size",selectedTileSize),app.setMainParams("pageNumber","1"),app.setMainParams("pageToJump","1");var urlParams={viewname:_this.listInstance.getCurrentCvId(),search_key:_this.listInstance.getAlphabetSearchField(),search_value:"",search_params:"",advancedConditions:"",tile_size:selectedTileSize};_this.contentContainer.find("#recordsCount").val(""),_this.contentContainer.find("#totalPageCount").text(""),topMenuContainer.find(".pagination").data("totalCount",0),_this.listInstance.getListViewRecords(urlParams).done(function(){_this.listInstance.updatePagination(1),_this.setHeightOfTiles(_this.contentContainer);}),e.stopPropagation();});},/**
		 * Adjust height tile to the highest
		 */setHeightOfTiles:function setHeightOfTiles(){var maxHeight=-1,tiles=this.contentContainer.find(".js-tile-card");tiles.each(function(){maxHeight=maxHeight>$(this).height()?maxHeight:$(this).height();}),tiles.each(function(){$(this).height(maxHeight);});},/**
		 * Function to register the click on the tile
		 * @param {jQuery} tileContainer
		 */registerTileClickEvent:function registerTileClickEvent(tileContainer){tileContainer.on("click",".js-card-body",function(e){if(!$(e.target).hasClass("js-show-image-preview")&&!$(e.target).closest("div").hasClass("actions")&&!($(e.target).is("button")||$(e.target).parent().is("button"))&&!$(e.target).closest("a").hasClass("noLinkBtn")&&!$(e.target).is("input[type=\"checkbox\"]")){var recordUrl=$(e.target).closest(".js-tile-container").data("recordurl");"undefined"!=typeof recordUrl&&(window.location.href=recordUrl);}});},/**
		 * Function which will give you all the list view params
		 * @param {string} urlParams
		 */getListViewRecords:function getListViewRecords(urlParams){var _this2=this;this.listInstance.getListViewRecords(urlParams).done(function(){_this2.setHeightOfTiles(_this2.contentContainer);});},registerImagePreview:function registerImagePreview(){var _this3=this;this.contentContainer.on("click",".js-show-image-preview",function(e){var moduleName=_this3.contentContainer.find("[name=\"module\"]").length?_this3.contentContainer.find("[name=\"module\"]").val():app.getModuleName(),recordId=$(e.target).closest(".js-tile-container").attr("data-record-id"),url="index.php?module=".concat(moduleName,"&view=ImagePreview&record=").concat(recordId);app.showModalWindow("",url,function(modalWindow){var imageSrc="";"IMG"===e.target.nodeName?imageSrc=$(e.target).attr("src"):(imageSrc=$(e.target).css("background-image"),imageSrc=imageSrc.replace("url(\"",""),imageSrc=imageSrc.replace("\")","")),modalWindow.find("img.js-image-preview").attr("src",imageSrc);});});},/**
		 * Register events
		 */registerEvents:function registerEvents(){this.listInstance=new Vtiger_List_Js,this.listInstance.registerEvents();var topMenuContainer=this.listInstance.getListViewTopMenuContainer();this.contentContainer=this.listInstance.getListViewContainer(),this.registerTileSizeChange(topMenuContainer),this.setHeightOfTiles(),this.registerTileClickEvent(this.contentContainer),this.registerImagePreview();}});
//# sourceMappingURL=Tiles.min.js.map
