<?php
/**
 * CurrencyList Query Field file.
 *
 * @package UIType
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Tomasz Kur <t.kur@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Conditions\QueryFields;

/**
 * CurrencyList Query Field Class.
 */
class CurrencyListField extends PicklistField
{
	/** {@inheritdoc} */
	public function getOrderBy($order = false): array
	{
		$this->queryGenerator->addJoin(['LEFT JOIN', 'vtiger_currency_info', $this->getColumnName() . ' = vtiger_currency_info.id']);
		if ($order && 'desc' === strtolower($order)) {
			return ['vtiger_currency_info.currency_name' => SORT_DESC];
		}
		return ['vtiger_currency_info.currency_name' => SORT_ASC];
	}
}
