<?php

namespace App\Conditions\QueryFields;

/**
 * Id Query Field Class.
 *
 * @package UIType
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
class IdField extends StringField
{
	/** {@inheritdoc} */
	public function operatorS()
	{
		return ['like', $this->getColumnName(), $this->getValue() . '%', false];
	}

	/** {@inheritdoc} */
	public function getTableName(): string
	{
		if (!$this->tableName) {
			if ($this->related) {
				$this->tableName = $this->queryGenerator->resolveRelTableName($this->getRelated()) . $this->getRelTablePostfix();
			} else {
				$this->tableName = $this->queryGenerator->getModuleModel()->getBaseTableName();
			}
		}

		return $this->tableName;
	}

	/** {@inheritdoc} */
	public function getColumnName(): string
	{
		if (!$this->fullColumnName) {
			if ($this->related) {
				$sourceTableIndex = $this->queryGenerator->resolveRelTableIndex($this->getRelated());
				$this->fullColumnName = \sprintf('%s.%s', $this->getTableName(), $sourceTableIndex);
			} else {
				$this->fullColumnName = $this->queryGenerator->getColumnName('id');
			}
		}

		return $this->fullColumnName;
	}

	/** {@inheritdoc} */
	public function addJoin()
	{
		if ($this->related) {
			$queryGenerator = $this->queryGenerator;
			$tableName = $queryGenerator->resolveRelTableName($this->related);
			$querySource = $queryGenerator->getQueryField($this->getRelated('sourceField'));
			$queryGenerator->addJoin(['LEFT JOIN',
				\sprintf('%s %s', $tableName, $this->getTableName()),
				\sprintf(
					'%s = %s',
					$querySource->getColumnName(),
					$this->getColumnName()
				)]);
		}
	}

	/** {@inheritdoc} */
	public function operatorEw()
	{
		return ['like', $this->getColumnName(), '%' . $this->getValue(), false];
	}

	/** {@inheritdoc} */
	public function operatorA(): array
	{
		return ['>', $this->getColumnName(), $this->getValue()];
	}

	/**
	 * Equal IDs.
	 *
	 * @return array
	 */
	public function operatorEid(): array
	{
		$condition = ['or'];
		foreach (explode('##', $this->value) as $value) {
			$condition[] = [$this->getColumnName() => $value];
		}

		return $condition;
	}
}
