<?php
/**
 * Xlsx file validator
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\DocumentBuilder\Validator;

use App\DocumentBuilder\ValidatorInterface;

/** XlsxValidator class */
final class XlsxValidator implements ValidatorInterface
{
	/**
	 * Hard limit for number of rows in Excel file
	 */
	public const MAX_ROWS_LIMIT = 1000000;

	/**
	 * Hard limit for number of columns in Excel file
	 */
	public const MAX_COLUMNS_LIMIT = 16000;


	/** Validate file */
	public function validate(array $data): void
	{
		if (count($data) >= self::MAX_ROWS_LIMIT) {
			throw new \Exception('Maximum rows number reached');
		}

		foreach ($data as $rowData) {
			if (count($rowData) >= self::MAX_COLUMNS_LIMIT) {
				throw new \Exception('Maximum columns number reached');
			}
		}
	}
}
