<?php
/**
 * Conversion interface file.
 *
 * @package \App\Inventory
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mateusz Slominski <m.slominski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Inventory\Currency;

/**
 * Conversion interface.
 */
interface Conversion
{
	/**
	 * Returns type of the conversion.
	 *
	 * @return string
	 */
	public static function getType(): string;

	/**
	 * Create object from array.
	 *
	 * @param array $array
	 *
	 * @return static
	 */
	public static function fromArray(array $array): static;

	/**
	 * Returns date value as dateTime object.
	 *
	 * @return \DateTimeInterface
	 */
	public function getDateObject(): \DateTimeInterface;

	/**
	 * Returns object data as array.
	 *
	 * @return array
	 */
	public function toArray(): array;

	/**
	 * Returns conversion date formatted to user format.
	 *
	 * @return string
	 */
	public function getDateUserFormat(): string;

	/**
	 * Returns rate value formatted to user format.
	 *
	 * @return string
	 */
	public function getValueUserFormat(): string;
}
