<?php
/**
 * Mail account repository.
 *
 * @package \App\Mail
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Mail\Account;

/**
 * Repository class.
 */
final class Repository
{
	/**
	 * Get a specific repository class.
	 *
	 * @param string $class
	 *
	 * @return object|null
	 */
	public static function get(string $class): ?object
	{
		return class_exists($class) ? new $class() : null;
	}
}
