<?php
/**
 * File layer file.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Map;

use App\Exceptions\AppException;
use App\Exceptions\NoPermitted;

/**
 * Map layer class.
 */
class Layer extends BaseConnector
{
	/**
	 * @inheritdoc
	 */
	protected static string $configTableName = 'a_#__map_tile_layer_driver_config';

	/**
	 * Get url for tile server.
	 *
	 * @return ?string
	 * @throws NoPermitted|AppException
	 */
	public static function getTileServer(): ?string
	{
		return self::getActiveInstance()?->getUrlTemplate();
	}

	/**
	 * @inheritdoc
	 * @throws AppException
	 */
	public static function getDriverClass(string $driver): string
	{
		$className = "\\App\\Map\\TileLayer\\{$driver}";
		if (!class_exists($className)) {
			throw new AppException('ERR_CLASS_NOT_FOUND|'.$driver);
		}

		return $className;
	}
}
