<?php

/**
 * Service for creating Report Template.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 * @author Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Builder;

use App\Report\Model\Query;
use App\Report\Model\Template;

/** TemplateBuilder class */
final class TemplateBuilder
{
	public function __construct(
		private readonly QueryBuilder $queryBuilder,
	) {}

	/** Build template */
	public function build(Query $query, array $exceptions, array $filters = [], string $name = '', int $templateId = 0): Template
	{
		$this->queryBuilder->addExpressions($query, $exceptions);
		if ($filters) {
			$this->queryBuilder->addFilters($query, $filters);
		}

		return new Template(
			$templateId,
			$name,
			$query
		);
	}

	public function buildQuery(string $moduleName, int $queryId = 0): Query
	{
		return $this->queryBuilder->query($moduleName, $queryId);
	}
}
