<?php
/**
 * Factory interface for creating Field object instance
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Factory;

use App\Report\Model\Field;
use App\Report\Model\Query;

/** FieldFactory interface */
interface FieldFactory
{
	/** Create field instance */
	public function create(Query $query, string $fieldCoordinates): ?Field;
}
