<?php
/**
 * Calendar export model file.
 *
 * @package   Model
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Arkadiusz Adach <a.adach@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Config;
use App\Export\Records;
use App\Integrations\Dav\Calendar;

/**
 * Calendar export model class.
 */
class Calendar_ExportToIcal_Model extends Records
{
	/** {@inheritdoc} */
	protected $fileExtension = 'ics';

	/** {@inheritdoc} */
	public function getExportContentType(): string
	{
		return 'text/calendar';
	}

	/** {@inheritdoc} */
	public function exportData()
	{
		$tmpFile = $this->exportDataToTmpFile();
		$this->output($tmpFile);
	}

	/** {@inheritdoc} */
	public function sanitizeValues(array $recordValues): array
	{
		return $recordValues;
	}

	/** {@inheritDoc} */
	public function exportDataToTmpFile(): string
	{
		$tmpFileName = tempnam(ROOT_DIRECTORY . DIRECTORY_SEPARATOR . Config::main('tmp_dir'), $this->fileExtension);
		$this->registerTmpFile($tmpFileName);

		$calendar = Calendar::createEmptyInstance();
		foreach ($this->getExportQuery()->all() as $row) {
			$calendar->loadFromArray($row);
			$calendar->createComponent();
		}
		file_put_contents($tmpFileName, $calendar->getVCalendar()->serialize());

		return $tmpFileName;
	}

	/** {@inheritdoc} */
	protected function output(string $tmpPath)
	{
		$file = fopen($tmpPath, 'r');
		fpassthru($file);
		fclose($file);
	}
}
