<?php
/**
 * UIType Password field file.
 *
 * @package   Settings.UIType
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */

/**
 * UIType Password Field Class.
 */
class Settings_ApiAddress_Password_UIType extends Vtiger_Password_UIType
{
	/** {@inheritdoc} */
	public function getDBValue($value, $recordModel = false)
	{
		return $value;
	}

	/** {@inheritdoc} */
	public function getActionsUrl(): array
	{
		$fieldModel = $this->getFieldModel();
		return [
			'display' => "index.php?module=ApiAddress&parent=Settings&action=Password&mode=getPwd&provider={$fieldModel->get('provider')}",
		];
	}
}
