<?php
/**
 * UserAuth provider edit view class.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

/**
 * UserAuth provider edit view class.
 */
class Settings_UserAuth_Edit_View extends \App\Controller\ModalSettings
{
	/** {@inheritdoc} */
	public $modalIcon = 'yfi yfi-full-editing-view';
	/** {@inheritdoc} */
	public $modalSize = 'modal-md';

	/** {@inheritdoc} */
	public function getPageTitle(App\Request $request)
	{
		$moduleName = $request->getModule(false);
		$provider = \app\UserAuth::getProviderByName($request->getByType('provider', \App\Purifier::ALNUM));
		return \App\Language::translate($request->isEmpty('record') ? 'LBL_USERAUTH_CREATE' : 'LBL_USERAUTH_EDIT', $moduleName) . ': ' . $provider->getLabel();
	}

	/**
	 * Check Permission.
	 *
	 * @param \App\Request $request
	 *
	 * @throws \App\Exceptions\NoPermittedForAdmin
	 */
	public function checkPermission(App\Request $request)
	{
		parent::checkPermission($request);
		if ($request->isEmpty('provider', true) || !\App\UserAuth::getProviderByName($request->getByType('provider', \App\Purifier::ALNUM)) || (!$request->isEmpty('record') && !Settings_UserAuth_Record_Model::getInstanceById($request->getInteger('record'))->has('id'))) {
			throw new \App\Exceptions\NoPermittedForAdmin('LBL_PERMISSION_DENIED');
		}
	}

	/**
	 * Process.
	 *
	 * @param \App\Request $request
	 */
	public function process(App\Request $request)
	{
		$qualifiedModuleName = $request->getModule(false);
		$provider = $request->getByType('provider', \App\Purifier::ALNUM);
		if (!$request->isEmpty('record')) {
			$recordModel = Settings_UserAuth_Record_Model::getInstanceById($request->getInteger('record'));
		} else {
			$recordModel = Settings_UserAuth_Record_Model::getCleanInstance($provider);
		}
		$viewer = $this->getViewer($request);
		$viewer->assign('RECORD_MODEL', $recordModel);
		$viewer->assign('MODULE_MODEL', $recordModel->getModule());
		$viewer->assign('PROVIDER', \App\UserAuth::getProviderByName($provider));
		$viewer->view($this->getTemplateName(), $qualifiedModuleName);
	}

	/**
	 * Template name.
	 *
	 * @return string
	 */
	public function getTemplateName(): string
	{
		return 'Edit.tpl';
	}

	/** {@inheritdoc} */
	public function getModalScripts(App\Request $request)
	{
		$moduleName = $request->getModule();
		return $this->checkAndConvertJsScripts([
			'modules.Settings.Vtiger.resources.Edit',
			"modules.Settings.{$moduleName}.resources.Edit"
		]);
	}
}
