<?php

/**
 * Mailbox action file.
 *
 * @package Action
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Anonymization;
use App\Controller\Action;
use App\Exceptions\NoPermittedToRecord;
use App\Request;
use App\User;

class Users_Mailbox_Action extends Action
{
	/** {@inheritdoc} */
	public function __construct()
	{
		Settings_Vtiger_Tracker_Model::setRecordId(Request::_get('record'));
		Settings_Vtiger_Tracker_Model::addBasic('save');
		parent::__construct();
	}

	/** {@inheritdoc} */
	public function checkPermission(Request $request)
	{
		$recordId = $request->getInteger('record');
		$baseId = User::getCurrentUserRealId();
		$currentUserId = User::getCurrentUserId();
		if ($currentUserId !== $recordId || ($baseId !== $currentUserId && !User::getUserModel($baseId)->isAdmin())) {
			throw new NoPermittedToRecord('ERR_NO_PERMISSIONS_FOR_THE_RECORD', 406);
		}
	}

	/** {@inheritdoc} */
	public function process(Request $request)
	{
		$mailboxModel = $this->getModelFromRequest($request);
		$recordId = $mailboxModel->getId();
		$mailboxModel->save();

		if ($changes = $mailboxModel->getEntity()->getChanges()) {
			$entity = $mailboxModel->getEntity();
			$data = $changes;
			array_walk($data, static function (&$value, $key) use ($entity) {
				$value = $entity->get($key);
			});
			$anonymization = (new Anonymization())->setModuleName($request->getModule());
			$changes = $anonymization->setData($changes)->anonymize()->getData();
			$data = $anonymization->setValue('*****')->setData($data)->anonymize()->getData();

			Settings_Vtiger_Tracker_Model::addDetail($changes, $recordId ? array_intersect_key($data, $changes) : $data);
		}

		$response = new Vtiger_Response();
		$response->setEmitType(Vtiger_Response::$EMIT_JSON);
		$response->setResult(['success' => true, 'url' => $mailboxModel->getRedirectUrl()]);
		$response->emit();
	}

	public function getModelFromRequest(Request $request): Users_Mailbox_Model
	{
		$recordId = $request->getInteger('record');
		$mailboxModel = new Users_Mailbox_Model($recordId);
		$mailboxModel->getFieldsForEdit();

		foreach ($mailboxModel->getFieldsForEdit() as $fieldName => $fieldModel) {
			if ($request->has($fieldName)) {
				$value = $request->isEmpty($fieldName) ? '' : $request->getByType($fieldName, $fieldModel->get('purifyType'));
				$fieldUiTypeModel = $fieldModel->getUITypeModel();
				$fieldUiTypeModel->validate($value, true);

				$value = $fieldUiTypeModel->getDBValue($value);
				$mailboxModel->set($fieldName, $value);
			}
		}

		return $mailboxModel;
	}
}
