<?php

/**
 * Users detail view class.
 *
 * @package   View
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Tomasz Poradzewski <t.poradzewski@yetiforce.com>
 */

use App\Json;
use App\Purifier;
use App\Request;
use App\User;

/**
 * Class Users_Detail_View.
 */
class Users_Detail_View extends Vtiger_Detail_View
{
	/** {@inheritdoc} */
	public function isAjaxEnabled($recordModel)
	{
		return false;
	}

	/** {@inheritdoc} */
	public function process(Request $request)
	{
		$baseId = User::getCurrentUserRealId();
		$currentUserId = User::getCurrentUserId();
		$recordModel = !empty($this->record) ? $this->record->getRecord() : Vtiger_Record_Model::getInstanceById($request->getInteger('record'), $request->getModule());
		$recordId = $recordModel->getId();
		$mailboxModel = ($request->isEmpty('parent', true)
			&& $currentUserId === $recordId && ($baseId === $currentUserId || User::getUserModel($baseId)->isAdmin()))
				? new Users_Mailbox_Model($recordModel->getId()) : null;
		$dayStartPicklistValues = $recordModel->getDayStartsPicklistValues();
		$viewer = $this->getViewer($request);
		$viewer->assign('DAY_STARTS', Json::encode($dayStartPicklistValues));
		$viewer->assign('RECORD_ID', $request->getInteger('record'));
		$viewer->assign('MAILBOX_MODEL', $mailboxModel);
		$viewer->assign('DETAIL_TAB', $request->getByType('tab', Purifier::STANDARD, 'preferences'));
		parent::process($request);
	}
}
