'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";Vtiger_Detail_Js("Leads_Detail_Js",{//cache will store the convert lead data(Model)
cache:{},//Holds detail view instance
detailCurrentInstance:!1,/*
		 * function to trigger Convert Lead action
		 * @param: Convert Lead url, currentElement.
		 */convertLead:function convertLead(convertLeadUrl,buttonElement){var instance=Leads_Detail_Js.detailCurrentInstance;//Initially clear the elements to overwtite earliear cache
instance.convertLeadContainer=!1,instance.convertLeadForm=!1,instance.convertLeadModules=!1,jQuery.isEmptyObject(Leads_Detail_Js.cache)?AppConnector.request(convertLeadUrl).done(function(data){data&&(Leads_Detail_Js.cache=data,instance.displayConvertLeadModel(data,buttonElement));},function(){}):instance.displayConvertLeadModel(Leads_Detail_Js.cache,buttonElement);}},{//Contains the convert lead form
convertLeadForm:!1,//contains the convert lead container
convertLeadContainer:!1,//contains all the checkbox elements of modules
convertLeadModules:!1,//constructor
init:function init(){this._super(),Leads_Detail_Js.detailCurrentInstance=this;},/*
		 * function to disable the Convert Lead button
		 */disableConvertLeadButton:function disableConvertLeadButton(button){jQuery(button).attr("disabled","disabled");},/*
		 * function to enable the Convert Lead button
		 */enableConvertLeadButton:function enableConvertLeadButton(button){jQuery(button).removeAttr("disabled");},/*
		 * function to enable all the input and textarea elements
		 */removeDisableAttr:function removeDisableAttr(moduleBlock){moduleBlock.find("input,textarea,select").removeAttr("disabled");},/*
		 * function to disable all the input and textarea elements
		 */addDisableAttr:function addDisableAttr(moduleBlock){moduleBlock.find("input,textarea,select").attr("disabled","disabled");},/*
		 * function to display the convert lead model
		 * @param: data used to show the model, currentElement.
		 */displayConvertLeadModel:function displayConvertLeadModel(data,buttonElement){var instance=this,errorElement=jQuery(data).find("#convertLeadError");if("0"!=errorElement.length){var errorMsg=errorElement.val(),errorTitle=jQuery(data).find("#convertLeadErrorTitle").val(),params={title:errorTitle,text:errorMsg,addclass:"convertLeadNotify",width:"35%",type:"error",pnotify_after_open:function pnotify_after_open(){instance.disableConvertLeadButton(buttonElement);},pnotify_after_close:function pnotify_after_close(){instance.enableConvertLeadButton(buttonElement);}};app.showNotify(params);}else {var callBackFunction=function(data){var editViewObj=Vtiger_Edit_Js.getInstance();jQuery(data).find(".fieldInfo").collapse({parent:"#leadAccordion",toggle:!1}),editViewObj.registerBasicEvents(data);var checkBoxElements=instance.getConvertLeadModules();jQuery.each(checkBoxElements,function(index,element){instance.checkingModuleSelection(element);}),instance.registerForReferenceField(),instance.registerConvertLeadEvents(),instance.getConvertLeadForm().validationEngine(app.validationEngineOptions),instance.registerConvertLeadSubmit();};app.showModalWindow(data,function(data){"function"==typeof callBackFunction&&callBackFunction(data);},{"text-align":"left"});}},/*
		 * function to check which module is selected
		 * to disable or enable all the elements with in the block
		 */checkingModuleSelection:function checkingModuleSelection(element){var instance=this,module=jQuery(element).val(),moduleBlock=jQuery(element).closest(".convertLeadModules").find("#"+module+"_FieldInfo");jQuery(element).is(":checked")?instance.removeDisableAttr(moduleBlock):instance.addDisableAttr(moduleBlock);},registerForReferenceField:function registerForReferenceField(){var container=this.getConvertLeadContainer(),referenceField=jQuery(".reference",container);0<referenceField.length&&jQuery("#AccountsModule").attr("readonly","readonly");},/*
		 * function to register Convert Lead Events
		 */registerConvertLeadEvents:function registerConvertLeadEvents(){var container=this.getConvertLeadContainer(),instance=this;//Trigger Event to change the icon while shown and hidden the accordion body
//Trigger Event on click of Transfer related records modules
//Trigger Event on click of the Modules selection to convert the lead
container.on("hide.bs.collapse",".js-collapse ",function(e){$(e.currentTarget).closest(".convertLeadModules").find(".fas").removeClass("fa-chevron-up").addClass("fa-chevron-down");}).on("show.bs.collapse",".js-collapse ",function(e){$(e.currentTarget).closest(".convertLeadModules").find(".fas").removeClass("fa-chevron-down").addClass("fa-chevron-up");}),container.on("click",".transferModule",function(e){var currentTarget=jQuery(e.currentTarget),module=currentTarget.val(),moduleBlock=jQuery("#"+module+"_FieldInfo");currentTarget.is(":checked")&&(jQuery("#"+module+"Module").prop("checked",!0),moduleBlock.collapse("show"),instance.removeDisableAttr(moduleBlock));}),container.on("click",".convertLeadModuleSelection",function(e){var currentTarget=jQuery(e.currentTarget),currentModuleName=currentTarget.val(),moduleBlock=currentTarget.closest(".convertLeadModules").find("#"+currentModuleName+"_FieldInfo"),currentTransferModuleElement=jQuery("#transfer"+currentModuleName),otherTransferModuleElement=jQuery("input[name=\"transferModule\"]").not(currentTransferModuleElement),otherTransferModuleValue=jQuery(otherTransferModuleElement).val(),otherModuleElement=jQuery("#"+otherTransferModuleValue+"Module");currentTarget.is(":checked")?(moduleBlock.collapse("show"),instance.removeDisableAttr(moduleBlock),!otherModuleElement.is(":checked")&&jQuery(currentTransferModuleElement).prop("checked",!0)):(moduleBlock.collapse("hide"),instance.addDisableAttr(moduleBlock),jQuery(currentTransferModuleElement).prop("checked",!1),otherModuleElement.is(":checked")&&jQuery(otherTransferModuleElement).prop("checked",!0)),e.stopImmediatePropagation();});},/*
		 * function to register Convert Lead Submit Event
		 */registerConvertLeadSubmit:function registerConvertLeadSubmit(){var thisInstance=this,formElement=this.getConvertLeadForm();//Convert Lead Form Submission
formElement.on("jqv.form.validating",function(e){var jQv=jQuery(e.currentTarget).data("jqv");//Remove the earlier validated fields from history so that it wont count disabled fields
jQv.InvalidFields=[];}),formElement.on("submit",function(e){var convertLeadModuleElements=thisInstance.getConvertLeadModules(),moduleArray=[],accountModel=formElement.find("#AccountsModule"),invalidFields=formElement.data("jqv").InvalidFields;//If the validation fails in the hidden Block, we should show that Block with error.
if(0<invalidFields.length){var fieldElement=invalidFields[0],moduleBlock=jQuery(fieldElement).closest(".js-collapse");return moduleBlock.collapse("show"),void e.preventDefault()}jQuery.each(convertLeadModuleElements,function(index,element){jQuery(element).is(":checked")&&moduleArray.push(jQuery(element).val());}),formElement.find("input[name=\"modules\"]").val(JSON.stringify(moduleArray));var organizationElement=accountModel.length;"0"!=organizationElement&&-1==jQuery.inArray("Accounts",moduleArray)&&(app.showAlert(app.vtranslate("JS_SELECT_ORGANIZATION")),e.preventDefault());});},/*
		 * function to get all the checkboxes which are representing the modules selection
		 */getConvertLeadModules:function getConvertLeadModules(){var container=this.getConvertLeadContainer();return !1==this.convertLeadModules&&(this.convertLeadModules=jQuery(".convertLeadModuleSelection",container)),this.convertLeadModules},/*
		 * function to get Convert Lead Form
		 */getConvertLeadForm:function getConvertLeadForm(){return !1==this.convertLeadForm&&(this.convertLeadForm=jQuery("#convertLeadForm")),this.convertLeadForm},/*
		 * function to get Convert Lead Container
		 */getConvertLeadContainer:function getConvertLeadContainer(){return !1==this.convertLeadContainer&&(this.convertLeadContainer=jQuery("#leadAccordion")),this.convertLeadContainer},saveFieldValues:function saveFieldValues(fieldDetailList){var aDeferred=jQuery.Deferred(),recordId=this.getRecordId(),data={};if("undefined"!=typeof fieldDetailList&&(data=fieldDetailList),data.record=recordId,data.module=app.getModuleName(),data.action="SaveAjax",AppConnector.request(data).done(function(reponseData){aDeferred.resolve(reponseData);}),fieldDetailList&&"leadstatus"==fieldDetailList.field){var btn=jQuery(".btn-convertLead"),conversionAvailableStatus=jQuery("#conversion_available_status").val();if(conversionAvailableStatus){var status=JSON.parse(conversionAvailableStatus);0===status.length||-1!=jQuery.inArray(fieldDetailList.value,status)?btn.removeClass("d-none"):btn.addClass("d-none");}else btn.addClass("d-none");}return aDeferred.promise()},updateConvertLeadvalue:function updateConvertLeadvalue(){var thisInstance=Vtiger_Detail_Js.getInstance(),detailContentsHolder=thisInstance.getContentHolder();detailContentsHolder.on(thisInstance.fieldUpdatedEvent,"input,select",function(e,params){var elem=jQuery(e.currentTarget),fieldName=elem.attr("name"),ajaxnewValue=params["new"];if(!jQuery.isEmptyObject(Leads_Detail_Js.cache)){var sampleCache=jQuery(Leads_Detail_Js.cache),contextElem=sampleCache.find("[name=\""+fieldName+"\"]");if(elem.is("select")){var oldvalue=contextElem.val();contextElem.find("option[value=\""+oldvalue+"\"]").removeAttr("selected"),contextElem.find("option[value=\""+ajaxnewValue+"\"]").attr("selected","selected"),contextElem.trigger("change");}else contextElem.attr("value",ajaxnewValue);Leads_Detail_Js.cache=sampleCache;}});},registerEvents:function registerEvents(){this._super(),this.updateConvertLeadvalue();}});
//# sourceMappingURL=Detail.min.js.map
