'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";jQuery.Class("Settings_Sharing_Access_Js",{},{contentTable:!1,contentsContainer:!1,init:function init(){this.setContentTable(".sharingAccessDetails").setContentContainer("#sharingAccessContainer");},setContentTable:function setContentTable(element){return element instanceof jQuery?(this.contentTable=element,this):(this.contentTable=jQuery(element),this)},setContentContainer:function setContentContainer(element){return element instanceof jQuery?(this.contentsContainer=element,this):(this.contentsContainer=jQuery(element),this)},getContentTable:function getContentTable(){return this.contentTable},getContentContainer:function getContentContainer(){return this.contentsContainer},getCustomRuleContainerClassName:function getCustomRuleContainerClassName(parentModuleName){return "js-"+parentModuleName+"-custom-rule-list"},showCustomRulesNextToElement:function showCustomRulesNextToElement(parentElement,rulesListElement){var moduleName=parentElement.data("moduleName"),trElementForRuleList=jQuery("<tr class=\""+this.getCustomRuleContainerClassName(moduleName)+"\"><td class=\"js-custom-rule-container\" data-js=\"container\" colspan=\"6\"></td></tr>");jQuery("td",trElementForRuleList).append(rulesListElement),jQuery(".ruleListContainer",trElementForRuleList).css("display","none"),parentElement.after(trElementForRuleList).addClass("collapseRow"),jQuery(".ruleListContainer",trElementForRuleList).slideDown("slow");},/*
		 * function to get custom rules data based on the module
		 * @params: forModule.
		 */getCustomRules:function getCustomRules(forModule){var aDeferred=jQuery.Deferred(),params={};return params.for_module=forModule,params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.view="IndexAjax",params.mode="showRules",AppConnector.request(params).done(function(data){aDeferred.resolve(data);}).fail(function(error){aDeferred.reject(error);}),aDeferred.promise()},save:function save(data){var aDeferred=jQuery.Deferred(),progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});return "undefined"==typeof data&&(data={}),AppConnector.request(data).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.resolve(data);}).fail(function(error){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.reject(error);}),aDeferred.promise()},/*
		 * function to Save the Custom Rule
		 */saveCustomRule:function saveCustomRule(form){var thisInstance=this,data=form.serializeFormData();"undefined"==typeof data&&(data={});var progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});data.module=app.getModuleName(),data.parent=app.getParentModuleName(),data.action="IndexAjax",data.mode="saveRule",AppConnector.request(data).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"});var response=data.result;if(response&&response.success){app.hideModalWindow();var moduleName=$("[name=\"for_module\"]",form).val();thisInstance.loadCustomRulesList(moduleName),app.showNotify({type:"success",text:response.message});}else app.showNotify({type:"error",text:"JS_ERROR"});});},/*
		 * function to load the CustomRules List for the module after save the custom rule
		 */loadCustomRulesList:function loadCustomRulesList(moduleName){var thisInstance=this,contentTable=this.getContentTable();thisInstance.getCustomRules(moduleName).done(function(data){var customRuleListContainer=jQuery("."+thisInstance.getCustomRuleContainerClassName(moduleName),contentTable);customRuleListContainer.find("td.js-custom-rule-container").html(data);});},editCustomRule:function editCustomRule(url){var thisInstance=this,progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});app.showModalWindow(null,url,function(modalContainer){progressIndicatorElement.progressIndicator({mode:"hide"});var form=modalContainer.find(".js-edit-rule-form");form.on("submit",function(e){e.preventDefault();var formElement=$(e.currentTarget);thisInstance.saveCustomRule(formElement,e);});});},/*
		 * function to delete Custom Rule from the list
		 * @params: deleteElement.
		 */deleteCustomRule:function deleteCustomRule(deleteElement){var deleteUrl=deleteElement.data("url"),currentRow=deleteElement.closest(".js-custom-rule-entries");app.showConfirmModal({title:app.vtranslate("LBL_DELETE_CONFIRMATION"),confirmedCallback:function confirmedCallback(){AppConnector.request(deleteUrl).done(function(data){var response=data.result;if(response&&response.success){currentRow.fadeOut("slow");var customRuleTable=currentRow.closest(".js-custom-rule-table"),nextRows=currentRow.nextAll("js-custom-rule-entries");//after delete the custom rule, update the sequence number of existing rules
0<nextRows.length&&jQuery.each(nextRows,function(i,element){var currentSequenceElement=jQuery(element).find(".js-sequence-number"),updatedNumber=parseInt(currentSequenceElement.text())-1;currentSequenceElement.text(updatedNumber);}),currentRow.remove();var customRuleEntries=customRuleTable.find(".js-custom-rule-entries");//if there are no custom rule entries, we have to hide headers also and show the empty message div
1>customRuleEntries.length&&(customRuleTable.find(".js-custom-rule-headers").fadeOut("slow").remove(),customRuleTable.parent().find(".js-record-details").removeClass("d-none"),customRuleTable.addClass("d-none"));}else app.showNotify({type:"error",text:"JS_ERROR"});});}});},/*
		 * function to register click event for radio buttons
		 */registerSharingAccessEdit:function registerSharingAccessEdit(){var contentContainer=this.getContentContainer();contentContainer.one("click","input:radio",function(){contentContainer.find("button:submit").removeClass("d-none");});},/*
		 * Function to register change event for dependent modules privileges
		 */registerDependentModulesPrivilegesChange:function registerDependentModulesPrivilegesChange(){var container=this.getContentContainer(),contentTable=this.getContentTable(),modulesList=JSON.parse(container.find(".dependentModules").val());$.each(modulesList,function(moduleName,dependentList){var dependentPrivilege=contentTable.find("[data-module-name=\""+moduleName+"\"]").find("[data-action-state=\"Private\"]");dependentPrivilege.on("change",function(e){var currentTarget=$(e.currentTarget);currentTarget.is(":checked")&&(app.showNotify({text:app.vtranslate("JS_DEPENDENT_PRIVILEGES_SHOULD_CHANGE"),hide:!1}),$.each(dependentList,function(index,module){contentTable.find("[data-module-name=\""+module+"\"]").find("[data-action-state=\"Private\"]").attr("checked","checked");}));});});},registerEvents:function registerEvents(){var thisInstance=this,contentTable=thisInstance.getContentTable(),contentContainer=thisInstance.getContentContainer();thisInstance.registerSharingAccessEdit(),thisInstance.registerDependentModulesPrivilegesChange(),contentTable.on("click","td.triggerCustomSharingAccess",function(e){var element=$(e.currentTarget),trElement=element.closest("tr"),moduleName=trElement.data("moduleName"),customRuleListContainer=$("."+thisInstance.getCustomRuleContainerClassName(moduleName),contentTable);if(0<customRuleListContainer.length)return void(app.isHidden(customRuleListContainer)?(customRuleListContainer.show(),$(".ruleListContainer",customRuleListContainer).slideDown("slow"),trElement.addClass("collapseRow"),element.find("button.arrowDown").addClass("d-none"),element.find("button.arrowUp").removeClass("d-none").show()):($(".ruleListContainer",customRuleListContainer).slideUp("slow",function(){customRuleListContainer.css("display","none");}),element.find("button.arrowUp").addClass("d-none"),element.find("button.arrowDown").removeClass("d-none").show(),trElement.removeClass("collapseRow")));var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});thisInstance.getCustomRules(moduleName).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),thisInstance.showCustomRulesNextToElement(trElement,data),element.find("button.arrowDown").addClass("d-none"),element.find("button.arrowUp").removeClass("d-none").show();});}),contentTable.on("click",".js-add-custom-rule",function(e){var button=$(e.currentTarget);thisInstance.editCustomRule(button.data("url"));}),contentTable.on("click",".js-edit",function(e){var editElement=$(e.currentTarget),editUrl=editElement.data("url");thisInstance.editCustomRule(editUrl);}),contentTable.on("click",".js-delete",function(e){var deleteElement=$(e.currentTarget);thisInstance.deleteCustomRule(deleteElement);}),contentContainer.on("submit","#js-edit-sharing-access",function(e){e.preventDefault();var form=$(e.currentTarget),data=form.serializeFormData();thisInstance.save(data).done(function(){contentContainer.find("button:submit").addClass("d-none"),thisInstance.registerSharingAccessEdit(),app.showNotify({text:app.vtranslate("JS_NEW_SHARING_RULES_APPLIED_SUCCESSFULLY"),type:"success"});});});}}),jQuery(function(){var settingSharingAcessInstance=new Settings_Sharing_Access_Js;settingSharingAcessInstance.registerEvents();});
//# sourceMappingURL=SharingAccess.min.js.map
