'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";Vtiger_List_Js("Vtiger_ListPreview_Js",{},{frameProgress:!1,/**
		 * Sets correct page url.
		 * @param {string} url - current url.
		 */updatePreview:function updatePreview(url){var frame=$(".listPreviewframe");this.frameProgress=$.progressIndicator({position:"html",message:app.vtranslate("JS_FRAME_IN_PROGRESS"),blockInfo:{enabled:!0}});var defaultView="";app.getMainParams("defaultDetailViewName")&&(defaultView=defaultView+"&mode=showDetailViewByMode&requestMode="+app.getMainParams("defaultDetailViewName")),frame.attr("src",url.replace("view=Detail","view=DetailPreview")+defaultView);},/**
		 * Registers click events.
		 */registerRowClickEvent:function registerRowClickEvent(){var thisInstance=this,listViewContentDiv=this.getListViewContentContainer();listViewContentDiv.on("click",".listViewEntries",function(e){if(!$(e.target).hasClass("js-no-link")&&!$(e.target).closest("div").hasClass("actions")&&!($(e.target).is("button")||$(e.target).parent().is("button"))&&!$(e.target).closest("a").hasClass("noLinkBtn")&&!$(e.target).is("a")&&!$(e.target,$(e.currentTarget)).is("td:first-child")&&!$(e.target).is("input[type=\"checkbox\"]")&&!$.contains($(e.currentTarget).find("td:last-child").get(0),e.target)&&!$.contains($(e.currentTarget).find("td:first-child").get(0),e.target)){var elem=$(e.currentTarget),recordUrl=elem.data("recordurl");"undefined"==typeof recordUrl||($(".listViewEntriesTable .listViewEntries").removeClass("active"),$(this).addClass("active"),thisInstance.updatePreview(recordUrl));}});},/**
		 * Registers list events.
		 * @param {jQuery} container - current container for reference.
		 */registerListEvents:function registerListEvents(){var _this=this,mainBody=this.container.closest(".mainBody");app.showNewScrollbarTopBottomRight(this.list,{wheelPropagation:!1}),this.registerFixedThead(),this.registerScrollEvent(mainBody),this.registerResizeEvent(),this.list.on("click",".listViewEntries",function(){if(10>_this.split.getSizes()[1]){var defaultGutterPosition=_this.getDefaultSplitSizes();_this.split.setSizes(defaultGutterPosition),_this.preview.show(),_this.sideBlockRight.removeClass("d-block"),app.moduleCacheSet("userSplitSet",defaultGutterPosition);}});},registerScrollEvent:function registerScrollEvent(mainBody){var _this2=this,scrollContainer=App.Components.Scrollbar.page.element;scrollContainer.scrollTop(0);// reset scroll to set correct start position
var listOffsetTop=this.list.offset().top-this.headerH,initialH=this.sideBlocks.height(),mainViewPortHeightCss={height:mainBody.height()},mainViewPortWidthCss={width:mainBody.height()};this.gutter.addClass("js-fixed-scroll");var fixedElements=this.container.find(".js-fixed-scroll"),fixedThead=this.list.siblings(".floatThead-container");scrollContainer.on("scroll",function onScroll(){scrollContainer.scrollTop()>=listOffsetTop?(fixedThead.add(fixedElements).css({top:scrollContainer.scrollTop()-listOffsetTop}),fixedElements.css(mainViewPortHeightCss),_this2.rotatedText.css(mainViewPortHeightCss),_this2.rotatedText.css(mainViewPortWidthCss)):(fixedThead.add(fixedElements).css({top:"initial"}),fixedElements.css({height:initialH+scrollContainer.scrollTop()}),_this2.rotatedText.css({width:initialH+scrollContainer.scrollTop(),height:initialH+scrollContainer.scrollTop()}));});},registerResizeEvent:function registerResizeEvent(){var _this3=this;$(window).on("resize",function(){App.Components.Scrollbar.page.element.scrollTop()>=_this3.list.offset().top+$(".commonActionsContainer").height()&&_this3.container.find(".gutter").css("left",_this3.preview.offset().left-8);});},registerFixedThead:function registerFixedThead(){var list=this.list;this.listFloatThead=list.find(".js-fixed-thead"),this.listFloatThead.floatThead("destroy"),this.listFloatThead.floatThead({scrollContainer:function scrollContainer(){return list}}),this.listFloatThead.floatThead("reflow");},getListColumnWidth:function getListColumnWidth(){var width=300,column=this.container.find(".listViewEntriesDiv .listViewHeaders th:eq(1)");return column.length&&(width=column.offset().left+column.width()),width},setDomParams:function setDomParams(container){this.container=container,this.listColumnWidth=this.getListColumnWidth(),this.windowW=$(window).width(),this.windowMinWidth=100*(15/this.windowW),this.windowMaxWidth=100-this.minWidth,this.sideBlocks=container.find(".js-side-block"),this.sideBlockLeft=this.sideBlocks.first(),this.sideBlockRight=this.sideBlocks.last(),this.list=container.find(".js-list-preview"),this.preview=container.find(".js-detail-preview"),this.rotatedText=container.find(".u-rotate-90"),this.footerH=$(".js-footer").outerHeight(),this.headerH=$(".js-header").outerHeight();},getDefaultSplitSizes:function getDefaultSplitSizes(){var thWidth=100*(this.listColumnWidth/this.windowW);return [thWidth,100-thWidth]},/**
		 * Sets default windows size or from cache
		 * @param {jQuery} container - current container for reference.
		 * @return Array
		 */getSplitSizes:function getSplitSizes(){var cachedParams=app.moduleCacheGet("userSplitSet");return void 0===cachedParams?this.getDefaultSplitSizes():cachedParams},/**
		 * Registers split's events.
		 * @param {jQuery} container - current container for reference.
		 * @param {Split} split - a split object.
		 */registerSplitEvents:function registerSplitEvents(container,split){var _this4=this,rightSplitMaxWidth=100*(400/this.windowW),minWindowWidth=100*(25/this.windowW),listPreview=container.find(".js-detail-preview");this.gutter.on("dblclick",function(){var gutterMidPosition=app.moduleCacheGet("gutterMidPosition");isNaN(_this4.split.getSizes()[0])&&_this4.split.setSizes(gutterMidPosition),10>split.getSizes()[0]?(_this4.sideBlockLeft.removeClass("d-block"),_this4.list.removeClass("u-hide-underneath"),11<gutterMidPosition[0]?split.setSizes(gutterMidPosition):split.setSizes(_this4.getDefaultSplitSizes())):20>split.getSizes()[1]?(gutterMidPosition[1]>rightSplitMaxWidth+1?split.setSizes(gutterMidPosition):split.setSizes(_this4.getDefaultSplitSizes()),_this4.sideBlockRight.removeClass("d-block"),listPreview.show(),_this4.gutter.css("right","initial")):10<split.getSizes()[0]&&50>split.getSizes()[0]?(split.setSizes([minWindowWidth,100-minWindowWidth]),_this4.list.addClass("u-hide-underneath"),_this4.sideBlockLeft.addClass("d-block")):10<split.getSizes()[1]&&50>split.getSizes()[1]&&(split.collapse(1),_this4.sideBlockRight.addClass("d-block"),listPreview.hide(),_this4.list.width(_this4.list.width()-10)),_this4.listFloatThead.floatThead("reflow"),app.moduleCacheSet("userSplitSet",split.getSizes());}),this.sideBlockLeft.on("click",function(){var gutterMidPosition=app.moduleCacheGet("gutterMidPosition");11<gutterMidPosition[0]?split.setSizes(gutterMidPosition):split.setSizes(_this4.getDefaultSplitSizes()),_this4.sideBlockLeft.removeClass("d-block"),_this4.list.removeClass("u-hide-underneath"),_this4.listFloatThead.floatThead("reflow"),app.moduleCacheSet("userSplitSet",split.getSizes());}),this.sideBlockRight.on("click",function(){var gutterMidPosition=app.moduleCacheGet("gutterMidPosition");gutterMidPosition[1]>rightSplitMaxWidth+1?split.setSizes(gutterMidPosition):split.setSizes(_this4.getDefaultSplitSizes()),_this4.sideBlockRight.removeClass("d-block"),listPreview.show(),_this4.gutter.css("right","initial"),_this4.listFloatThead.floatThead("reflow"),app.moduleCacheSet("userSplitSet",split.getSizes());});},/**
		 * Registers split object and executes its events listeners.
		 * @param {jQuery} container - current container for reference.
		 * @returns {Split} A split object.
		 */registerSplit:function registerSplit(container){var _this5=this,rightSplitMaxWidth=100*(400/this.windowW),splitMinWidth=100*(25/this.windowW),splitMaxWidth=100-splitMinWidth,listPreview=container.find(".js-detail-preview"),splitSizes=this.getSplitSizes(),split=Split([this.list[0],listPreview[0]],{sizes:splitSizes,minSize:10,gutterSize:24,snapOffset:100,onDrag:function onDrag(){split.getSizes()[1]<rightSplitMaxWidth&&split.collapse(1),5>split.getSizes()[0]?(_this5.sideBlockLeft.addClass("d-block"),_this5.list.addClass("u-hide-underneath")):(_this5.sideBlockLeft.removeClass("d-block"),_this5.list.removeClass("u-hide-underneath")),10>split.getSizes()[1]?(_this5.sideBlockRight.addClass("d-block"),listPreview.hide(),_this5.list.width(_this5.list.width()-10)):(_this5.sideBlockRight.removeClass("d-block"),listPreview.show()),10<split.getSizes()[0]&&split.getSizes()[1]>rightSplitMaxWidth&&(_this5.listFloatThead.floatThead("reflow"),app.moduleCacheSet("gutterMidPosition",split.getSizes())),app.moduleCacheSet("userSplitSet",split.getSizes());},onDragStart:function onDragStart(){listPreview.css("z-index","1001"),_this5.gutter.css("z-index","1001");},onDragEnd:function onDragEnd(){listPreview.css("z-index","0"),_this5.gutter.css("z-index","0"),_this5.listFloatThead.floatThead("reflow");}});10>splitSizes[0]?(listPreview.width(listPreview.width()-150),this.sideBlockLeft.addClass("d-block"),split.setSizes([splitMinWidth,splitMaxWidth]),this.list.addClass("u-hide-underneath")):splitSizes[1]<rightSplitMaxWidth&&(this.sideBlockRight.addClass("d-block"),listPreview.hide(),split.setSizes([splitMaxWidth,splitMinWidth])),this.gutter=container.find(".gutter");var mainWindowHeightCss={height:$(window).height()-(this.gutter.offset().top+this.footerH)};return this.gutter.css(mainWindowHeightCss),this.list.css(mainWindowHeightCss),this.sideBlocks.css(mainWindowHeightCss),this.registerSplitEvents(container,split),this.rotatedText.first().find(".js-list-name").append($(".breadcrumbsContainer .js-text-content").text()),this.rotatedText.css({width:this.sideBlockLeft.height(),height:this.sideBlockLeft.height()}),split},/**
		 * Adds the split and deletes it on resize.
		 * @param {jQuery} container - current container for reference.
		 */toggleSplit:function toggleSplit(container){var _this6=this,thisInstance=this,listPreview=container.find(".js-detail-preview"),splitsArray=[],mainBody=container.closest(".mainBody");993<this.windowW&&!container.find(".gutter").length&&(this.split=thisInstance.registerSplit(container),splitsArray.push(this.split)),$(window).on("resize",function(){if(993>_this6.windowW)container.find(".gutter").length&&(splitsArray[splitsArray.length-1].destroy(),_this6.sideBlockRight.removeClass("d-block"),_this6.sideBlockLeft.removeClass("d-block"));else {1!==container.find(".gutter").length&&(_this6.split=thisInstance.registerSplit(container),_this6.gutter=container.find(".gutter"),_this6.gutter.addClass("js-fixed-scroll"),mainBody.scrollTop()>=_this6.list.offset().top&&(gutter.addClass("gutterOnScroll"),gutter.css("left",listPreview.offset().left-8),gutter.on("mousedown",function(){$(this).on("mousemove",function(){$(this).css("left",listPreview.offset().left-8);});})),splitsArray.push(_this6.split));var currentSplit=splitsArray[splitsArray.length-1];if("undefined"==typeof currentSplit)return;currentSplit.getSizes()[0]<_this6.windowMinWidth+5?currentSplit.setSizes([_this6.windowMinWidth,_this6.windowMaxWidth]):currentSplit.getSizes()[1]<_this6.windowMinWidth+5&&currentSplit.setSizes([_this6.windowMaxWidth,_this6.windowMinWidth]);}});},/**
		 * @inheritDoc
		 */registerDesktopEvents:function registerDesktopEvents(){},/**
		 * Sets initial iframe's height and fills the preview with first record's content.
		 */registerPreviewEvent:function registerPreviewEvent(){var _this7=this,iframe=$(".listPreviewframe"),container=this.getListViewContentContainer();this.setDomParams(container),this.toggleSplit(container),993<this.windowW&&this.registerListEvents(container),iframe.on("load",function(){_this7.frameProgress.progressIndicator({mode:"hide"}),iframe.height(iframe.contents().find(".bodyContents").height()-20);}),$(".listViewEntriesTable .listViewEntries").first().trigger("click");},/**
		 * Sets the correct parent iframe's size.
		 * @param {jQuery} currentHeight - ifrmae's body height to be set.
		 * @param {jQuery} frame - ifrmae's height to be changed.
		 */updateWindowHeight:function updateWindowHeight(height,frame){frame.height(height);},/**
		 * Executes event listener.
		 * @param {jQuery} container - current container for reference.
		 */postLoadListViewRecordsEvents:function postLoadListViewRecordsEvents(container){this._super(container),this.registerPreviewEvent();},/**
		 * Registers ListPreview's events.
		 */registerEvents:function registerEvents(){this._super(),this.registerPreviewEvent();}});
//# sourceMappingURL=ListPreview.min.js.map
