'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}jQuery.Class("Vtiger_Widget_Js",{widgetPostLoadEvent:"Vtiger.Dashboard.PostLoad",widgetPostRefereshEvent:"Vtiger.Dashboard.PostRefresh",instances:{},id:+new Date-0,DOM_ATTRIBUTE_KEY:"w_instance_",getInstance:function(container,widgetClassName,moduleName){"undefined"==typeof moduleName&&(moduleName=app.getModuleName());var id=container.attr(this.DOM_ATTRIBUTE_KEY);if(id||(id=this.DOM_ATTRIBUTE_KEY+this.id++,container.attr(this.DOM_ATTRIBUTE_KEY,id)),void 0!==this.instances[id])return this.instances[id];var instance,moduleClass=window[moduleName+"_"+widgetClassName+"_Widget_Js"],fallbackClass=window["Vtiger_"+widgetClassName+"_Widget_Js"],yetiClass=window["YetiForce_"+widgetClassName+"_Widget_Js"],basicClass=YetiForce_Widget_Js,className="";return "undefined"==typeof moduleClass?"undefined"==typeof fallbackClass?"undefined"==typeof yetiClass?(instance=new basicClass(container,!1,widgetClassName),className="YetiForce_Widget_Js"):(instance=new yetiClass(container,!1,widgetClassName),className="YetiForce_"+widgetClassName+"_Widget_Js"):(instance=new fallbackClass(container,!1,widgetClassName),className="Vtiger_"+widgetClassName+"_Widget_Js"):(instance=new moduleClass(container,!1,widgetClassName),className=moduleName+"_"+widgetClassName+"_Widget_Js"),instance.className=className,this.instances[id]=instance,instance}},{container:!1,paramCache:!1,init:function(container,reload){container=$(container),this.setContainer(container),this.registerWidgetPostLoadEvent(container),reload||this.registerWidgetPostRefreshEvent(container),this.registerCache(container);},areColorsFromDividingField:function areColorsFromDividingField(){return !!Number(this.getContainer().find("[name=\"colorsFromDividingField\"]").val())},/**
		 * Get widget data
		 * @returns {*}
		 */getWidgetData:function getWidgetData(){var reload=!!(0<arguments.length&&arguments[0]!==void 0)&&arguments[0];if("undefined"!=typeof this.widgetData&&!reload)return this.widgetData;var widgetDataEl=this.getContainer().find(".widgetData");return widgetDataEl.length?this.widgetData=JSON.parse(widgetDataEl.val()):""},getContainer:function(){return this.container},/**
		 * Get widget content
		 * @returns {jQuery}
		 */getContainerContent:function(){return this.getContainer().find(".dashboardWidgetContent")},setContainer:function(element){return this.container=element,this},isEmptyData:function(){return 0===this.getContainer().find(".widgetData").length||0<this.getContainer().find(".noDataMsg").length},getUserDateFormat:function(){return CONFIG.dateFormat},registerRecordsCount:function(){var thisInstance=this,recordsCountBtn=thisInstance.getContainer().find(".recordCount");recordsCountBtn.on("click",function(){var url=recordsCountBtn.data("url");AppConnector.request(url).done(function(response){recordsCountBtn.find(".count").html(response.result.totalCount),recordsCountBtn.find(".fas").addClass("d-none").attr("aria-hidden",!0),recordsCountBtn.find("a").removeClass("d-none").attr("aria-hidden",!1);});});},/**
		 * Load scrollbar
		 */loadScrollbar:function(){var container=this.getContainerContent();if(container.length){var widget=container.closest(".dashboardWidget"),content=widget.find(".dashboardWidgetContent"),footer=widget.find(".dashboardWidgetFooter"),adjustedHeight=widget.innerHeight()-widget.find(".dashboardWidgetHeader").outerHeight();footer.length&&(adjustedHeight-=footer.outerHeight()),content.length&&(content.css("height",adjustedHeight+"px"),content.css("max-height",adjustedHeight+"px"),"undefined"==typeof this.scrollbar?this.scrollbar=app.showNewScrollbar(content,{wheelPropagation:!0}):this.scrollbar.update());}},restrictContentDrag:function(){this.getContainer().on("mousedown.draggable",function(e){var element=jQuery(e.target),isHeaderElement=!!(0<element.closest(".dashboardWidgetHeader").length);isHeaderElement||//Stop the event propagation so that drag will not start for contents
e.stopPropagation();});},positionNoDataMsg:function(){var container=this.getContainer(),widgetContentsContainer=container.find(".dashboardWidgetContent"),noDataMsgHolder=widgetContentsContainer.find(".noDataMsg");noDataMsgHolder.position({my:"center center",at:"center center",of:widgetContentsContainer});},//Place holdet can be extended by child classes and can use this to handle the post load
postLoadWidget:function(){this.isEmptyData()&&this.positionNoDataMsg(),this.registerFilter(),this.registerFilterChangeEvent(),this.restrictContentDrag(),this.registerWidgetSwitch(),this.registerChangeSorting(),this.registerLoadMore(),this.registerHeaderButtons(),this.loadScrollbar(),this.registerResize();},registerResize:function(){var _this=this,container=this.getContainerContent();return !!container.length&&void new ResizeObserver(function(){_this.loadScrollbar();}).observe(container.get(0))},postRefreshWidget:function(){this.loadScrollbar(),this.isEmptyData()&&this.positionNoDataMsg(),this.registerLoadMore();},setSortingButton:function(currentElement){if(currentElement.length){var container=this.getContainer(),drefresh=container.find(".js-widget-refresh"),url=drefresh.data("url");url=url.replace("&sortorder=desc",""),url=url.replace("&sortorder=asc",""),url+="&sortorder=";var sort=currentElement.data("sort"),sortorder="desc",icon="fa-sort-amount-down",iconBase="fa-sort-amount-up";"desc"==sort&&(sortorder="asc",icon="fa-sort-amount-up",iconBase="fa-sort-amount-down"),currentElement.data("sort",sortorder),currentElement.attr("title",currentElement.data(sortorder)),currentElement.attr("alt",currentElement.data(sortorder)),url+=sortorder,currentElement.find(".fas").removeClass(iconBase).addClass(icon),drefresh.data("url",url);}},printImage:function printImage(imgEl,title,width,height){var print=window.open("","PRINT","height="+height+",width="+width);// necessary for IE >= 10
// necessary for IE >= 10
print.document.write("<html><head><title>"+title+"</title>"),print.document.write("</head><body >"),print.document.write($("<div>").append(imgEl).html()),print.document.write("</body></html>"),print.document.close(),print.focus(),setTimeout(function(){print.print(),print.close();},1e3);},registerHeaderButtons:function(){var container=this.getContainer();container.find(".js-widget-quick-create").on("click",function(){App.Components.QuickCreate.createRecord($(this).data("module-name"));});},registerChangeSorting:function(){var thisInstance=this,container=this.getContainer();thisInstance.setSortingButton(container.find(".changeRecordSort")),container.find(".changeRecordSort").on("click",function(e){var drefresh=container.find(".js-widget-refresh");thisInstance.setSortingButton(jQuery(e.currentTarget)),drefresh.click();});},registerWidgetSwitch:function(){var thisInstance=this,switchButtons=this.getContainer().find(".dashboardWidgetHeader .js-switch--calculations");thisInstance.setUrlSwitch(switchButtons),switchButtons.on("change",function(e){var currentElement=$(e.currentTarget),dashboardWidgetHeader=currentElement.closest(".dashboardWidgetHeader"),drefresh=dashboardWidgetHeader.find(".js-widget-refresh");thisInstance.setUrlSwitch(currentElement).done(function(data){data&&drefresh.click();});});},setUrlSwitch:function(switchButtons){var aDeferred=jQuery.Deferred();return switchButtons.each(function(index,e){var currentElement=jQuery(e),dashboardWidgetHeader=currentElement.closest(".dashboardWidgetHeader"),drefresh=dashboardWidgetHeader.find(".js-widget-refresh"),url=drefresh.data("url"),urlparams=currentElement.data("urlparams");if(""!==urlparams){var switchUrl=currentElement.data("url-value");url=url.replace("&"+urlparams+"="+switchUrl,""),url+="&"+urlparams+"="+switchUrl,drefresh.data("url",url),aDeferred.resolve(!0);}else aDeferred.reject();}),aDeferred.promise()},getFilterData:function(){return {}},/**
		 * Refresh widget
		 * @returns {undefined}
		 */refreshWidget:function(){var thisInstance=this,parent=this.getContainer(),element=parent.find(".js-widget-refresh"),url=element.data("url"),contentContainer=parent.find(".dashboardWidgetContent"),params=url,widgetFilters=parent.find(".widgetFilter");0<widgetFilters.length&&(params={},params.url=url,params.data={},widgetFilters.each(function(index,domElement){var widgetFilter=$(domElement),filterName=widgetFilter.attr("name");params.data[filterName]="checkbox"===widgetFilter.attr("type")?widgetFilter.is(":checked"):widgetFilter.val();}));var additionalWidgetFilters=parent.find(".js-chartFilter__additional-filter-field");0<additionalWidgetFilters.length&&(params={},params.url=url,params.data={},additionalWidgetFilters.each(function(index,domElement){var widgetFilter=jQuery(domElement),filterName=widgetFilter.attr("name"),arr=!1;"[]"===filterName.substr(-2)&&(arr=!0,filterName=filterName.substr(0,filterName.length-2),!Array.isArray(params.data[filterName])&&(params.data[filterName]=[])),"checkbox"===widgetFilter.attr("type")?arr?params.data[filterName].push(widgetFilter.is(":checked")):params.data[filterName]=widgetFilter.is(":checked"):arr?params.data[filterName].push(widgetFilter.val()):params.data[filterName]=widgetFilter.val();}));var refreshContainer=this.getContainerContent(),refreshContainerFooter=parent.find(".dashboardWidgetFooter");this.clear(),refreshContainer.progressIndicator(),this.paramCache&&(additionalWidgetFilters.length||widgetFilters.length||parent.find(".listSearchContributor"))&&thisInstance.setFilterToCache(params.url?params.url:params,params.data?params.data:{}),AppConnector.request(params).done(function(data){data=$(data);var footer=data.filter(".widgetFooterContent");refreshContainer.progressIndicator({mode:"hide"}),footer.length&&(footer=footer.clone(!0,!0),refreshContainerFooter.html(footer),data.each(function(n){jQuery(this).hasClass("widgetFooterContent")&&data.splice(n,1);})),contentContainer.html(data).trigger(YetiForce_Widget_Js.widgetPostRefereshEvent);}).fail(function(){refreshContainer.progressIndicator({mode:"hide"});});},clear:function(){this.getContainerContent().html(""),this.getContainer().find(".dashboardWidgetFooter").html("");},registerFilter:function(){var container=this.getContainer(),search=container.find(".listSearchContributor"),refreshBtn=container.find(".js-widget-refresh"),originalUrl=refreshBtn.data("url"),selects=container.find(".select2noactive");search.css("width","100%"),search.parent().addClass("w-100"),search.each(function(index,element){var fieldInfo=$(element).data("fieldinfo");$(element).attr("placeholder",fieldInfo.label).data("placeholder",fieldInfo.label);}),App.Fields.Picklist.changeSelectElementView(selects,"select2",{containerCssClass:"form-control"}),App.Fields.Date.register(container),App.Fields.Date.registerRange(container),App.Fields.DateTime.register(container),search.on("change apply.daterangepicker",function(){var searchParams=[];container.find(".listSearchContributor").each(function(index,domElement){var searchInfo=[],searchContributorElement=$(domElement),fieldInfo=searchContributorElement.data("fieldinfo"),fieldName=searchContributorElement.attr("name"),searchValue=searchContributorElement.val();if("object"===_typeof(searchValue)?null==searchValue?searchValue="":searchValue=searchValue.join("##"):0<=$.inArray(fieldInfo.type,["tree"])&&(searchValue=searchValue.replace(/,/g,"##")),searchValue=searchValue.trim(),0>=searchValue.length)//continue
return !0;var searchOperator="a";if(fieldInfo.hasOwnProperty("searchOperator")?searchOperator=fieldInfo.searchOperator:0<=jQuery.inArray(fieldInfo.type,["modules","time","userCreator","owner","picklist","tree","boolean","fileLocationType","userRole","multiReferenceValue","currencyList"])?searchOperator="e":"date"===fieldInfo.type||"datetime"===fieldInfo.type?searchOperator="bw":("multipicklist"===fieldInfo.type||"categoryMultipicklist"===fieldInfo.type)&&(searchOperator="c"),searchInfo.push(fieldName),searchInfo.push(searchOperator),searchInfo.push(searchValue),-1!=$.inArray(fieldInfo.type,["tree","categoryMultipicklist"])){var searchInSubcategories=$(".listViewHeaders .searchInSubcategories[data-columnname=\""+fieldName+"\"]").prop("checked");searchInSubcategories&&(searchOperator="ch");}searchParams.push(searchInfo);});var url=originalUrl+"&search_params="+JSON.stringify([searchParams]);refreshBtn.data("url",url),refreshBtn.trigger("click");});},registerFilterChangeEvent:function(){var container=this.getContainer();container.on("change",".widgetFilter",function(){container.find(".js-widget-refresh").trigger("click");}),container.find(".widgetFilterByField").length&&(App.Fields.Picklist.showSelect2ElementView(container.find(".select2noactive")),this.getContainer().on("change",".widgetFilterByField .form-control",function(){container.find(".js-widget-refresh").trigger("click");}));},registerWidgetPostLoadEvent:function(container){var thisInstance=this;container.on(YetiForce_Widget_Js.widgetPostLoadEvent,function(){thisInstance.postLoadWidget();});},registerWidgetPostRefreshEvent:function(container){var thisInstance=this;container.off(YetiForce_Widget_Js.widgetPostRefereshEvent),container.on(YetiForce_Widget_Js.widgetPostRefereshEvent,function(){thisInstance.postRefreshWidget();});},registerLoadMore:function(){var thisInstance=this,parent=thisInstance.getContainer(),contentContainer=parent.find(".dashboardWidgetContent");contentContainer.off("click",".showMoreHistory"),contentContainer.on("click",".showMoreHistory",function(e){var element=jQuery(e.currentTarget);element.hide();var parent=jQuery(e.delegateTarget).closest(".dashboardWidget");jQuery(parent).find(".slimScrollDiv").css("overflow","visible");var url=element.data("url")+"&content=true",additionalFilter=parent.find(".widgetFilter");0<additionalFilter.length&&additionalFilter.each(function(){url+="&"+$(this).attr("name")+"="+$(this).val();}),0<parent.find(".changeRecordSort").length&&(url+="&sortorder="+parent.find(".changeRecordSort").data("sort")),contentContainer.progressIndicator(),AppConnector.request(url).done(function(data){contentContainer.progressIndicator({mode:"hide"}),jQuery(parent).find(".dashboardWidgetContent").append(data),element.parent().remove(),thisInstance.postRefreshWidget();});});},setFilterToCache:function(url,data){var paramCache=url,container=this.getContainer();for(var i in paramCache=paramCache.replace("&content=","&notcontent="),data)"object"==_typeof(data[i])&&(data[i]=JSON.stringify(data[i])),paramCache+="&"+i+"="+data[i];var userId=CONFIG.userId,name=container.attr("id");app.cacheSet(name+"_"+userId,paramCache);},registerCache:function(container){1==container.data("cache")&&(this.paramCache=!0);}}),Vtiger_Widget_Js("YetiForce_Widget_Js",{},{}),YetiForce_Widget_Js("YetiForce_Calendar_Widget_Js",{},{calendarView:!1,calendarCreateView:!1,fullCalendar:!1,/**
		 * Register calendar
		 */registerCalendar:function registerCalendar(){var _this2=this,self=this,container=this.getContainer(),userTimeFormat=CONFIG.hourFormat;//Default time format
userTimeFormat=24==userTimeFormat?{hour:"2-digit",minute:"2-digit",hour12:!1,meridiem:!1}:{hour:"numeric",minute:"2-digit",meridiem:"short"};//Default first hour of the day
var defaultFirstHour=app.getMainParams("startHour"),explodedTime=defaultFirstHour.split(":");defaultFirstHour=explodedTime[0];var defaultDate=app.getMainParams("defaultDate");this.paramCache&&defaultDate!=moment().format("YYYY-MM-DD")&&(defaultDate=1==moment(defaultDate).format("D")?moment(defaultDate):moment(defaultDate).add(1,"M")),container.find(".js-widget-quick-create").on("click",function(){App.Components.QuickCreate.createRecord($(this).data("module-name"));}),this.fullCalendar=new FullCalendar.Calendar(this.getCalendarView().get(0),{headerToolbar:{left:" ",center:"prev title next",right:" "},initialDate:defaultDate,eventTimeFormat:userTimeFormat,slotLabelFormat:userTimeFormat,scrollTime:defaultFirstHour,firstDay:CONFIG.firstDayOfWeekNo,initialView:"dayGridMonth",editable:!1,slotDuration:15,defaultTimedEventDuration:"01:00:00",dayMaxEventRows:!1,allDaySlot:!1,moreLinkContent:app.vtranslate("JS_MORE"),allDayText:app.vtranslate("JS_ALL_DAY"),noEventsText:app.vtranslate("JS_NO_RECORDS"),viewHint:"$0",contentHeight:"auto",buttonText:{today:"",year:app.vtranslate("JS_YEAR"),week:app.vtranslate("JS_WEEK"),month:app.vtranslate("JS_MONTH"),day:app.vtranslate("JS_DAY"),dayGridMonth:app.vtranslate("JS_MONTH"),dayGridWeek:app.vtranslate("JS_WEEK"),listWeek:app.vtranslate("JS_WEEK"),dayGridDay:app.vtranslate("JS_DAY"),timeGridDay:app.vtranslate("JS_DAY")},navLinkHint:function navLinkHint(_dateStr,zonedDate){return App.Fields.Date.dateToUserFormat(zonedDate)},dayHeaderContent:function dayHeaderContent(arg){var dayOfTheWeek=arg.date.getDay();return "dayGridMonth"===arg.view.type&&(dayOfTheWeek=arg.date.getUTCDay()),App.Fields.Date.daysTranslated[dayOfTheWeek]},titleFormat:function titleFormat(args){return Calendar_Js.monthFormat[CONFIG.dateFormat].replace("YYYY",args.date.year).replace("MMMM",App.Fields.Date.fullMonthsTranslated[args.date.month])},dateClick:function dateClick(args){var date=moment(args.date).format(CONFIG.dateFormat.toUpperCase());App.Components.QuickCreate.createRecord("Calendar",{noCache:!0,data:{date_start:date,due_date:date},callbackFunction:function callbackFunction(){self.getCalendarView().closest(".dashboardWidget").find(".js-widget-refresh").trigger("click");}});},eventClick:function eventClick(info){info.jsEvent.preventDefault();var url=$(info.el).attr("href");if(void 0!==url){var params=[];url+="&viewname="+container.find("select.widgetFilter.customFilter").val();var owner=container.find(".widgetFilter.owner option:selected");if("all"!=owner.val()&&params.push(["assigned_user_id","e",owner.val()]),0<container.find(".widgetFilterSwitch").length){var status=container.find(".widgetFilterSwitch").data();params.push(["activitystatus","e",status[container.find(".widgetFilterSwitch").val()]]);}var date=App.Fields.Date.dateToUserFormat(info.event.start);params.push(["activitytype","e",info.event.extendedProps.activityType],["date_start","bw",date+" 00:00:00,"+date+" 23:59:59"]),url+="&search_params="+encodeURIComponent(JSON.stringify([params])),window.location.href="".concat(url);}}}),this.fullCalendar.render(),this.getCalendarView().find("td.fc-day-top").on("mouseenter",function(){jQuery("<span class=\"plus pull-left fas fa-plus\"></span>").prependTo($(this));}).on("mouseleave",function(){$(this).find(".plus").remove();});var switchBtn=container.find(".js-switch--calendar");switchBtn.on("change",function(e){var currentTarget=$(e.currentTarget);"undefined"==typeof currentTarget.data("on-text")?"undefined"!=typeof currentTarget.data("off-text")&&container.find(".widgetFilterSwitch").val("history"):container.find(".widgetFilterSwitch").val("current"),_this2.refreshWidget();});},/**
		 * Load calendar data
		 */loadCalendarData:function loadCalendarData(){var _this3=this;this.fullCalendar.removeAllEvents();var start_date=App.Fields.Date.dateToUserFormat(this.fullCalendar.view.activeStart),end_date=App.Fields.Date.dateToUserFormat(this.fullCalendar.view.activeEnd),parent=this.getContainer(),user=parent.find(".owner").val();"all"==user&&(user="");var params={module:"Calendar",action:"Calendar",mode:"getEvents",start:start_date,end:end_date,user:user,widget:!0};0<parent.find(".customFilter").length&&(params.customFilter=parent.find(".customFilter").val());var widgetFilterSwitch=parent.find(".widgetFilterSwitch");if(0<widgetFilterSwitch.length){params.time=widgetFilterSwitch.val();var defaultFilter=widgetFilterSwitch.data("default-filter");defaultFilter!==void 0&&(params.customFilter=defaultFilter);}this.paramCache&&this.setFilterToCache(this.getContainer().find(".js-widget-refresh").data("url"),{owner:user,customFilter:params.customFilter,start:start_date}),AppConnector.request(params).done(function(events){_this3.fullCalendar.addEventSource(events.result);});},/**
		 * Get calendar view container
		 * @returns {jQuery}
		 */getCalendarView:function getCalendarView(){return !1===this.calendarView&&(this.calendarView=this.getContainer().find(".js-calendar__container")),this.calendarView},/**
		 * Update month name
		 */getMonthName:function getMonthName(){var month=this.getCalendarView().find(".fc-toolbar h2").text();month&&this.getContainer().find(".headerCalendar .month").html("<h3>"+month+"</h3>");},/**
		 * Register change view
		 */registerChangeView:function registerChangeView(){var thisInstance=this,container=this.getContainer();container.find(".fc-toolbar").addClass("d-none");var month=container.find(".fc-toolbar h2").text();if(month){container.find(".headerCalendar").removeClass("d-none").find(".month").append("<h3>"+month+"</h3>");var button=container.find(".headerCalendar button");button.each(function(){var tag=jQuery(this).data("type");jQuery(this).on("click",function(){thisInstance.getCalendarView().find(".fc-toolbar ."+tag).trigger("click"),thisInstance.loadCalendarData(),thisInstance.getMonthName();});});}},/** @inheritdoc */loadScrollbar:function(){this.fullCalendar&&this.fullCalendar.updateSize(),this._super();},/** @inheritdoc */postLoadWidget:function postLoadWidget(){this.registerCalendar(),this.loadCalendarData(!0),this.registerChangeView(),this.registerFilterChangeEvent(),this.registerResize();},/** @inheritdoc */refreshWidget:function refreshWidget(){var thisInstance=this,refreshContainer=this.getContainer().find(".dashboardWidgetContent");refreshContainer.progressIndicator(),thisInstance.loadCalendarData(),refreshContainer.progressIndicator({mode:"hide"});}}),YetiForce_Widget_Js("YetiForce_CalendarActivities_Widget_Js",{},{modalView:!1,postLoadWidget:function postLoadWidget(){this._super(),this.registerActivityChange(),this.registerListViewButton();},postRefreshWidget:function postRefreshWidget(){this._super(),this.registerActivityChange();},registerActivityChange:function registerActivityChange(){var thisInstance=this,refreshContainer=this.getContainer().find(".dashboardWidgetContent");refreshContainer.find(".changeActivity").on("click",function(e){if(!(jQuery(e.target).is("a")||thisInstance.modalView)){var url=jQuery(this).data("url");if("undefined"!=typeof url){var callbackFunction=function(){thisInstance.modalView=!1;};thisInstance.modalView=!0,app.showModalWindow(null,url,callbackFunction);}}});},registerListViewButton:function registerListViewButton(){var thisInstance=this,container=thisInstance.getContainer();container.find(".goToListView").on("click",function(){var status,activitiesStatus=container.data("name");status="OverdueActivities"===activitiesStatus?"PLL_OVERDUE":"CalendarActivities"===activitiesStatus?"PLL_IN_REALIZATION##PLL_PLANNED":"PLL_IN_REALIZATION##PLL_PLANNED##PLL_OVERDUE";var url="index.php?module=Calendar&view=List&viewname=All";url+="&search_params=[[";var owner=container.find(".widgetFilter.owner option:selected");"all"!==owner.val()&&(url+="[\"assigned_user_id\",\"e\",\""+owner.val()+"\"],"),url+="[\"activitystatus\",\"e\",\""+encodeURIComponent(status)+"\"]]]",window.location.href=url;});}}),YetiForce_CalendarActivities_Widget_Js("YetiForce_CreatedNotMineActivities_Widget_Js",{},{}),YetiForce_CalendarActivities_Widget_Js("YetiForce_CreatedNotMineOverdueActivities_Widget_Js",{},{}),YetiForce_CalendarActivities_Widget_Js("YetiForce_OverDueActivities_Widget_Js",{},{}),YetiForce_CalendarActivities_Widget_Js("YetiForce_OverdueActivities_Widget_Js",{},{}),YetiForce_Widget_Js("YetiForce_ProductsSoldToRenew_Widget_Js",{},{modalView:!1,postLoadWidget:function postLoadWidget(){this._super(),this.registerAction(),this.registerListViewButton();},postRefreshWidget:function postRefreshWidget(){this._super(),this.registerAction();},registerAction:function registerAction(){var thisInstance=this,refreshContainer=this.getContainer().find(".dashboardWidgetContent");refreshContainer.find(".rowAction").on("click",function(e){if(!(jQuery(e.target).is("a")||thisInstance.modalView)){var url=jQuery(this).data("url");if("undefined"!=typeof url){var callbackFunction=function(){thisInstance.modalView=!1;};thisInstance.modalView=!0,app.showModalWindow(null,url,callbackFunction);}}});},registerListViewButton:function registerListViewButton(){var thisInstance=this,container=thisInstance.getContainer();container.on("click",".goToListView",function(){var url=jQuery(this).data("url"),orderBy=container.find(".orderby"),sortOrder=container.find(".changeRecordSort");orderBy.length&&(url+="&orderby="+orderBy.val()),sortOrder.length&&(url+="&sortorder="+sortOrder.data("sort").toUpperCase()),window.location.href=url;});}}),YetiForce_ProductsSoldToRenew_Widget_Js("YetiForce_ServicesSoldToRenew_Widget_Js",{},{}),YetiForce_Widget_Js("YetiForce_History_Widget_Js",{},{postLoadWidget:function postLoadWidget(){this._super(),this.registerLoadMore();},postRefreshWidget:function postRefreshWidget(){this._super(),this.registerLoadMore();},registerLoadMore:function registerLoadMore(){var thisInstance=this,parent=thisInstance.getContainer(),contentContainer=parent.find(".dashboardWidgetContent"),loadMoreHandler=contentContainer.find(".load-more");loadMoreHandler.on("click",function(){var parent=thisInstance.getContainer(),element=parent.find(".js-widget-refresh"),url=element.data("url"),params=url,widgetFilters=parent.find(".widgetFilter");0<widgetFilters.length&&(params={url:url,data:{}},widgetFilters.each(function(index,domElement){var widgetFilter=jQuery(domElement),filterName=widgetFilter.attr("name"),filterValue=widgetFilter.val();params.data[filterName]=filterValue;}));var filterData=thisInstance.getFilterData();jQuery.isEmptyObject(filterData)||("string"==typeof params&&(params={url:url,data:{}}),params.data=jQuery.extend(params.data,thisInstance.getFilterData())),params.data.page=loadMoreHandler.data("nextpage");var refreshContainer=parent.find(".dashboardWidgetContent");refreshContainer.progressIndicator(),AppConnector.request(params).done(function(data){refreshContainer.progressIndicator({mode:"hide"}),loadMoreHandler.replaceWith(data),thisInstance.registerLoadMore();}).fail(function(){refreshContainer.progressIndicator({mode:"hide"});});});}}),YetiForce_Widget_Js("YetiForce_MiniList_Widget_Js",{},{postLoadWidget:function postLoadWidget(){this.restrictContentDrag(),this.registerFilter(),this.registerFilterChangeEvent(),this.registerRecordsCount(),this.registerResize();},postRefreshWidget:function postRefreshWidget(){this.registerRecordsCount();}}),YetiForce_Widget_Js("YetiForce_UpcomingEvents_Widget_Js",{},{postLoadWidget:function postLoadWidget(){this.registerFilterChangeEvent(),this.registerResize();}}),YetiForce_Widget_Js("YetiForce_Notebook_Widget_Js",{},{// Override widget specific functions.
postLoadWidget:function postLoadWidget(){this.registerNotebookEvents();},registerNotebookEvents:function registerNotebookEvents(){var _this4=this;this.container.on("click",".dashboard_notebookWidget_edit",function(){_this4.editNotebookContent();}),this.container.on("click",".dashboard_notebookWidget_save",function(){_this4.saveNotebookContent();});},editNotebookContent:function editNotebookContent(){$(".dashboard_notebookWidget_view",this.container).hide();var editContainer=$(".dashboard_notebookWidget_text",this.container).show(),editTextArea=editContainer.find("textarea");editTextArea.css("height",this.container.innerHeight()-this.container.find(".dashboardWidgetHeader").innerHeight()-editTextArea.prev().innerHeight()-16);},saveNotebookContent:function saveNotebookContent(){var _this5=this,textarea=$(".dashboard_notebookWidget_textarea",this.container),url=this.container.data("url"),params=url+"&content=true&mode=save&contents="+encodeURIComponent(textarea.val()),refreshContainer=this.container.find(".dashboardWidgetContent");refreshContainer.progressIndicator(),AppConnector.request(params).done(function(data){refreshContainer.progressIndicator({mode:"hide"}),$(".dashboardWidgetContent",_this5.container).html(data);});}}),YetiForce_Widget_Js("YetiForce_Multifilter_Widget_Js",{},{multifilterControlsView:!1,multifilterContentView:!1,multifilterSettingsView:!1,registerSubmit:function registerSubmit(){var _this6=this;this.getContainer().find(".js-multifilter-save").on("click",function(){var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),widgetId=_this6.getMultifilterControls().attr("data-widgetid"),actions=_this6.getContainer().find(".js-select").val();AppConnector.request({action:"Widget",mode:"updateWidgetConfig",module:app.getModuleName(),widgetid:widgetId,widgetData:{customMultiFilter:actions}}).done(function(){progressIndicatorElement.progressIndicator({mode:"hide"}),_this6.refreshWidget();});});},loadData:function loadData(){var _this7=this,widgetId=this.getMultifilterControls().attr("data-widgetid"),multifilterIds=this.getMultifilterSettings().find(".js-select option:selected"),params=[];this.getMultifilterContent().html(""),$.each(multifilterIds,function(i,e){var element=$(e),existFilter=_this7.getMultifilterContent().find("[data-id=\""+element.val()+"\"]");return !!(0<existFilter.length)||void params.push({module:element.data("module"),modulename:element.data("module"),view:"ShowWidget",name:"Multifilter",content:!0,widget:!0,widgetid:widgetId,filterid:element.val()})}),this.loadListData(params);},loadListData:function loadListData(params){if(!params.length)return !1;var self=this,multiFilterContent=self.getMultifilterContent(),param=params.shift();AppConnector.request(param).done(function(data){self.getMultifilterSettings().find("option[value=\""+param.filterid+"\"]").is(":selected")&&!multiFilterContent.find(".detailViewTable[data-id=\""+param.filterid+"\"]").length&&(self.registerRecordsCount(multiFilterContent.append(data).children("div:last-child")),self.registerShowHideBlocks(),self.loadListData(params));}).fail(function(error){app.errorLog(error),self.loadListData(params);});},registerShowHideModuleSettings:function registerShowHideModuleSettings(){var _this8=this;this.getMultifilterControls().find(".js-widget-settings").on("click",function(){_this8.getMultifilterSettings().toggleClass("d-none");});},registerShowHideBlocks:function registerShowHideBlocks(){var detailContentsHolder=this.getMultifilterContent();detailContentsHolder.find(".blockHeader").off("click"),detailContentsHolder.find(".blockHeader").click(function(){var currentTarget=$(this).find(".js-block-toggle").not(".d-none"),closestBlock=currentTarget.closest(".js-toggle-panel"),bodyContents=closestBlock.find(".blockContent"),data=currentTarget.data();"show"==data.mode?(function hideHandler(){bodyContents.addClass("d-none");}(),currentTarget.addClass("d-none"),closestBlock.find("[data-mode=\"hide\"]").removeClass("d-none")):(function showHandler(){bodyContents.removeClass("d-none");}(),currentTarget.addClass("d-none"),closestBlock.find("[data-mode='show']").removeClass("d-none"));});},registerRecordsCount:function registerRecordsCount(container){var url=container.data("url");AppConnector.request(url).done(function(data){container.find(".js-count").html(data.result.totalCount);});},getMultifilterControls:function getMultifilterControls(){return !1==this.multifilterControlsView&&(this.multifilterControlsView=this.getContainer().find(".js-multifilterControls")),this.multifilterControlsView},getMultifilterContent:function getMultifilterContent(){return !1==this.multifilterContentView&&(this.multifilterContentView=this.getContainer().find(".js-multifilterContent")),this.multifilterContentView},getMultifilterSettings:function getMultifilterSettings(){return !1==this.multifilterSettingsView&&(this.multifilterSettingsView=this.getContainer().find(".js-settings-widget")),this.multifilterSettingsView},postLoadWidget:function postLoadWidget(){this.loadData(),this.registerSubmit(),this.registerShowHideModuleSettings();},refreshWidget:function refreshWidget(){this.loadData();}}),YetiForce_Widget_Js("YetiForce_UpcomingProjectTasks_Widget_Js",{},{postLoadWidget:function postLoadWidget(){this._super(),this.registerListViewButton();},registerListViewButton:function registerListViewButton(){var container=this.getContainer();container.find(".goToListView").on("click",function(){var url="index.php?module=ProjectTask&view=List&viewname=All";url+="&search_params=[[";var owner=container.find(".widgetFilter.owner option:selected");"all"!==owner.val()&&(url+="[\"assigned_user_id\",\"e\",\""+owner.val()+"\"],"),url+="[\"projecttaskstatus\",\"e\",\""+encodeURIComponent(container.find("[name=\"status\"]").data("value"))+"\"]]]",app.openUrl(url);});}}),YetiForce_UpcomingProjectTasks_Widget_Js("YetiForce_CompletedProjectTasks_Widget_Js",{},{}),YetiForce_Widget_Js("YetiForce_Updates_Widget_Js",{},{postLoadWidget:function postLoadWidget(){this._super(),this.registerEvents(),this.registerLoadMore();},postRefreshWidget:function postRefreshWidget(){this._super(),this.registerContentEvents(this.getContainer()),app.registerPopoverEllipsisIcon(this.getContainer().find(".js-popover-tooltip--ellipsis-icon"));},registerEvents:function registerEvents(){var container=this.getContainer(),self=this,modalContainer=container.find(".js-update-widget-modal");app.registerPopoverEllipsisIcon(container.find(".js-popover-tooltip--ellipsis-icon")),container.find(".js-update-widget-button").on("click",function(){var modal=modalContainer.clone(!0),widgetData=JSON.parse(container.find(".js-widget-data").val());if(widgetData){for(var i in widgetData.actions)modal.find(".js-tracker-action[value=\""+widgetData.actions[i]+"\"]").prop("checked",!0);modal.find("[name=\"owner\"]").val(widgetData.owner),modal.find("[name=\"historyOwner\"]").val(widgetData.historyOwner);}App.Fields.Picklist.showSelect2ElementView(modal.find("select")),app.showModalWindow(modal,function(data){self.registerSubmit(data);});}),this.registerContentEvents(container);},registerSubmit:function registerSubmit(data){var _this9=this;data.find(".js-modal__save").on("click",function(){var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),actions=[];$.each(data.find(".js-tracker-action:checked"),function(){actions.push($(this).val());}),AppConnector.request({action:"Widget",mode:"saveUpdatesWidgetConfig",module:"ModTracker",widgetId:_this9.getContainer().find(".js-widget-id").val(),trackerActions:actions,owner:data.find("[name=\"owner\"]").val(),historyOwner:data.find("[name=\"historyOwner\"]").val()}).done(function(){progressIndicatorElement.progressIndicator({mode:"hide"}),_this9.refreshWidget(),app.hideModalWindow();});});},registerContentEvents:function registerContentEvents(){var _this10=this,container=this.getContainer();$(".js-history-detail",container).on("click",function(e){var actionId=e.currentTarget.dataset.action,widgetData=JSON.parse(container.find(".js-widget-data").val()),progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params={view:"UpdatesDetail",module:"ModTracker",widgetId:_this10.getContainer().find(".js-widget-id").val(),trackerAction:e.currentTarget.dataset.action,sourceModule:e.currentTarget.dataset.module,owner:widgetData.owner,historyOwner:widgetData.historyOwner,dateRange:container.find("[name=\"dateRange\"]").val(),page:1};AppConnector.request(params).done(function(modal){progressIndicatorElement.progressIndicator({mode:"hide"}),app.showModalWindow(modal,function(data){data.on("click",".showMoreHistory",function(e){AppConnector.request(e.currentTarget.dataset.url).done(function(result){$(e.target).parent().remove(),data.find(".modal-body").append($(result).filter(".modal-body").get(0).childNodes);});});});}).fail(function(error){progressIndicatorElement.progressIndicator({mode:"hide"}),app.errorLog(error);});});}}),YetiForce_Widget_Js("YetiForce_TimeCounter_Widget_Js",{},{/** @type {number} Hours of the timer */hr:0,/** @type {number} Timer minutes */min:0,/** @type {number} Seconds of the timer */sec:0,/** @type {boolean} Starting a timer */counter:!0,/** @type {(string|number)} Time to start work */timeStart:"",/** @type {(string|number)} End of work time */timeStop:"",/**
		 * Show quick create form
		 */postLoadWidget:function postLoadWidget(){this._super(),this.registerNavigatorButtons();},/**
		 * Register events on the navigation buttons.
		 */registerNavigatorButtons:function registerNavigatorButtons(){var _this11=this,container=this.getContainer(),btnStart=container.find(".js-time-counter-start"),btnStop=container.find(".js-time-counter-stop"),btnReset=container.find(".js-time-counter-reset"),navigatorButtons=container.find(".js-navigator-buttons"),btnMinutes=container.find(".js-time-counter-minute");btnStart.on("click",function(){navigatorButtons.addClass("active"),btnStart.addClass("d-none"),btnStop.removeClass("d-none"),btnReset.removeClass("d-none"),btnMinutes.attr("disabled",!0),btnMinutes.removeClass("btn-outline-success"),btnMinutes.addClass("btn-outline-danger"),_this11.startTimerCounter();}),btnStop.on("click",function(){_this11.stopTimerCounter(!1);}),btnReset.on("click",function(){navigatorButtons.removeClass("active"),btnReset.addClass("d-none"),btnStop.addClass("d-none"),btnStart.removeClass("d-none"),btnMinutes.attr("disabled",!1),btnMinutes.removeClass("btn-outline-danger"),btnMinutes.addClass("btn-outline-success"),_this11.resetTimerCounter();}),0<btnMinutes.length&&btnMinutes.on("click",function(e){_this11.counter=!1;var element=$(e.currentTarget);_this11.min=element.data("value");var dateEnd=new Date,hours=(10>dateEnd.getHours()?"0":"")+dateEnd.getHours(),minutes=(10>dateEnd.getMinutes()?"0":"")+dateEnd.getMinutes();_this11.timeStop=hours+":"+minutes,_this11.stopTimerCounter(!0);});},/**
		 * Time counting starts
		 */startTimerCounter:function startTimerCounter(){var dateStart=new Date,hours=(10>dateStart.getHours()?"0":"")+dateStart.getHours(),minutes=(10>dateStart.getMinutes()?"0":"")+dateStart.getMinutes();this.timeStart=hours+":"+minutes,!0===this.counter&&(this.counter=!1,this.timeCounter());},/**
		 * Time counting ends.
		 * @param {boolean} $afterTime
		 */stopTimerCounter:function stopTimerCounter($afterTime){if(!1===this.counter){this.counter=!0;var quickCreateParams={},customParams={};$afterTime?this.setStopAfterTime():this.setStopBeforeTime(),customParams.time_start=this.timeStart,customParams.time_end=this.timeStop,quickCreateParams.data=customParams,quickCreateParams.noCache=!0,App.Components.QuickCreate.createRecord("OSSTimeControl",quickCreateParams);}},/**
		 * Sets the end time before ending the call.
		 */setStopBeforeTime:function setStopBeforeTime(){(30<parseInt(this.sec)||0===parseInt(this.min))&&(this.min=parseInt(this.min)+1);var dateStart=new Date;dateStart.setHours(this.timeStart.split(":")[0]),dateStart.setMinutes(this.timeStart.split(":")[1]),dateStart.setHours(dateStart.getHours()+parseInt(this.hr)),dateStart.setMinutes(dateStart.getMinutes()+parseInt(this.min));var hours=(10>dateStart.getHours()?"0":"")+dateStart.getHours(),minutes=(10>dateStart.getMinutes()?"0":"")+dateStart.getMinutes();this.timeStop=hours+":"+minutes,this.sec=0,this.min=0,this.hr=0;},/**
		 * Sets the end time after ending the call.
		 */setStopAfterTime:function setStopAfterTime(){var dateEnd=new Date;dateEnd.setHours(this.timeStop.split(":")[0]),dateEnd.setMinutes(this.timeStop.split(":")[1]),dateEnd.setHours(dateEnd.getHours()-parseInt(this.hr)),dateEnd.setMinutes(dateEnd.getMinutes()-parseInt(this.min));var hours=(10>dateEnd.getHours()?"0":"")+dateEnd.getHours(),minutes=(10>dateEnd.getMinutes()?"0":"")+dateEnd.getMinutes();this.timeStart=hours+":"+minutes,this.sec=0,this.min=0,this.hr=0;},/**
		 * Resets the counting operation.
		 */resetTimerCounter:function resetTimerCounter(){!1===this.counter&&(this.counter=!0,this.sec=0,this.min=0,this.hr=0),this.getContainer().find(".js-time-counter").html("00:00:00");},/**
		 * Counting time from the moment of starting work.
		 */timeCounter:function timeCounter(){var _this12=this;!1===this.counter&&(this.sec=parseInt(this.sec),this.min=parseInt(this.min),this.hr=parseInt(this.hr),++this.sec,60===this.sec&&(++this.min,this.sec=0),60===this.min&&(++this.hr,this.min=0,this.sec=0),(10>this.sec||0===this.sec)&&(this.sec="0"+this.sec),(10>this.min||0===this.min)&&(this.min="0"+this.min),(10>this.hr||0===this.hr)&&(this.hr="0"+this.hr),this.getContainer().find(".js-time-counter").html(this.hr+":"+this.min+":"+this.sec),setTimeout(function(){_this12.timeCounter();},1e3));}});
//# sourceMappingURL=Widget.min.js.map
