<?php

/**
 * No permitted for admin exception class.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

namespace App\Exceptions;

use App\Anonymization;
use App\Db;
use App\Request;
use App\RequestUtil;
use App\Session;
use App\TextUtils;
use yii\db\Exception;

class NoPermittedForAdmin extends Security
{
	/**
	 * Constructor.
	 *
	 * @param string          $message
	 * @param int             $code
	 * @param \Exception|null $previous
	 *
	 * @throws Exception
	 */
	public function __construct($message = '', $code = 406, ?\Exception $previous = null)
	{
		parent::__construct($message, $code, $previous);
		Session::init();
		$request = Request::init();
		$userName = Session::get('full_user_name');
		$data = [
			'username' => empty($userName) ? '-' : $userName,
			'date' => date('Y-m-d H:i:s'),
			'ip' => TextUtils::textTruncate(RequestUtil::getRemoteIP(), 100, false),
			'module' => $request->getModule(),
			'url' => TextUtils::textTruncate(RequestUtil::getBrowserInfo()->url, 300, false),
			'agent' => TextUtils::textTruncate(Request::_getServer('HTTP_USER_AGENT', '-'), 500, false),
			'request' => json_encode((new Anonymization())->setModuleName($request->getModule())->setData($_REQUEST)->anonymize()->getData()),
			'referer' => TextUtils::textTruncate(Request::_getServer('HTTP_REFERER', '-'), 300, false),
		];
		Db::getInstance('log')->createCommand()->insert('o_#__access_for_admin', $data)->execute();
	}
}
