<?php

/**
 * No permitted to api exception class.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

namespace App\Exceptions;

use App\Anonymization;
use App\Db;
use App\Request;
use App\RequestUtil;
use App\Session;
use App\TextUtils;

class NoPermittedToApi extends Security
{
	/** {@inheritdoc} */
	public function __construct($message = '', $code = 406, ?\Throwable $previous = null)
	{
		parent::__construct($message, $code, $previous);
		Session::init();
		\Api\Core\Request::init();
		$userName = Session::get('full_user_name');
		Db::getInstance('log')->createCommand()
			->insert('o_#__access_for_api', [
				'username' => empty($userName) ? '-' : $userName,
				'date' => date('Y-m-d H:i:s'),
				'ip' => TextUtils::textTruncate(RequestUtil::getRemoteIP(), 100, false),
				'url' => TextUtils::textTruncate(RequestUtil::getBrowserInfo()->url, 300, false),
				'agent' => TextUtils::textTruncate(Request::_getServer('HTTP_USER_AGENT', '-'), 500, false),
				'request' => json_encode((new Anonymization())->setModuleName($_REQUEST['module'] ?? '')->setData($_REQUEST)->anonymize()->getData()),
			])->execute();
	}

	/**
	 * Display message.
	 *
	 * @param string $message
	 */
	public function stop(string $message)
	{
		echo json_encode($message);
	}
}
