<?php

/**
 * No Permitted to record exception file.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

namespace App\Exceptions;

use App\Anonymization;
use App\DB;
use App\Request;
use App\RequestUtil;
use App\Session;
use App\TextUtils;

/**
 * No Permitted to record exception class.
 */
class NoPermittedToRecord extends NoPermitted
{
	public function __construct($message = '', $code = 406, ?\Exception $previous = null)
	{
		parent::__construct($message, $code, $previous);
		Session::init();

		$request = Request::init();
		$record = $request->getInteger('record', 0);
		$userName = Session::get('full_user_name');
		DB::getInstance('log')->createCommand()->insert('o_#__access_to_record', [
			'username' => empty($userName) ? '-' : $userName,
			'date' => date('Y-m-d H:i:s'),
			'ip' => TextUtils::textTruncate(RequestUtil::getRemoteIP(), 100, false),
			'record' => $record,
			'module' => $request->getModule(),
			'url' => TextUtils::textTruncate(RequestUtil::getBrowserInfo()->url, 300, false),
			'agent' => TextUtils::textTruncate(Request::_getServer('HTTP_USER_AGENT', '-'), 500, false),
			'request' => json_encode((new Anonymization())->setModuleName($request->getModule())->setData($_REQUEST)->anonymize()->getData()),
			'referer' => TextUtils::textTruncate(Request::_getServer('HTTP_REFERER', '-'), 300, false),
		])->execute();
	}
}
