<?php
/**
 * KSeF InvoiceQueue Model class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Model\Client;

/**
 * KSeF InvoiceQueue Model class.
 */
final class InvoiceQueue
{
	/** @var int|null Queue record ID */
	private ?int $id = null;

	/** @var int|null Invoice record ID */
	private ?int $invoiceRecordId = null;

	/** @var int|null Settings ID */
	private ?int $settingsId = null;

	/** @var int|null Queue status */
	private ?int $status = null;

	/** @var string|null KSeF session key */
	private ?string $sessionKey = null;

	/** @var string|null KSeF invoice key */
	private ?string $invoiceKey = null;

	/** @var string|null KSeF number */
	private ?string $ksefNumber = null;

	/** @var int|null Mode */
	private ?int $mode = null;

	/** @var string|null Date when record was created */
	private ?string $dateInput = null;

	/** @var string|null Date of acquisition */
	private ?string $dateAcquisition = null;

	/** @var string|null Date when record was last modified */
	private ?string $dateMod = null;

	/** @var int|null Ordinal number for batch sending */
	private ?int $ordinalNumber = null;

	/**
	 * Get queue record ID.
	 *
	 * @return int|null
	 */
	public function getId(): ?int
	{
		return $this->id;
	}

	/**
	 * Set queue record ID.
	 *
	 * @param int|null $id
	 *
	 * @return self
	 */
	public function setId(?int $id): self
	{
		$this->id = $id;
		return $this;
	}

	/**
	 * Get invoice record ID.
	 *
	 * @return int|null
	 */
	public function getInvoiceRecordId(): ?int
	{
		return $this->invoiceRecordId;
	}

	/**
	 * Set invoice record ID.
	 *
	 * @param int|null $invoiceRecordId
	 *
	 * @return self
	 */
	public function setInvoiceRecordId(?int $invoiceRecordId): self
	{
		$this->invoiceRecordId = $invoiceRecordId;
		return $this;
	}

	/**
	 * Get settings ID.
	 *
	 * @return int|null
	 */
	public function getSettingsId(): ?int
	{
		return $this->settingsId;
	}

	/**
	 * Set settings ID.
	 *
	 * @param int|null $settingsId
	 *
	 * @return self
	 */
	public function setSettingsId(?int $settingsId): self
	{
		$this->settingsId = $settingsId;
		return $this;
	}

	/**
	 * Get queue status.
	 *
	 * @return int|null
	 */
	public function getStatus(): ?int
	{
		return $this->status;
	}

	/**
	 * Set queue status.
	 *
	 * @param int|null $status
	 *
	 * @return self
	 */
	public function setStatus(?int $status): self
	{
		$this->status = $status;
		return $this;
	}

	/**
	 * Get KSeF session key.
	 *
	 * @return string|null
	 */
	public function getSessionKey(): ?string
	{
		return $this->sessionKey;
	}

	/**
	 * Set KSeF session key.
	 *
	 * @param string|null $sessionKey
	 *
	 * @return self
	 */
	public function setSessionKey(?string $sessionKey): self
	{
		$this->sessionKey = $sessionKey;
		return $this;
	}

	/**
	 * Get KSeF invoice key.
	 *
	 * @return string|null
	 */
	public function getInvoiceKey(): ?string
	{
		return $this->invoiceKey;
	}

	/**
	 * Set KSeF invoice key.
	 *
	 * @param string|null $invoiceKey
	 *
	 * @return self
	 */
	public function setInvoiceKey(?string $invoiceKey): self
	{
		$this->invoiceKey = $invoiceKey;
		return $this;
	}

	/**
	 * Get KSeF number.
	 *
	 * @return string|null
	 */
	public function getKsefNumber(): ?string
	{
		return $this->ksefNumber;
	}

	/**
	 * Set KSeF number.
	 *
	 * @param string|null $ksefNumber
	 *
	 * @return self
	 */
	public function setKsefNumber(?string $ksefNumber): self
	{
		$this->ksefNumber = $ksefNumber;
		return $this;
	}

	/**
	 * Get mode.
	 *
	 * @return int|null
	 */
	public function getMode(): ?int
	{
		return $this->mode;
	}

	/**
	 * Set mode.
	 *
	 * @param int|null $mode
	 *
	 * @return self
	 */
	public function setMode(?int $mode): self
	{
		$this->mode = $mode;
		return $this;
	}

	/**
	 * Get date input.
	 *
	 * @return string|null
	 */
	public function getDateInput(): ?string
	{
		return $this->dateInput;
	}

	/**
	 * Set date input.
	 *
	 * @param string|null $dateInput
	 *
	 * @return self
	 */
	public function setDateInput(?string $dateInput): self
	{
		$this->dateInput = $dateInput;
		return $this;
	}

	/**
	 * Get date of acquisition.
	 *
	 * @return string|null
	 */
	public function getDateAcquisition(): ?string
	{
		return $this->dateAcquisition;
	}

	/**
	 * Set date of acquisition.
	 *
	 * @param string|null $dateAcquisition
	 *
	 * @return self
	 */
	public function setDateAcquisition(?string $dateAcquisition): self
	{
		$this->dateAcquisition = $dateAcquisition;
		return $this;
	}

	/**
	 * Get date modified.
	 *
	 * @return string|null
	 */
	public function getDateMod(): ?string
	{
		return $this->dateMod;
	}

	/**
	 * Set date modified.
	 *
	 * @param string|null $dateMod
	 *
	 * @return self
	 */
	public function setDateMod(?string $dateMod): self
	{
		$this->dateMod = $dateMod;
		return $this;
	}

	/**
	 * Get ordinal number.
	 *
	 * @return int|null
	 */
	public function getOrdinalNumber(): ?int
	{
		return $this->ordinalNumber;
	}

	/**
	 * Set ordinal number.
	 *
	 * @param int|null $ordinalNumber
	 *
	 * @return self
	 */
	public function setOrdinalNumber(?int $ordinalNumber): self
	{
		$this->ordinalNumber = $ordinalNumber;
		return $this;
	}
}
