<?php
/**
 * KSeF Config Model class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Model\Connector;

/**
 * KSeF Config Model class.
 */
final class Config
{
	/** @var string|null Configuration key */
	private ?string $key = null;

	/** @var string|null Configuration value */
	private ?string $value = null;

	/** @var bool|null Is required flag */
	private ?bool $isRequired = null;

	/** @var string|null Configuration label */
	private ?string $label = null;

	/**
	 * Get configuration key.
	 *
	 * @return string|null
	 */
	public function getKey(): ?string
	{
		return $this->key;
	}

	/**
	 * Set configuration key.
	 *
	 * @param string|null $key
	 *
	 * @return self
	 */
	public function setKey(?string $key): self
	{
		$this->key = $key;
		return $this;
	}

	/**
	 * Get configuration value.
	 *
	 * @return string|null
	 */
	public function getValue(): ?string
	{
		return $this->value;
	}

	/**
	 * Set configuration value.
	 *
	 * @param string|null $value
	 *
	 * @return self
	 */
	public function setValue(?string $value): self
	{
		$this->value = $value;
		return $this;
	}

	/**
	 * Get is required flag.
	 *
	 * @return bool|null
	 */
	public function getIsRequired(): ?bool
	{
		return $this->isRequired;
	}

	/**
	 * Set is required flag.
	 *
	 * @param bool|null $isRequired
	 *
	 * @return self
	 */
	public function setIsRequired(?bool $isRequired): self
	{
		$this->isRequired = $isRequired;
		return $this;
	}

	/**
	 * Get configuration label.
	 *
	 * @return string|null
	 */
	public function getLabel(): ?string
	{
		return $this->label;
	}

	/**
	 * Set configuration label.
	 *
	 * @param string|null $label
	 *
	 * @return self
	 */
	public function setLabel(?string $label): self
	{
		$this->label = $label;
		return $this;
	}
}
